{**
 * Fichier: /modules/salesmanager/override/pdf/invoice.product-tab.tpl
 * Override du template de la tab produits dans les factures PDF
 * Ce fichier permet d'afficher les informations de soldes dans les factures
 *}

<table class="product" width="100%" cellpadding="4" cellspacing="0">

  <thead>
      <tr>
          <th class="product header small" width="20%">{l s='Reference' d='Shop.Pdf' pdf='true'}</th>
          <th class="product header small" width="30%">{l s='Product' d='Shop.Pdf' pdf='true'}</th>
          {if !$tax_excluded_display}
              <th class="product header small" width="12%">{l s='Unit Price' d='Shop.Pdf' pdf='true'} <br />{l s='(Tax incl.)' d='Shop.Pdf' pdf='true'}</th>
              <th class="product header small" width="8%">{l s='Qty' d='Shop.Pdf' pdf='true'}</th>
              <th class="product header small" width="15%">{l s='Total' d='Shop.Pdf' pdf='true'} <br />{l s='(Tax incl.)' d='Shop.Pdf' pdf='true'}</th>
          {else}
              <th class="product header small" width="12%">{l s='Unit Price' d='Shop.Pdf' pdf='true'} <br />{l s='(Tax excl.)' d='Shop.Pdf' pdf='true'}</th>
              <th class="product header small" width="8%">{l s='Qty' d='Shop.Pdf' pdf='true'}</th>
              <th class="product header small" width="15%">{l s='Total' d='Shop.Pdf' pdf='true'} <br />{l s='(Tax excl.)' d='Shop.Pdf' pdf='true'}</th>
          {/if}
      </tr>
  </thead>

  <tbody>
    {foreach from=$order_invoice->getProducts() item=product}
      <tr class="product">
          <td class="product center small">
              <span class="product-reference">{$product.product_reference}</span>
          </td>
          <td class="product">
              <table width="100%">
                  <tr>
                      <td width="5%" style="vertical-align: top;">
                          {if $product.image_path}
                              <img src="{$product.image_path}" alt="{$product.product_name}" />
                          {/if}
                      </td>
                      <td width="95%" style="vertical-align: top;">
                          <span class="product-name">{$product.product_name}</span>
                          {if isset($product.sale_data) && $product.sale_data}
                              <div class="product-info-sale" style="font-size: 8px; color: #ff0000;">
                                  <span class="sale-discount-percentage"> -{$product.sale_percentage}%</span>
                              </div>
                          {/if}
                          {if isset($product.product_attributes) && $product.product_attributes}
                              <div style="font-size: 8px; font-style: italic;">
                                  <table width="100%" cellpadding="0" cellspacing="0">
                                      {foreach from=$product.product_attributes item=attribute}
                                          <tr>
                                              <td width="30%">{$attribute.attribute_name|string_format:{l s='%s:' d='Shop.Pdf' pdf='true'}}</td>
                                              <td width="70%">{$attribute.attribute_value}</td>
                                          </tr>
                                      {/foreach}
                                  </table>
                              </div>
                          {/if}
                      </td>
                  </tr>
              </table>
              {* Display customizations *}
              {if isset($product.customizations) && $product.customizations}
                  <table width="100%" cellpadding="0" cellspacing="0" style="margin-top: 5px;">
                      <tr>
                          <td style="font-size: 9px; font-weight: bold; padding-top: 5px;">
                              {l s='Customization' d='Shop.Pdf' pdf='true'}
                          </td>
                      </tr>
                      {foreach from=$product.customizations item=customization}
                          <tr>
                              <td style="padding-left: 10px;">
                                  {if isset($customization.datas[Product::CUSTOMIZE_TEXTFIELD]) && count($customization.datas[Product::CUSTOMIZE_TEXTFIELD]) > 0}
                                      {foreach from=$customization.datas[Product::CUSTOMIZE_TEXTFIELD] item=customization_infos}
                                          {if isset($customization_infos.name) && $customization_infos.name}
                                              <span class="label">{$customization_infos.name}:</span>
                                          {/if}
                                          <span>{$customization_infos.value}</span>
                                      {/foreach}
                                  {/if}
                                  {if isset($customization.datas[Product::CUSTOMIZE_FILE]) && count($customization.datas[Product::CUSTOMIZE_FILE]) > 0}
                                      <span>{l s='image(s):' d='Shop.Pdf' pdf='true'}</span>
                                      <span>{count($customization.datas[Product::CUSTOMIZE_FILE])}</span>
                                  {/if}
                              </td>
                          </tr>
                      {/foreach}
                  </table>
              {/if}
          </td>
          <td class="product center small" style="text-align: right;">
              {if $tax_excluded_display}
                  {if isset($product.sale_data) && $product.sale_data}
                      <span style="text-decoration: line-through;">{Tools::displayPrice($product.original_unit_price_tax_excl, $currency)}</span><br>
                  {/if}
                  {Tools::displayPrice($product.unit_price_tax_excl, $currency)}
              {else}
                  {if isset($product.sale_data) && $product.sale_data}
                      <span style="text-decoration: line-through;">{Tools::displayPrice($product.original_unit_price_tax_incl, $currency)}</span><br>
                  {/if}
                  {Tools::displayPrice($product.unit_price_tax_incl, $currency)}
              {/if}
          </td>
          <td class="product center small">
              {$product.product_quantity}
          </td>
          <td class="product center small" style="text-align: right;">
              {if $tax_excluded_display}
                  {if isset($product.sale_data) && $product.sale_data}
                      <span style="text-decoration: line-through;">{Tools::displayPrice($product.original_total_price_tax_excl, $currency)}</span><br>
                  {/if}
                  {Tools::displayPrice($product.total_price_tax_excl, $currency)}
              {else}
                  {if isset($product.sale_data) && $product.sale_data}
                      <span style="text-decoration: line-through;">{Tools::displayPrice($product.original_total_price_tax_incl, $currency)}</span><br>
                  {/if}
                  {Tools::displayPrice($product.total_price_tax_incl, $currency)}
              {/if}
          </td>
      </tr>
      {if isset($product.customizations) && $product.customizations}
        <tr>
            <td colspan="{if $tax_excluded_display}5{else}5{/if}" style="padding-top: 5px;">
                <table width="100%" cellpadding="0" cellspacing="0">
                    {foreach from=$product.customizations item=customization}
                        <tr>
                            <td style="font-size: 9px; font-weight: bold;">
                                {l s='Customization' d='Shop.Pdf' pdf='true'}
                            </td>
                        </tr>
                        {foreach from=$customization.datas[Product::CUSTOMIZE_TEXTFIELD] item=customization_infos}
                            <tr>
                                <td style="width: 30%;">
                                    {$customization_infos.name|string_format:{l s='%s:' d='Shop.Pdf' pdf='true'}}
                                </td>
                                <td>{$customization_infos.value}</td>
                            </tr>
                        {/foreach}
                        {if isset($customization.datas[Product::CUSTOMIZE_FILE]) && count($customization.datas[Product::CUSTOMIZE_FILE]) > 0}
                            <tr>
                                <td style="width: 30%;">{l s='image(s):' d='Shop.Pdf' pdf='true'}</td>
                                <td>{count($customization.datas[Product::CUSTOMIZE_FILE])}</td>
                            </tr>
                        {/if}
                    {/foreach}
                </table>
            </td>
        </tr>
    {/if}
    {/foreach}
  </tbody>
</table>