{* Fichier: /modules/salesmanager/views/templates/admin/product_tab.tpl *}
<div class="panel panel-default">
    <div class="panel-heading">
        <i class="icon-tag"></i> {l s='Gestion des Soldes' mod='salesmanager'}
    </div>
    <div class="panel-body">
        <div class="form-group">
            <label class="control-label col-lg-3">
                {l s='Activer les soldes' mod='salesmanager'}
            </label>
            <div class="col-lg-9">
                <span class="switch prestashop-switch fixed-width-lg">
                    <input type="radio" name="sale_active" id="sale_active_on" value="1" 
                           {if isset($sale_data.active) && $sale_data.active}checked{/if}>
                    <label for="sale_active_on">{l s='Oui' mod='salesmanager'}</label>
                    <input type="radio" name="sale_active" id="sale_active_off" value="0" 
                           {if !isset($sale_data.active) || !$sale_data.active}checked{/if}>
                    <label for="sale_active_off">{l s='Non' mod='salesmanager'}</label>
                    <a class="slide-button btn"></a>
                </span>
            </div>
        </div>

        <div id="sale_settings" {if !isset($sale_data.active) || !$sale_data.active}style="display:none;"{/if}>
            <div class="form-group">
                <label class="control-label col-lg-3">
                    {l s='Type de démarque' mod='salesmanager'}
                </label>
                <div class="col-lg-9">
                    <select name="sale_type" class="form-control">
                        {foreach $sale_types as $key => $label}
                            <option value="{$key}" {if isset($sale_data.sale_type) && $sale_data.sale_type == $key}selected{/if}>{$label}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
            
            <div class="form-group">
                <label class="control-label col-lg-3">
                    {l s='Pourcentage de solde' mod='salesmanager'}
                </label>
                <div class="col-lg-9">
                    <div class="input-group">
                        <input type="number" name="sale_percentage" class="form-control" min="5" max="95" step="5"
                               value="{if isset($sale_data.sale_percentage)}{$sale_data.sale_percentage}{else}10{/if}">
                        <span class="input-group-addon">%</span>
                    </div>
                </div>
            </div>

            <hr>
            <h4>{l s='Personnalisation du badge' mod='salesmanager'}</h4>
            <div class="form-group">
                <label class="control-label col-lg-3">
                    {l s='Couleur du fond' mod='salesmanager'}
                </label>
                <div class="col-lg-9">
                    <input type="color" name="badge_bg_color" 
                           value="{if isset($sale_data.badge_bg_color)}{$sale_data.badge_bg_color}{else}#FF0000{/if}" class="form-control">
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-lg-3">
                    {l s='Couleur du texte' mod='salesmanager'}
                </label>
                <div class="col-lg-9">
                    <input type="color" name="badge_text_color" 
                           value="{if isset($sale_data.badge_text_color)}{$sale_data.badge_text_color}{else}#FFFFFF{/if}" class="form-control">
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-lg-3">
                    {l s='Couleur du prix' mod='salesmanager'}
                </label>
                <div class="col-lg-9">
                    <input type="color" name="price_color" 
                           value="{if isset($sale_data.price_color)}{$sale_data.price_color}{else}#FF0000{/if}" class="form-control">
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-lg-3">
                    {l s='Aperçu du badge' mod='salesmanager'}
                </label>
                <div class="col-lg-9">
                    <div id="sale_badge_preview" style="background-color: {if isset($sale_data.badge_bg_color)}{$sale_data.badge_bg_color}{else}#FF0000{/if}; color: {if isset($sale_data.badge_text_color)}{$sale_data.badge_text_color}{else}#FFFFFF{/if};">
                        {l s='SOLDES' mod='salesmanager'} -{if isset($sale_data.sale_percentage)}{$sale_data.sale_percentage}{else}10{/if}%
                    </div>
                </div>
            </div>

            <hr>
            <h4>{l s='Période de validité (optionnel)' mod='salesmanager'}</h4>

            <div class="form-group">
                <label class="control-label col-lg-3">
                    {l s='Date de début' mod='salesmanager'}
                </label>
                <div class="col-lg-9">
                    <input type="datetime-local" name="sale_date_from" 
                           value="{if isset($sale_data.date_from) && $sale_data.date_from}{$sale_data.date_from|date_format:'Y-m-d\\TH:i'}{/if}" 
                           class="form-control">
                    <div class="help-block">
                        {l s='Laissez vide pour activer immédiatement' mod='salesmanager'}
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-lg-3">
                    {l s='Date de fin' mod='salesmanager'}
                </label>
                <div class="col-lg-9">
                    <input type="datetime-local" name="sale_date_to" 
                           value="{if isset($sale_data.date_to) && $sale_data.date_to}{$sale_data.date_to|date_format:'Y-m-d\\TH:i'}{/if}" 
                           class="form-control">
                    <div class="help-block">
                        {l s='Laissez vide pour une durée illimitée' mod='salesmanager'}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>