// Fichier: /modules/salesmanager/views/js/admin.js

$(document).ready(function() {
    // Toggle sale settings visibility
    $('input[name="sale_active"]').on('change', function() {
        if ($(this).val() == '1') {
            $('#sale_settings').slideDown(300);
        } else {
            $('#sale_settings').slideUp(300);
        }
    });

    // Live preview of badge
    function updatePreview() {
        var percentage = $('input[name="sale_percentage"]').val();
        var bgColor = $('input[name="badge_bg_color"]').val();
        var textColor = $('input[name="badge_text_color"]').val();
        var saleType = $('select[name="sale_type"] option:selected').text();
        
        // Update preview if exists
        if ($('#sale_badge_preview').length) {
            $('#sale_badge_preview').css({
                'background-color': bgColor,
                'color': textColor
            });
            
            // Update text based on sale type
            var previewText = 'SOLDES -' + percentage + '%';
            if (saleType && saleType !== 'Autre') {
                previewText = saleType.toUpperCase() + ' -' + percentage + '%';
            }
            
            $('#sale_badge_preview').text(previewText);
        }
    }

    // Bind events for live preview
    $('input[name="sale_percentage"], input[name="badge_bg_color"], input[name="badge_text_color"], select[name="sale_type"]').on('change input', function() {
        updatePreview();
    });

    // Validation du pourcentage
    $('input[name="sale_percentage"]').on('change', function() {
        var val = parseInt($(this).val());
        if (val < 5) $(this).val(5);
        if (val > 95) $(this).val(95);
        
        // Arrondir au multiple de 5 le plus proche
        var rounded = Math.round(val / 5) * 5;
        $(this).val(rounded);
    });

    // Validation des dates
    $('input[name="sale_date_from"], input[name="sale_date_to"]').on('change', function() {
        var dateFrom = $('input[name="sale_date_from"]').val();
        var dateTo = $('input[name="sale_date_to"]').val();
        
        if (dateFrom && dateTo) {
            var from = new Date(dateFrom);
            var to = new Date(dateTo);
            
            if (from >= to) {
                alert('La date de fin doit être postérieure à la date de début');
                $('input[name="sale_date_to"]').val('');
            }
        }
    });

    // Animation au chargement
    if ($('input[name="sale_active"]:checked').val() == '1') {
        $('#sale_settings').show();
        updatePreview();
    }
});