{**
 * Fichier: /modules/salesmanager/override/pdf/invoice.product-tab.tpl
 * Override du template de la tab produits dans les factures PDF
 * Ce fichier permet d'afficher les informations de soldes dans les factures
 *}

<table class="product" width="100%" cellpadding="4" cellspacing="0">

    <thead>
        <tr>
            <th class="product header small" width="20%">{l s='Reference' d='Shop.Pdf' pdf='true'}</th>
            <th class="product header small" width="30%">{l s='Product' d='Shop.Pdf' pdf='true'}</th>
            {if !$tax_excluded_display}
                <th class="product header small" width="12%">{l s='Unit Price' d='Shop.Pdf' pdf='true'} <br />{l s='(Tax incl.)' d='Shop.Pdf' pdf='true'}</th>
            {else}
                <th class="product header small" width="12%">{l s='Unit Price' d='Shop.Pdf' pdf='true'} <br />{l s='(Tax excl.)' d='Shop.Pdf' pdf='true'}</th>
            {/if}
            <th class="product header small" width="8%">{l s='Qty' d='Shop.Pdf' pdf='true'}</th>
            {if !$tax_excluded_display}
                <th class="product header small" width="15%">{l s='Total' d='Shop.Pdf' pdf='true'} <br />{l s='(Tax incl.)' d='Shop.Pdf' pdf='true'}</th>
            {else}
                <th class="product header small" width="15%">{l s='Total' d='Shop.Pdf' pdf='true'} <br />{l s='(Tax excl.)' d='Shop.Pdf' pdf='true'}</th>
            {/if}
            <th class="product header small" width="15%">{l s='Discount' d='Shop.Pdf' pdf='true'}</th>
        </tr>
    </thead>

    <tbody>

        {foreach $order_details as $order_detail}
            {cycle values=["color_line_even", "color_line_odd"] assign=bgcolor_class}
            <tr class="product {$bgcolor_class}">

                <td class="product left">
                    {if empty($order_detail.product_reference)}
                        ---
                    {else}
                        {$order_detail.product_reference}
                    {/if}
                </td>
                
                <td class="product left">
                    {if $display_product_images}
                        <table width="100%">
                            <tr>
                                <td width="15%">
                                    {if isset($order_detail.image) && $order_detail.image->id}
                                        {$order_detail.image_tag}
                                    {/if}
                                </td>
                                <td width="5%">&nbsp;</td>
                                <td width="80%">
                                    {$order_detail.product_name}
                                    {if isset($order_detail.sale_data) && $order_detail.sale_data}
                                        <br/>
                                        <small style="color: #FF0000;">
                                            <strong>{$order_detail.sale_type} -{$order_detail.sale_percentage}%</strong>
                                        </small>
                                    {/if}
                                </td>
                            </tr>
                        </table>
                    {else}
                        {$order_detail.product_name}
                        {if isset($order_detail.sale_data) && $order_detail.sale_data}
                            <br/>
                            <small style="color: #FF0000;">
                                <strong>{$order_detail.sale_type} -{$order_detail.sale_percentage}%</strong>
                            </small>
                        {/if}
                    {/if}
                </td>

                <td class="product center">
                    {if !$tax_excluded_display}
                        {if isset($order_detail.sale_data) && $order_detail.sale_data}
                            <span style="text-decoration: line-through; color: #999;">
                                {displayPrice currency=$order->id_currency price=$order_detail.original_price_tax_incl}
                            </span><br/>
                            <span style="color: #FF0000; font-weight: bold;">
                                {displayPrice currency=$order->id_currency price=$order_detail.unit_price_tax_incl}
                            </span>
                        {else}
                            {displayPrice currency=$order->id_currency price=$order_detail.unit_price_tax_incl}
                        {/if}
                    {else}
                        {if isset($order_detail.sale_data) && $order_detail.sale_data}
                            <span style="text-decoration: line-through; color: #999;">
                                {displayPrice currency=$order->id_currency price=$order_detail.original_price_tax_excl}
                            </span><br/>
                            <span style="color: #FF0000; font-weight: bold;">
                                {displayPrice currency=$order->id_currency price=$order_detail.unit_price_tax_excl}
                            </span>
                        {else}
                            {displayPrice currency=$order->id_currency price=$order_detail.unit_price_tax_excl}
                        {/if}
                    {/if}
                </td>

                <td class="product center">
                    {$order_detail.product_quantity}
                </td>

                <td class="product center">
                    {if !$tax_excluded_display}
                        {displayPrice currency=$order->id_currency price=$order_detail.total_price_tax_incl}
                    {else}
                        {displayPrice currency=$order->id_currency price=$order_detail.total_price_tax_excl}
                    {/if}
                </td>

                <td class="product center">
                    {if isset($order_detail.sale_data) && $order_detail.sale_data}
                        {if !$tax_excluded_display}
                            {displayPrice currency=$order->id_currency price=($order_detail.original_price_tax_incl - $order_detail.unit_price_tax_incl) * $order_detail.product_quantity}
                        {else}
                            {displayPrice currency=$order->id_currency price=($order_detail.original_price_tax_excl - $order_detail.unit_price_tax_excl) * $order_detail.product_quantity}
                        {/if}
                        <br/>
                        <small>({$order_detail.sale_percentage}%)</small>
                    {elseif (isset($order_detail.reduction_amount) && $order_detail.reduction_amount > 0)}
                        -{displayPrice currency=$order->id_currency price=$order_detail.reduction_amount}
                    {elseif (isset($order_detail.reduction_percent) && $order_detail.reduction_percent > 0)}
                        -{$order_detail.reduction_percent}%
                    {else}
                        --
                    {/if}
                </td>

            </tr>

            {foreach $order_detail.customizedDatas as $customizationPerAddress}
                {foreach $customizationPerAddress as $customizationId => $customization}
                    <tr class="customization_data {$bgcolor_class}">
                        <td class="center"> &nbsp;</td>

                        <td>
                            {if isset($customization.datas[Product::CUSTOMIZE_TEXTFIELD]) && count($customization.datas[Product::CUSTOMIZE_TEXTFIELD]) > 0}
                                <table style="width: 100%;">
                                    {foreach $customization.datas[Product::CUSTOMIZE_TEXTFIELD] as $customization_infos}
                                        <tr>
                                            <td style="width: 30%;">
                                                {$customization_infos.name|string_format:{l s='%s:' d='Shop.Pdf' pdf='true'}}
                                            </td>
                                            <td>{$customization_infos.value}</td>
                                        </tr>
                                    {/foreach}
                                </table>
                            {/if}

                            {if isset($customization.datas[Product::CUSTOMIZE_FILE]) && count($customization.datas[Product::CUSTOMIZE_FILE]) > 0}
                                <table style="width: 100%;">
                                    <tr>
                                        <td style="width: 30%;">{l s='image(s):' d='Shop.Pdf' pdf='true'}</td>
                                        <td>{count($customization.datas[Product::CUSTOMIZE_FILE])}</td>
                                    </tr>
                                </table>
                            {/if}
                        </td>

                        <td class="center">
                            ({if $customization.quantity == 0}1{else}{$customization.quantity}{/if})
                        </td>

                        <td class="center" colspan="3"></td>
                    </tr>
                {/foreach}
            {/foreach}

        {/foreach}

    </tbody>

</table>