<?php
/**
 * Fichier: /modules/salesmanager/override/classes/pdf/HTMLTemplateInvoice.php
 * Override pour afficher les informations de soldes sur les factures
 */

class HTMLTemplateInvoice extends HTMLTemplateInvoiceCore
{
    /**
     * Returns the template's HTML content
     *
     * @return string HTML content
     */
    public function getContent()
    {
        // Enrichit les détails de commande avec les informations de soldes
        $this->enrichOrderDetailsWithSalesData();

        // Récupération du contenu parent
        $content = parent::getContent();
        
        return $content;
    }

    /**
     * Enrichit les détails de commande avec les informations de soldes
     */
    protected function enrichOrderDetailsWithSalesData()
    {
        $id_lang = $this->order->id_lang;
        $order_details = $this->order_invoice->getProducts();
        
        $salesManager = Module::getInstanceByName('salesmanager');
        if (!$salesManager) {
            return;
        }

        foreach ($order_details as &$product) {
            $saleData = $salesManager->getSaleDataForProduct($product['product_id']);
            
            if ($saleData && $salesManager->isSaleActive($saleData)) {
                $product['sale_data'] = $saleData;
                $product['sale_percentage'] = $saleData['sale_percentage'];
                $product['sale_type'] = $salesManager->getSaleTypeLabel($saleData['sale_type']);

                // Calculer le prix original avant solde (TTC et HT)
                $originalPriceTaxIncl = $product['unit_price_tax_incl'] / (1 - $saleData['sale_percentage'] / 100);
                $originalPriceTaxExcl = $product['unit_price_tax_excl'] / (1 - $saleData['sale_percentage'] / 100);

                // Ajouter les prix originaux aux détails du produit
                $product['original_unit_price_tax_incl'] = $originalPriceTaxIncl;
                $product['original_unit_price_tax_excl'] = $originalPriceTaxExcl;

                $product['original_total_price_tax_incl'] = $originalPriceTaxIncl * $product['product_quantity'];
                $product['original_total_price_tax_excl'] = $originalPriceTaxExcl * $product['product_quantity'];

            } else {
                 $product['sale_data'] = false;
            }
        }
        
        $this->order_invoice->products = $order_details;
    }
}