<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

class Myrgpdmodule extends Module
{
    public function __construct()
    {
        $this->name = 'myrgpdmodule';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'SplineOnline';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = [
            'min' => '8.1.0',
            'max' => _PS_VERSION_,
        ];
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('My RGPD Module');
        $this->description = $this->l('A minimalist RGPD pop-up module.');
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall this module?');
    }

    public function install()
    {
        return parent::install() &&
               $this->registerHook('displayHeader') && // Nouveau hook
               $this->registerHook('displayFooter') &&
               Configuration::updateValue('MYRGPD_POPUP_ENABLED', 1) &&
               $this->registerHook('displayCustomerAccount') &&
               Configuration::updateValue('MYRGPD_POPUP_TEXT', 'Ce site utilise des cookies pour améliorer votre expérience. En continuant, vous acceptez notre politique de confidentialité.');
    }

    public function uninstall()
    {
        return parent::uninstall() &&
               Configuration::deleteByName('MYRGPD_POPUP_ENABLED') &&
               Configuration::deleteByName('MYRGPD_POPUP_TEXT');
    }

    public function getContent()
    {
        // Code inchangé par rapport à la réponse précédente
        $output = null;

        if (Tools::isSubmit('submit' . $this->name)) {
            $popupEnabled = (int)Tools::getValue('MYRGPD_POPUP_ENABLED');
            $popupText = (string)Tools::getValue('MYRGPD_POPUP_TEXT');

            if (empty($popupText) || !Validate::isCleanHtml($popupText)) {
                $output .= $this->displayError($this->l('Invalid Configuration value'));
            } else {
                Configuration::updateValue('MYRGPD_POPUP_ENABLED', $popupEnabled);
                Configuration::updateValue('MYRGPD_POPUP_TEXT', $popupText);
                $output .= $this->displayConfirmation($this->l('Settings updated'));
            }
        }
        return $output . $this->displayForm();
    }

    public function displayForm()
    {
        // Code inchangé par rapport à la réponse précédente
        $form = [
            'form' => [
                'legend' => [
                    'title' => $this->l('Settings'),
                ],
                'input' => [
                    [
                        'type' => 'switch',
                        'label' => $this->l('Enable RGPD Pop-up'),
                        'name' => 'MYRGPD_POPUP_ENABLED',
                        'is_bool' => true,
                        'values' => [
                            [
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Yes')
                            ],
                            [
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('No')
                            ]
                        ],
                    ],
                    [
                        'type' => 'textarea',
                        'label' => $this->l('Pop-up Text'),
                        'name' => 'MYRGPD_POPUP_TEXT',
                        'cols' => 60,
                        'rows' => 10,
                        'required' => true
                    ],
                ],
                'submit' => [
                    'title' => $this->l('Save'),
                ],
            ],
        ];

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submit' . $this->name;
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = [
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        ];

        return $helper->generateForm([$form]);
    }

    public function getConfigFieldsValues()
    {
        return [
            'MYRGPD_POPUP_ENABLED' => Tools::getValue('MYRGPD_POPUP_ENABLED', Configuration::get('MYRGPD_POPUP_ENABLED')),
            'MYRGPD_POPUP_TEXT' => Tools::getValue('MYRGPD_POPUP_TEXT', Configuration::get('MYRGPD_POPUP_TEXT')),
        ];
    }
    
    // Hook pour le JavaScript et CSS
    public function hookDisplayHeader()
    {
        if (Configuration::get('MYRGPD_POPUP_ENABLED')) {
            $this->context->controller->addCSS($this->_path . 'views/css/myrgpdmodule.css');
            $this->context->controller->addJS($this->_path . 'views/js/myrgpdmodule.js');
        }
    }

    public function hookDisplayCustomerAccount($params)
    {
    return $this->display(__FILE__, 'views/templates/hooks/my-account-link.tpl');
    }

    public function hookDisplayFooter($params)
    {
    $html = '';
    // Affiche le pop-up principal uniquement si l'utilisateur n'a pas encore de cookie de consentement
    if (Configuration::get('MYRGPD_POPUP_ENABLED') && !isset($_COOKIE['myrgpd_consent'])) {
        $this->context->smarty->assign([
            'myrgpd_logo_url' => $this->_path . 'logo.png',
            'myrgpd_popup_text' => Configuration::get('MYRGPD_POPUP_TEXT')
        ]);
        $html .= $this->display(__FILE__, 'views/templates/hooks/footer.tpl');
    }
    // Affiche toujours le template de la pop-up de préférences pour qu'il soit toujours disponible pour le lien
    $html .= $this->display(__FILE__, 'views/templates/hooks/preferences-modal.tpl');
    
    return $html;
    }
}