// views/js/back.js

$(document).ready(function() {
    // Initialiser TinyMCE avec configuration personnalisée
    if (typeof tinyMCE !== 'undefined') {
        tinyMCE.init({
            selector: 'textarea.rte',
            plugins: 'advlist autolink lists link image charmap preview anchor searchreplace visualblocks code fullscreen insertdatetime media table paste code help wordcount textcolor colorpicker',
            toolbar: 'undo redo | formatselect | bold italic underline strikethrough | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | removeformat | code | preview',
            height: 400,
            menubar: false,
            branding: false,
            convert_urls: false,
            entity_encoding: 'raw',
            extended_valid_elements: 'span[*],div[*],a[*],img[*]',
            valid_children: '+body[style]',
            content_css: [
                '//fonts.googleapis.com/css?family=Lato:300,300i,400,400i',
            ],
            setup: function(editor) {
                editor.on('change', function() {
                    editor.save();
                    updatePreview();
                });
            }
        });
    }
    
    // Gestion de l'upload d'image
    $('#newsletter_image').on('change', function(e) {
        var file = e.target.files[0];
        if (file) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#image-preview').html('');
            };
            reader.readAsDataURL(file);
        }
    });
    
    // Prévisualisation en temps réel
    function updatePreview() {
        var subject = $('#newsletter_subject').val();
        var content = tinyMCE.activeEditor ? tinyMCE.activeEditor.getContent() : $('#newsletter_content').val();
        
        var previewHtml = '
';
        previewHtml += '
' + (subject || 'Sujet de la newsletter') + '
';
        previewHtml += '
' + content + '
';
        previewHtml += '
';
        
        $('#newsletter-preview').html(previewHtml);
    }
    
    // Mise à jour de la prévisualisation lors de la saisie
    $('#newsletter_subject').on('keyup', updatePreview);
    
    // Fonction pour envoyer un email de test
    window.sendTestEmail = function() {
        var testEmail = prompt('Entrez l\'adresse email pour le test:', prestashop.config.email);
        
        if (testEmail) {
            var subject = $('#newsletter_subject').val();
            var content = tinyMCE.activeEditor ? tinyMCE.activeEditor.getContent() : $('#newsletter_content').val();
            
            $.ajax({
                url: currentIndex + '&token=' + token + '&ajax=1&action=sendTest',
                type: 'POST',
                data: {
                    test_email: testEmail,
                    subject: subject,
                    content: content
                },
                beforeSend: function() {
                    showLoading('Envoi en cours...');
                },
                success: function(response) {
                    hideLoading();
                    var data = JSON.parse(response);
                    if (data.success) {
                        showSuccess('Email de test envoyé à ' + testEmail);
                    } else {
                        showError('Erreur lors de l\'envoi: ' + data.error);
                    }
                },
                error: function() {
                    hideLoading();
                    showError('Erreur de connexion');
                }
            });
        }
    };
    
    // Fonction pour prévisualiser la newsletter
    window.previewNewsletter = function() {
        var subject = $('#newsletter_subject').val();
        var content = tinyMCE.activeEditor ? tinyMCE.activeEditor.getContent() : $('#newsletter_content').val();
        
        var previewWindow = window.open('', 'preview', 'width=600,height=700');
        
        $.ajax({
            url: currentIndex + '&token=' + token + '&ajax=1&action=preview',
            type: 'POST',
            data: {
                subject: subject,
                content: content
            },
            success: function(response) {
                previewWindow.document.write(response);
            },
            error: function() {
                previewWindow.close();
                showError('Erreur lors de la génération de la prévisualisation');
            }
        });
    };
    
    // Compteur de destinataires
    function updateRecipientCount() {
        $.ajax({
            url: currentIndex + '&token=' + token + '&ajax=1&action=getSubscribers',
            type: 'GET',
            success: function(response) {
                var data = JSON.parse(response);
                $('#recipient-count').html(
                    ' ' + data.count + ' destinataires'
                );
            }
        });
    }
    
    // Gestion des templates prédéfinis
    $('.template-card').on('click', function() {
        $('.template-card').removeClass('selected');
        $(this).addClass('selected');
        
        var templateId = $(this).data('template-id');
        loadTemplate(templateId);
    });
    
    function loadTemplate(templateId) {
        $.ajax({
            url: currentIndex + '&token=' + token + '&ajax=1&action=loadTemplate',
            type: 'GET',
            data: { template_id: templateId },
            success: function(response) {
                var data = JSON.parse(response);
                if (tinyMCE.activeEditor) {
                    tinyMCE.activeEditor.setContent(data.content);
                } else {
                    $('#newsletter_content').val(data.content);
                }
                updatePreview();
            }
        });
    }
    
    // Fonctions d'affichage des messages
    function showSuccess(message) {
        showMessage(message, 'success');
    }
    
    function showError(message) {
        showMessage(message, 'error');
    }
    
    function showMessage(message, type) {
        var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
        var html = '
';
        html += '×';
        html += message;
        html += '
';
        
        $('#message-container').html(html);
        
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 5000);
    }
    
    function showLoading(message) {
        $('#loading-overlay').show();
        $('#loading-message').text(message || 'Chargement...');
    }
    
    function hideLoading() {
        $('#loading-overlay').hide();
    }
    
    // Validation du formulaire
    $('form#newsletter-form').on('submit', function(e) {
        var subject = $('#newsletter_subject').val();
        var content = tinyMCE.activeEditor ? tinyMCE.activeEditor.getContent() : $('#newsletter_content').val();
        
        if (!subject || subject.trim() === '') {
            e.preventDefault();
            showError('Le sujet est requis');
            return false;
        }
        
        if (!content || content.trim() === '
' || content.trim() === '') {
            e.preventDefault();
            showError('Le contenu est requis');
            return false;
        }
        
        if ($(this).data('action') === 'send') {
            if (!confirm('Êtes-vous sûr de vouloir envoyer cette newsletter à tous les abonnés ?')) {
                e.preventDefault();
                return false;
            }
        }
    });
    
    // Initialisation
    updateRecipientCount();
    updatePreview();
    
    // Auto-save draft
    var autoSaveTimer;
    function autoSave() {
        clearTimeout(autoSaveTimer);
        autoSaveTimer = setTimeout(function() {
            var subject = $('#newsletter_subject').val();
            var content = tinyMCE.activeEditor ? tinyMCE.activeEditor.getContent() : $('#newsletter_content').val();
            
            if (subject || content) {
                $.ajax({
                    url: currentIndex + '&token=' + token + '&ajax=1&action=autoSave',
                    type: 'POST',
                    data: {
                        subject: subject,
                        content: content
                    },
                    success: function() {
                        $('#autosave-status').html(' Brouillon sauvegardé');
                    }
                });
            }
        }, 3000);
    }
    
    $('#newsletter_subject').on('keyup', autoSave);
});
    