<?php
/**
 * Classe pour représenter une campagne Newsletter
 */

class NewsletterCampaign extends ObjectModel
{
    public $id_campaign;
    public $subject;
    public $content;
    public $image_url;
    public $status;
    public $recipients_count;
    public $date_add;
    public $date_sent;

    public static $definition = [
        'table' => 'mynewsletter_campaigns',
        'primary' => 'id_campaign',
        'fields' => [
            'subject' => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true, 'size' => 255],
            'content' => ['type' => self::TYPE_HTML, 'validate' => 'isCleanHtml', 'required' => true],
            'image_url' => ['type' => self::TYPE_STRING, 'validate' => 'isUrl', 'required' => false, 'size' => 500],
            'status' => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true, 'size' => 20],
            'recipients_count' => ['type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => false],
            'date_add' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'required' => true],
            'date_sent' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'required' => false],
        ],
    ];
}