{* Template Live Shopping - CORRECTION WEBCAM *}

{* Vérification de connexion côté serveur *}
{if !$logged}
    <div class="live-shopping-message">
        <center><p>
            Bonjour, pour suivre le live, connectez vous au site obligatoirement. Merci
        </p></center>
    </div>
{else}
    
    <div id="live-shopping-wrapper" class="live-shopping-wrapper-online">
        
<!-- DEBUG INFO - À SUPPRIMER APRÈS TEST -->
<div style="background: #ffffcc; padding: 10px; margin: 10px; border: 1px solid #ccc; font-size: 12px;">
    <strong>DEBUG:</strong><br>
    webcam_enabled: {$webcam_enabled|default:'non défini'}<br>
    webcam_format: {$webcam_format|default:'non défini'}<br>
    logged: {if $logged}OUI{else}NON{/if}<br>
    module_dir: {$module_dir}<br>
</div>

        {* ================================================= *}
        {* 1. LOGO DU MODULE *}
        {* ================================================= *}
        <div style="text-align: center; margin-bottom: 20px; margin-top: 20px;">
            <img src="{$module_dir}logo.png" alt="Logo Live Shopping" style="width: 50px; height: 50px;">
            <br>
            <span style="font-weight: bold;">{$displayName}</span>
        </div>

        {* ================================================= *}
        {* 2. WEBCAM EN DIRECT (Même flux que l'admin) *}
        {* ================================================= *}
        <div id="live-webcam-container" class="live-webcam-wrapper" data-format="{$webcam_format|default:'landscape'}">
            <div class="webcam-display format-{$webcam_format|default:'landscape'}" id="webcam-display">
                
                {if $webcam_enabled}
                {* Player vidéo principal *}
                <video id="live-video-player" 
                       autoplay 
                       playsinline 
                       muted
                       style="width: 100%; height: 100%; object-fit: cover; display: none; background: #000;">
                </video>
                
                {* Bouton pour activer le son *}
                <button id="unmute-btn" 
                        style="position: absolute; bottom: 20px; right: 20px; z-index: 100; 
                               background: rgba(0,0,0,0.7); color: white; border: none; 
                               padding: 12px 20px; border-radius: 25px; cursor: pointer;
                               font-size: 14px; display: none; transition: all 0.3s;">
                    🔊 Activer le son
                </button>
                
                {* Indicateur LIVE *}
                <div id="live-indicator" 
                     style="position: absolute; top: 15px; left: 15px; z-index: 100;
                            background: #ff0000; color: white; padding: 6px 12px;
                            border-radius: 4px; font-size: 12px; font-weight: bold;
                            display: none; animation: pulse-live 2s infinite;">
                    🔴 LIVE
                </div>
                {/if}
                
                {* Placeholder *}
                <div id="webcam-placeholder" class="webcam-placeholder">
                    <div class="placeholder-content">
                        <div style="font-size: 48px; margin-bottom: 15px;">📹</div>
                        <p id="stream-status-text">
                            {if $webcam_enabled}
                                🔴 Connexion au stream...
                            {else}
                                ⏸️ Stream non démarré
                            {/if}
                        </p>
                        <p style="font-size:12px; opacity:0.7" id="stream-status-detail">
                            {if $webcam_enabled}
                                Chargement du flux en direct
                            {else}
                                En attente du présentateur
                            {/if}
                        </p>
                    </div>
                </div>
            </div>
        </div>

        {* ================================================= *}
        {* 3. BLOC TEXTE RICHE 1 (TOUJOURS EN DESSOUS de la webcam) *}
        {* ================================================= *}
        {if isset($live_rich_text) && !empty($live_rich_text)} 
        <div class="live-rich-text" style="text-align: center; margin: 0 auto 20px auto; max-width: 600px;">
            {$live_rich_text nofilter}
        </div>
        {/if}

        {* ================================================= *}
        {* 4. BLOC TEXTE RICHE 2 *}
        {* ================================================= *}
        {if isset($live_rich_text_2) && !empty($live_rich_text_2)}
        <div class="live-rich-text-2-footer" style="text-align: left; padding: 10px; margin: 0 auto 20px auto; max-width: 600px;">
            {$live_rich_text_2 nofilter} 
        </div>
        {/if}

        {* 5. COMPTEUR DE VIEWERS *}
        <div id="live_stats_container" style="max-width: 600px; margin: 0 auto 10px auto; background: white; border-radius: 12px; box-shadow: 0 3px 15px rgba(0,0,0,0.1); padding: 15px; display: flex; align-items: center; justify-content: center; gap: 15px;">
            <div class="viewer-dot" style="width: 12px; height: 12px; background: #ff0000; border-radius: 50%; animation: pulse-viewer 2s infinite;"></div>
            <span style="font-weight: 600; font-size: 16px; color: #333;">
                🔴 EN DIRECT
            </span>
            
            <div style="display: flex; align-items: center; gap: 6px; padding-left: 20px; border-left: 1px solid #e0e0e0;">
                <span style="font-size: 20px;">✓</span>
                <span id="viewers-logged" style="font-weight: 700; font-size: 18px; color: #28a745;">0</span>
                <span style="color: #999; font-size: 14px;">spectateurs</span>
            </div>
        </div>

        {* 6. MINICHAT *}
        <div id="minichat-widget-live" style="max-width: 600px; margin: 0 auto 20px auto; height: 500px; background: white; border-radius: 12px; box-shadow: 0 5px 25px rgba(0,0,0,0.2); display: flex; flex-direction: column;">
            <div class="minichat-header" style="background: linear-gradient(135deg, {Configuration::get('myliveshoppingmodule_CHAT_COLOR1')} 0%, {Configuration::get('myliveshoppingmodule_CHAT_COLOR2')} 100%); color: white; padding: 15px; border-radius: 12px 12px 0 0;">
                <span class="minichat-title" style="font-weight: 600; font-size: 16px;">💬 Discussion Live</span>
            </div>
            
            <div class="minichat-body" style="display: flex; flex-direction: column; flex: 1; overflow: hidden;">
                <div class="minichat-messages" id="live-chat-messages" style="flex: 1; overflow-y: auto; padding: 15px; background: #f8f9fa;">
                    <div class="minichat-loading" style="text-align: center; padding: 20px; color: #999;">Chargement des messages...</div>
                </div>
                
                <div class="minichat-input-wrapper" style="display: flex; padding: 10px; background: white; border-top: 1px solid #e0e0e0;">
                    <input type="text" 
                        id="live-chat-input" 
                        placeholder="Tapez votre message..." 
                        maxlength="200"
                        style="flex: 1; padding: 10px 15px; border: 1px solid #ddd; border-radius: 25px; outline: none; font-size: 14px;"
                        onkeypress="if(event.keyCode==13) LiveMiniChat.send()">
                    <button onclick="LiveMiniChat.send()" class="minichat-send" style="margin-left: 10px; width: 40px; height: 40px; padding: 0; background: linear-gradient(135deg, {Configuration::get('myliveshoppingmodule_CHAT_COLOR1')} 0%, {Configuration::get('myliveshoppingmodule_CHAT_COLOR2')} 100%); color: white; border: none; border-radius: 50%; cursor: pointer; font-size: 20px; display: flex; align-items: center; justify-content: center;">➤</button>
                </div>
                
                <div class="minichat-char-counter" style="padding: 0 15px 10px; font-size: 11px; color: #999; text-align: right; background: white; border-radius: 0 0 12px 12px;">
                    <span id="live-char-count">0</span> / 200
                </div>
            </div>
        </div>

        {* 7. ARTICLES (PRODUIT EN COURS + SLIDE) *}
        <div id="live-container"></div>

        {if isset($products_slide_list) && !empty($products_slide_list)}
            <div id="live-slide-products" class="live-slide-products">
                 <h3 style="text-align: center; font-size: 1.2em; margin-bottom: 15px; color: #333;">🚀 Les produits à venir dans le Live</h3>
                
                <div class="product-list-container" style="display: flex; overflow-x: auto; padding-bottom: 10px; gap: 15px; background: #f9f9f9; padding: 10px; border-radius: 5px;">
                    {foreach from=$products_slide_list item=product_slide}
                        {assign var="is_current" value=($product_slide.id == $live_product_id)}
                        <div class="slide-product-item {if $is_current}current-live-product{/if}" style="min-width: 150px; max-width: 150px; flex-shrink: 0; text-align: center; border: 1px solid {if $is_current}#00cc00{else}#ddd{/if}; padding: 10px; border-radius: 5px; background: {if $is_current}#e6ffe6{else}#fff{/if}; transition: all 0.3s ease;">
                            <a href="{$product_slide.link}" title="{$product_slide.name}">
                                {if $product_slide.image_url}
                                    <img src="{$product_slide.image_url}" alt="{$product_slide.name}" style="width: 100%; height: 100px; object-fit: contain; border-radius: 3px; margin-bottom: 5px;">
                                {else}
                                    <div style="height: 100px; line-height: 100px; background: #eee; border-radius: 3px;">[No Image]</div>
                                {/if}
                            </a>
                            <p style="margin: 5px 0 2px 0;">
                                <a href="{$product_slide.link}" title="{$product_slide.name}" style="color: #333; text-decoration: none; font-size: 0.9em;">
                                    {$product_slide.name|truncate:30:'...'}
                                </a>
                            </p>
                            <span class="product-price" style="color: {$custom_text_color}; font-weight: bold; font-size: 1em;">{$product_slide.price}</span>
                            {if $is_current}
                                <span style="display: block; color: #00cc00; font-size: 11px; margin-top: 5px; text-transform: uppercase;">🔴 **LIVE ACTUEL**</span>
                            {else if $product_slide.id != $live_product_id}
                                <span style="display: block; color: #999; font-size: 11px; margin-top: 5px;">Prochainement</span>
                            {/if}
                        </div>
                    {/foreach}
                </div>
             </div>
        {/if}

    </div>
{/if}

{* ================================================= *}
{* VARIABLES ET JAVASCRIPT ESSENTIEL *}
{* ================================================= *}

<script>
var prestashop = prestashop || {};
prestashop.static_token = '{Tools::getToken(false)|escape:'quotes'}';
prestashop.urls = prestashop.urls || {};
prestashop.urls.pages = {
    cart: '{$link->getPageLink('cart', true)|escape:'javascript'}',
    authentication: '{$link->getPageLink('authentication', true)|escape:'javascript'}'
};

var liveShoppingConfig = {
    ajaxUrl: '{$module_dir}ajax.php',
    streamUrl: '{$module_dir}ajax_stream.php',
    refreshInterval: 10000,
    maxRetries: 3,
    maxQuantity: parseInt({$max_qty_live|intval}, 10) || 2,
    isUserLoggedIn: {if $logged}true{else}false{/if},
    ajax_viewers_url: '{$ajax_viewers_url}',
    webcam_enabled: {$webcam_enabled|intval},
    webcam_format: '{$webcam_format|escape:'javascript'}'
};

var LiveMiniChat = {
    url: '{$module_dir}ajax_chat.php',
    isLogged: {if $logged}true{else}false{/if},
    customerId: {if isset($smarty.session.customer.id)}{$smarty.session.customer.id|intval}{else}0{/if},
    lastMessageId: 0,
    timer: null
};

var myls_csrf_token = '{$myls_csrf_token}';

// Compteur de Viewers
var LiveViewers = {
    url: liveShoppingConfig.ajax_viewers_url,
    timer: null,
    init: function() {
        var self = this;
        this.ping();
        this.timer = setInterval(function() { self.ping(); }, 15000);
    },
    ping: function() {
        var self = this;
        fetch(this.url + '?action=heartbeat', { method: 'POST' })
            .then(r => r.json())
            .then(data => { return fetch(self.url + '?action=getViewers'); })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    var el = document.getElementById('viewers-logged');
                    if (el) el.textContent = data.logged;
                }
            })
            .catch(e => console.error('Error Viewers', e));
    },
    stop: function() { if (this.timer) clearInterval(this.timer); }
};
</script>

{* ================================================= *}
{* STYLES CSS *}
{* ================================================= *}
<style>
@keyframes pulse-viewer {
    0%, 100% { opacity: 1; transform: scale(1); }
    50% { opacity: 0.5; transform: scale(1.3); }
}

/* CSS WEBCAM - Largeur 600px & Responsive */
.live-webcam-wrapper {
    max-width: 600px; 
    width: 100%; 
    margin: 0 auto 20px auto; 
    background: #000; 
    border-radius: 12px; 
    box-shadow: 0 5px 25px rgba(0,0,0,0.15); 
    overflow: hidden; 
    position: relative;
}

.webcam-display { 
    position: relative; 
    width: 100%; 
    background: black; 
}

.webcam-display.format-landscape { aspect-ratio: 16 / 9; }
.webcam-display.format-portrait { aspect-ratio: 9 / 16; }
.webcam-display.format-square { aspect-ratio: 1 / 1; }

.webcam-placeholder {
    position: absolute; 
    top: 0; 
    left: 0; 
    right: 0; 
    bottom: 0;
    display: flex; 
    align-items: center; 
    justify-content: center;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    z-index: 10;
}

.placeholder-content { 
    text-align: center; 
    padding: 20px; 
}

.placeholder-content i { 
    font-size: 72px; 
    opacity: 0.9; 
    margin-bottom: 20px; 
    display: block; 
    animation: float 3s ease-in-out infinite; 
}

@keyframes float {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-10px); }
}

.placeholder-content p { 
    font-size: 18px; 
    margin: 0; 
    opacity: 0.95; 
    line-height: 1.5; 
}

/* Animation LIVE indicator */
@keyframes pulse-live {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}

/* Player responsive */
#live-video-player {
    background: #000;
}

#unmute-btn:hover {
    background: rgba(0,0,0,0.9) !important;
    transform: scale(1.05);
}

/* Styles Live Product */
.live-product { 
    background: {$custom_bg_color}; 
    padding: 10px; 
    border-radius: 8px; 
    border: 1px solid {$custom_border_color}; 
    margin: 10px auto; 
    max-width: 600px; 
    text-align: center; 
}

.live-product h2 { 
    color: {$custom_text_color}; 
    font-size: 1.5em; 
    margin-bottom: 15px; 
}

.live-product p { 
    color: {$custom_text_color}; 
}

.live-product-price { 
    font-size: 1.3em; 
    font-weight: bold; 
    color: {$custom_text_color}; 
    margin-bottom: 15px; 
}

/* Minichat Styles */
.minichat-message { 
    display: flex; 
    margin-bottom: 15px; 
    align-items: flex-start; 
}

.minichat-message.own { 
    flex-direction: row-reverse; 
}

.minichat-avatar { 
    width: 30px; 
    height: 30px; 
    border-radius: 50%; 
    display: flex; 
    align-items: center; 
    justify-content: center; 
    color: white; 
    font-weight: bold; 
    font-size: 12px; 
    margin: 0 10px; 
}

.minichat-bubble { 
    padding: 10px 15px; 
    border-radius: 18px; 
    word-wrap: break-word; 
    font-size: 14px; 
}

.minichat-message.own .minichat-bubble { 
    background: linear-gradient(135deg, #667eea 0%, #d341a2 100%); 
    color: white; 
    border-bottom-right-radius: 4px; 
}

.minichat-message.other .minichat-bubble { 
    background: white; 
    border: 1px solid #e9ecef; 
    border-bottom-left-radius: 4px; 
}

/* Autres styles */
.live-product-image { 
    max-width: 300px; 
    height: auto; 
    border-radius: 4px; 
    margin: 0 auto 15px auto; 
    display: block; 
}

.add-to-cart { 
    background: #28a745; 
    color: white; 
    border: none; 
    padding: 12px 24px; 
    border-radius: 5px; 
    font-size: 16px; 
    cursor: pointer; 
    transition: all 0.3s ease; 
    font-weight: 600; 
}

.add-to-cart:hover:not(:disabled) { 
    background: #218838; 
    transform: translateY(-1px); 
    box-shadow: 0 4px 8px rgba(0,0,0,0.15); 
}

.add-to-cart:disabled { 
    background: #6c757d; 
    cursor: not-allowed; 
    opacity: 0.7; 
}

.cart-message { 
    margin-top: 10px; 
    padding: 10px; 
    border-radius: 4px; 
    display: none; 
    font-weight: 500; 
}

.cart-message.success { 
    background: #d4edda; 
    color: #155724; 
    border: 1px solid #c3e6cb; 
    display: block; 
}

.cart-message.error { 
    background: #f8d7da; 
    color: #721c24; 
    border: 1px solid #f5c6cb; 
    display: block; 
}

/* Responsive */
@media (max-width: 768px) {
    .live-webcam-wrapper, 
    #minichat-widget-live, 
    #live_stats_container,
    .live-product,
    .live-rich-text,
    .live-rich-text-2-footer {
        max-width: 100% !important;
    }
    .placeholder-content i { font-size: 48px; }
    #minichat-widget-live { height: 400px !important; }
}
</style>

{* ================================================= *}
{* LOGIQUE JAVASCRIPT COMPLÈTE *}
{* ================================================= *}
{literal}
<script>
// ========================================
// WEBCAM LIVE
// ========================================

// ========================================
// RÉCEPTION DU STREAM ADMIN
// ========================================
// ========================================
// LECTEUR STREAM VIDÉO+SON (FRONT)
// ========================================

// ========================================
// LECTEUR STREAM VIDÉO+SON (FRONT)
// ========================================
var LiveStreamViewer = {
    streamUrl: null,
    videoElement: null,
    currentChunkIndex: -1,
    pollTimer: null,
    isActive: false,
    retryCount: 0,
    maxRetries: 5,
    initialized: false,
    
    init: function() {
        var self = this;
        
        // Vérifier la config
        if (typeof liveShoppingConfig === 'undefined') {
            console.log('⚠️ liveShoppingConfig non défini');
            return;
        }
        
        this.streamUrl = liveShoppingConfig.streamUrl;
        console.log('📺 StreamUrl:', this.streamUrl);
        
        // Chercher l'élément vidéo
        this.videoElement = document.getElementById('live-video-player');
        
        if (!this.videoElement) {
            console.log('ℹ️ Élément vidéo non présent (webcam peut-être désactivée)');
            // Quand même vérifier le status du stream pour afficher un message
            this.checkStreamStatus();
            return;
        }
        
        console.log('✅ Élément vidéo trouvé, initialisation...');
        this.initialized = true;
        this.setupUnmuteButton();
        this.startPolling();
    },
    
    checkStreamStatus: function() {
        var self = this;
        var statusDetail = document.getElementById('stream-status-detail');
        
        fetch(this.streamUrl + '?action=getStreamStatus&t=' + Date.now())
            .then(function(r) { return r.json(); })
            .then(function(data) {
                console.log('📡 Status stream:', data);
                if (statusDetail) {
                    if (data.webcam_active && data.stream_active) {
                        statusDetail.textContent = 'Stream actif - Rechargez la page';
                    } else if (data.webcam_active) {
                        statusDetail.textContent = 'Webcam activée, en attente...';
                    } else {
                        statusDetail.textContent = 'En attente du présentateur';
                    }
                }
            })
            .catch(function(e) {
                console.warn('⚠️ Erreur status:', e);
            });
    },
    
    setupUnmuteButton: function() {
        var self = this;
        var btn = document.getElementById('unmute-btn');
        if (!btn) return;
        
        btn.addEventListener('click', function() {
            if (self.videoElement) {
                self.videoElement.muted = false;
                btn.innerHTML = '🔊 Son activé';
                btn.style.background = 'rgba(40,167,69,0.8)';
                setTimeout(function() {
                    btn.style.display = 'none';
                }, 1500);
                console.log('🔊 Son activé');
            }
        });
    },
    
    startPolling: function() {
        var self = this;
        console.log('🔄 Démarrage polling...');
        
        var checkStream = function() {
            if (!self.streamUrl) return;
            
            fetch(self.streamUrl + '?action=getChunkInfo&t=' + Date.now())
                .then(function(r) { return r.json(); })
                .then(function(data) {
                    if (data.success && data.active) {
                        self.retryCount = 0;
                        
                        // Nouveau chunk disponible ?
                        if (data.chunk_index !== self.currentChunkIndex) {
                            console.log('📦 Nouveau chunk:', data.chunk_index);
                            self.loadChunk(data.chunk_index);
                        }
                        
                        if (!self.isActive) {
                            self.showLive();
                        }
                    } else {
                        self.handleOffline(data.error || 'Stream inactif');
                    }
                })
                .catch(function(e) {
                    console.warn('⚠️ Erreur poll:', e.message);
                    self.retryCount++;
                    if (self.retryCount >= self.maxRetries) {
                        self.handleOffline('Connexion perdue');
                    }
                });
        };
        
        // Vérifier toutes les secondes
        this.pollTimer = setInterval(checkStream, 1000);
        checkStream(); // Premier appel immédiat
    },
    
    loadChunk: function(index) {
        var self = this;
        var chunkUrl = this.streamUrl + '?action=getChunk&index=' + index + '&t=' + Date.now();
        
        fetch(chunkUrl)
            .then(function(r) {
                if (!r.ok) throw new Error('Chunk ' + index + ' non trouvé');
                return r.blob();
            })
            .then(function(blob) {
                if (blob.size < 100) {
                    console.warn('⚠️ Chunk trop petit, ignoré');
                    return;
                }
                
                var url = URL.createObjectURL(blob);
                var oldSrc = self.videoElement.src;
                
                self.videoElement.src = url;
                self.videoElement.load();
                
                self.videoElement.play().then(function() {
                    // Libérer l'ancienne URL
                    if (oldSrc && oldSrc.startsWith('blob:')) {
                        URL.revokeObjectURL(oldSrc);
                    }
                }).catch(function(e) {
                    console.log('⚠️ Autoplay bloqué:', e.message);
                });
                
                self.currentChunkIndex = index;
            })
            .catch(function(e) {
                console.warn('⚠️ Erreur chunk:', e.message);
            });
    },
    
    showLive: function() {
        this.isActive = true;
        
        var placeholder = document.getElementById('webcam-placeholder');
        var video = this.videoElement;
        var indicator = document.getElementById('live-indicator');
        var unmuteBtn = document.getElementById('unmute-btn');
        
        if (placeholder) placeholder.style.display = 'none';
        if (video) video.style.display = 'block';
        if (indicator) indicator.style.display = 'block';
        if (unmuteBtn) unmuteBtn.style.display = 'block';
        
        console.log('✅ Stream LIVE affiché');
    },
    
    handleOffline: function(reason) {
        if (this.isActive) {
            console.log('📴 Stream hors ligne:', reason);
        }
        this.isActive = false;
        this.currentChunkIndex = -1;
        
        var placeholder = document.getElementById('webcam-placeholder');
        var video = this.videoElement;
        var indicator = document.getElementById('live-indicator');
        var unmuteBtn = document.getElementById('unmute-btn');
        var statusDetail = document.getElementById('stream-status-detail');
        
        if (placeholder) placeholder.style.display = 'flex';
        if (video) video.style.display = 'none';
        if (indicator) indicator.style.display = 'none';
        if (unmuteBtn) unmuteBtn.style.display = 'none';
        if (statusDetail) statusDetail.textContent = reason || 'En attente du stream...';
    },
    
    stop: function() {
        if (this.pollTimer) {
            clearInterval(this.pollTimer);
            this.pollTimer = null;
        }
        this.isActive = false;
        console.log('🛑 Viewer arrêté');
    }
};

// ========================================
// FONCTION PRINCIPALE LIVE SHOPPING
// ========================================
const BASE_CART_URL = prestashop.urls.pages.cart || liveShoppingConfig.ajaxUrl; 

let retryCount = 0;
let refreshTimer = null;

function refreshLiveContent() {
    fetch(liveShoppingConfig.ajaxUrl, {
        method: 'GET',
        headers: { 'Cache-Control': 'no-cache', 'Pragma': 'no-cache' }
    })
    .then(response => {
        if (!response.ok) throw new Error('Erreur réseau: ' + response.status);
        return response.json();
    })
    .then(data => {
        if (data.login_required || data.message === 'not_logged_in') {
            window.location.reload();
            return;
        }
        retryCount = 0;
        displayLiveContent(data);
    })
    .catch(error => {
        console.error('❌ Erreur AJAX:', error);
        handleError(error);
    });
}

function displayLiveContent(data) {
    const container = document.getElementById('live-container');
    if (!data.product) {
        let message = '🎬 Aucun live shopping en cours';
        container.innerHTML = '<div class="no-live-message">' + message + '</div>';
        return;
    }

    if (data.product) {
        const existingProduct = container.querySelector('.live-product');
        if (existingProduct) existingProduct.remove();
        
        const productDiv = document.createElement('div');
        productDiv.className = 'live-product';
        
        let productHtml = '';
        productHtml += '<h2>' + escapeHtml(data.product.name) + '</h2>';
        productHtml += '<img id="live-product-image" src="' + data.product.default_image + '" alt="' + escapeHtml(data.product.name) + '" class="live-product-image">';
        productHtml += '<div class="live-product-price">Prix : <span id="live-product-price">' + data.product.default_price + '</span></div>';
        productHtml += '<div id="stock-info">Stock de départ : ' + (data.product.stock || '—') + '</div>';
        
        if (!data.combinations || Object.keys(data.combinations).length === 0) {
            if (data.product.stock > 0) {
                productHtml += '<div style="color: green; font-weight: bold; margin: 10px 0;">✅ ' + data.product.stock + ' en stock</div>';
            } else {
                productHtml += '<div style="color: red; font-weight: bold; margin: 10px 0;">❌ Rupture de stock</div>';
            }
        }

        if (data.combinations && Object.keys(data.combinations).length > 0) {
            productHtml += '<div class="product-combinations">';
            productHtml += '<label for="combination-select">Choisir une déclinaison :</label><br>';
            productHtml += '<select id="combination-select" class="combination-select">';
            
            const savedCombinationId = localStorage.getItem('live_selected_combination');
            for (const id in data.combinations) {
                const combination = data.combinations[id];
                const label = Object.values(combination.attributes).join(' / ');
                const isSelected = (id === savedCombinationId);
                const stockInfo = combination.stock > 0 ? ' (' + combination.stock + ' dispo)' : ' (Épuisé)';

                productHtml += '<option value="' + id + '"';
                productHtml += ' data-stock="' + combination.stock + '"';
                productHtml += (isSelected ? ' selected' : '') + '>';
                productHtml += escapeHtml(label) + stockInfo;
                productHtml += '</option>';
            }
            productHtml += '</select></div>';
            productHtml += '<div id="stock-display" style="margin: 10px 0; font-weight: bold;"></div>';
        }

        const defaultCombination = data.combinations && Object.keys(data.combinations).length > 0 ? Object.keys(data.combinations)[0] : '0';
        productHtml += '<div class="product-actions">';
        productHtml += '<p style="margin-bottom:10px; font-size:14px; color:#333; font-weight:500;">';
        productHtml += '💡 Si le produit vous convient, choisissez vos options et appuyez sur "Ajouter au panier".';
        productHtml += '</p>';
        productHtml += '<button class="add-to-cart" id="add-to-cart-btn"';
        productHtml += ' data-product="' + data.product.id + '"';
        productHtml += ' data-product-name="' + escapeHtml(data.product.name) + '"';
        productHtml += ' data-combinations="' + JSON.stringify(data.combinations).replace(/"/g, '&quot;') + '"';
        productHtml += ' data-attribute="' + defaultCombination + '"';
        productHtml += ' data-token="' + prestashop.static_token + '">';
        productHtml += '🛒 Ajouter au panier';
        productHtml += '</button>';
        productHtml += '<div id="cart-message" class="cart-message"></div>';
        productHtml += '</div>';
        
        productDiv.innerHTML = productHtml;
        container.appendChild(productDiv);

        setupEventListeners(data);
    }
}

function setupEventListeners(data) {
    const selectElement = document.getElementById('combination-select');
    if (selectElement) {
        selectElement.addEventListener('change', function() {
            const selectedId = this.value;
            const selectedOption = this.options[this.selectedIndex];
            const stock = parseInt(selectedOption.getAttribute('data-stock')) || 0;
            const stockDisplay = document.getElementById('stock-display');
            
            if (stockDisplay) {
                if (stock > 0) stockDisplay.innerHTML = '<span style="color: green;">✅ ' + stock + ' en stock</span>';
                else stockDisplay.innerHTML = '<span style="color: red;">❌ Rupture de stock</span>';
            }
            
            const addButton = document.getElementById('add-to-cart-btn');
            if (addButton) {
                addButton.setAttribute('data-attribute', selectedId);
                if (stock > 0) {
                    addButton.disabled = false;
                    addButton.textContent = '🛒 Ajouter au panier';
                } else {
                    addButton.disabled = true;
                    addButton.textContent = '❌ Rupture de stock';
                }
            }
            updateProductFromCombination(selectedId, data.combinations);
            localStorage.setItem('live_selected_combination', selectedId);
        });

        const savedId = localStorage.getItem('live_selected_combination');
        if (savedId && data.combinations[savedId]) {
            selectElement.value = savedId;
            updateProductFromCombination(savedId, data.combinations);
            selectElement.dispatchEvent(new Event('change'));
        } else if (data.combinations && Object.keys(data.combinations).length > 0) {
            const firstId = Object.keys(data.combinations)[0];
            selectElement.value = firstId;
            updateProductFromCombination(firstId, data.combinations);
            selectElement.dispatchEvent(new Event('change'));
        }
    }

    const addButton = document.getElementById('add-to-cart-btn');
    if (addButton) {
        addButton.removeEventListener('click', handleAddToCart);
        addButton.addEventListener('click', handleAddToCart);
    }
}

function updateProductFromCombination(combinationId, combinations) {
    if (!combinations[combinationId]) return;
    const combination = combinations[combinationId];
    const priceElement = document.getElementById('live-product-price');
    if (priceElement) priceElement.textContent = combination.price;
    const imageElement = document.getElementById('live-product-image');
    if (imageElement && combination.image) imageElement.src = combination.image;
    const button = document.getElementById('add-to-cart-btn');
    if (button) button.setAttribute('data-attribute', combinationId);
}

function showCartMessage(message, type) {
    const messageDiv = document.getElementById('cart-message');
    if (!messageDiv) return;
    messageDiv.textContent = message;
    messageDiv.className = 'cart-message ' + type;
    messageDiv.style.display = 'block';
    setTimeout(() => { messageDiv.style.display = 'none'; }, 4000);
}

function sendCartNotificationToChat(productName, attributeId, combinations) {
    if (!LiveMiniChat.isLogged || !LiveMiniChat.url) return;
    let message = "🛒 J'ai ajouté au panier : " + productName;
    const isCombination = (attributeId && attributeId !== '0');
    if (isCombination && combinations && combinations[attributeId] && combinations[attributeId].attributes) {
        const attributes = Object.values(combinations[attributeId].attributes).join(' / ');
        if (attributes) message += " (" + attributes + ")";
    }
    
    const formData = new FormData();
    formData.append('action', 'sendMessage');
    formData.append('message', message);
    fetch(LiveMiniChat.url, { method: 'POST', body: formData })
    .then(function(response) { return response.json(); })
    .then(function(data) {
        if (data.success) {
            setTimeout(function() { LiveMiniChat.loadMessages(); }, 500);
        }
    })
    .catch(function(error) { console.error('❌ Erreur notification chat:', error); });
}

async function handleAddToCart() {
    const button = this;
    const productId = button.getAttribute('data-product');
    const token = button.getAttribute('data-token');
    const productName = button.getAttribute('data-product-name');
    let combinationsData = button.getAttribute('data-combinations');

    if (!productId || !token) {
        showCartMessage('Données manquantes', 'error');
        return;
    }

    const selectElement = document.getElementById('combination-select');
    let currentStock = 0;
    let finalAttributeId = button.getAttribute('data-attribute') || '0';
    let combinations = null;
    
    if (combinationsData) combinationsData = combinationsData.replace(/&quot;/g, '"');
    try { combinations = combinationsData ? JSON.parse(combinationsData) : null; } catch (e) {}
    
    if (selectElement) {
        const selectedOption = selectElement.options[selectElement.selectedIndex];
        finalAttributeId = selectedOption ? selectedOption.value : '0';
        currentStock = parseInt(selectedOption.getAttribute('data-stock')) || 0;
    } else {
        finalAttributeId = button.getAttribute('data-attribute') || '0';
        const stockDiv = document.querySelector('.live-product div[style*="green"], .live-product div[style*="red"]');
        if (stockDiv) {
            const match = stockDiv.textContent.match(/(\d+)\s+en\s+stock/);
            currentStock = match ? parseInt(match[1]) : 0;
        }
    }

    if (currentStock <= 0) {
        showCartMessage('❌ Produit en rupture de stock', 'error');
        return;
    }

    button.disabled = true;
    button.textContent = '⏳ Ajout en cours...';
    
    try {
        const formData = new URLSearchParams({
            'add': '1',
            'action': 'update',
            'id_product': productId,
            'id_product_attribute': finalAttributeId, 
            'qty': '1',
            'token': token
        });        

        const response = await fetch(BASE_CART_URL, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: formData
        });
        
        if (response.ok) {
            showCartMessage('✅ Produit ajouté au panier !', 'success');
            sendCartNotificationToChat(productName, finalAttributeId, combinations);
            const newStock = currentStock - 1;
            
            if (selectElement) {
                const selectedOption = selectElement.options[selectElement.selectedIndex];
                selectedOption.setAttribute('data-stock', newStock);
                const labelText = selectedOption.textContent.replace(/\s*\([^)]*\)\s*$/, '');
                selectedOption.textContent = labelText + (newStock > 0 ? ` (${newStock} dispo)` : ' (Épuisé)');
                const stockDisplay = document.getElementById('stock-display');
                if (stockDisplay) {
                    stockDisplay.innerHTML = newStock > 0 ? '<span style="color: green;">✅ ' + newStock + ' en stock</span>' : '<span style="color: red;">❌ Rupture de stock</span>';
                }
                if (newStock <= 0) {
                    button.disabled = true;
                    button.textContent = '❌ Rupture de stock';
                    setTimeout(() => { refreshLiveContent(); }, 500);
                    return;
                }
            }
            setTimeout(() => { refreshLiveContent(); }, 2000);
        } else {
            throw new Error('Erreur HTTP: ' + response.status);
        }

    } catch (error) {
        console.error('Erreur ajout panier:', error);
        showCartMessage('❌ Erreur ajout panier', 'error');
        setTimeout(() => { refreshLiveContent(); }, 1000);
    } finally {
        if (selectElement) {
            const selectedOption = selectElement.options[selectElement.selectedIndex];
            const stock = parseInt(selectedOption.getAttribute('data-stock')) || 0;
            if (stock > 0) {
                button.disabled = false;
                button.textContent = '🛒 Ajouter au panier';
            }
        } else {
            button.disabled = false;
            button.textContent = '🛒 Ajouter au panier';
        }
    }
}

function handleError(error) {
    retryCount++;
    if (retryCount < liveShoppingConfig.maxRetries) {
        setTimeout(refreshLiveContent, 5000);
    } else {
        document.getElementById('live-container').innerHTML = '<div class="no-live-message">⚠️ Impossible de charger le live shopping. <button onclick="location.reload()" style="margin-left: 10px; padding: 5px 10px;">Actualiser</button></div>';
    }
}

function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

// ========================================
// FONCTION MINICHAT INTÉGRÉ
// ========================================
LiveMiniChat.init = function() {
    if (!this.url || !this.isLogged) return;
    var input = document.getElementById('live-chat-input');
    if (input) {
        input.addEventListener('input', function() {
            var counter = document.getElementById('live-char-count');
            if (counter) counter.textContent = this.value.length;
        });
    }
    this.loadMessages();
    this.startPolling();
};

LiveMiniChat.loadMessages = function() {
    var self = this;
    fetch(this.url + '?action=getMessages&lastId=' + this.lastMessageId)
        .then(function(response) { return response.json(); })
        .then(function(data) {
            if (data.success && data.messages) self.displayMessages(data.messages);
        })
        .catch(function(error) { console.error('Error chat:', error); });
};

LiveMiniChat.displayMessages = function(messages) {
    var container = document.getElementById('live-chat-messages');
    if (!container) return;
    var loading = container.querySelector('.minichat-loading');
    if (loading) loading.remove();
    
    var self = this;
    messages.forEach(function(msg) {
        if (document.querySelector('[data-msg-id="' + msg.id_message + '"]')) return;
        var messageDiv = document.createElement('div');
        const isCartNotification = msg.message && msg.message.startsWith('🛒');
        messageDiv.className = 'minichat-message ' + (msg.is_own ? 'own' : 'other') + (isCartNotification ? ' cart-notification' : '');
        messageDiv.setAttribute('data-msg-id', msg.id_message);
        
        var html = '';
        if (msg.avatar) {
            html += '<div class="minichat-avatar" style="background: linear-gradient(135deg, ' + msg.avatar.color1 + ' 0%, ' + msg.avatar.color2 + ' 100%);">' + msg.avatar.initials + '</div>';
        }
        html += '<div class="minichat-message-content">';
        html += '<div class="minichat-message-header">';
        if (!msg.is_own) {
            html += '<span class="minichat-customer-name">' + self.escapeHtml(msg.display_name || 'Guest') + '</span>';
            if (msg.customer_id_display) html += '<span class="minichat-customer-id">' + msg.customer_id_display + '</span>';
        }
        html += '<span class="minichat-message-time">' + msg.time + '</span>';
        html += '</div>';
        html += '<div class="minichat-bubble">' + self.escapeHtml(msg.message) + '</div>';
        html += '</div>';
        
        messageDiv.innerHTML = html;
        container.appendChild(messageDiv);
        self.lastMessageId = Math.max(self.lastMessageId, parseInt(msg.id_message));
    });
    container.scrollTop = container.scrollHeight;
};

LiveMiniChat.send = function() {
    var input = document.getElementById('live-chat-input');
    if (!input || !input.value.trim()) return;
    var message = input.value.trim();
    var self = this;
    var formData = new FormData();
    formData.append('action', 'sendMessage');
    formData.append('message', message);
    
    fetch(this.url, { method: 'POST', body: formData })
    .then(function(response) { return response.json(); })
    .then(function(data) {
        if (data.success) {
            input.value = '';
            var counter = document.getElementById('live-char-count');
            if (counter) counter.textContent = '0';
            self.loadMessages();
        } else if (data.error) {
            alert(data.error);
        }
    })
    .catch(function(error) { console.error('Error sending:', error); });
};

LiveMiniChat.startPolling = function() {
    if (this.timer) return;
    var self = this;
    this.timer = setInterval(function() { self.loadMessages(); }, 3000);
};

LiveMiniChat.stopPolling = function() {
    if (this.timer) { clearInterval(this.timer); this.timer = null; }
};

LiveMiniChat.escapeHtml = function(text) {
    var div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
};

// ========================================
// INITIALISATION GLOBALE UNIQUE
// ========================================
document.addEventListener('DOMContentLoaded', function() {
    console.log('🚀 Live Shopping - Initialisation');
    console.log('📋 Config:', liveShoppingConfig);
    
    // 1. Démarrer le lecteur stream (toujours, il gère lui-même si désactivé)
    if (typeof LiveStreamViewer !== 'undefined') {
        LiveStreamViewer.init();
    }
    
    // 2. Lancer la boucle de produits
    if (typeof refreshLiveContent === 'function') {
        refreshLiveContent();
        refreshTimer = setInterval(refreshLiveContent, liveShoppingConfig.refreshInterval || 10000);
    }
    
    // 3. Lancer le Chat
    if (typeof LiveMiniChat !== 'undefined' && LiveMiniChat.isLogged) {
        LiveMiniChat.init();
    }
    
    // 4. Lancer le Compteur Viewers
    if (typeof LiveViewers !== 'undefined') {
        LiveViewers.init();
    }
    
    // Nettoyage en quittant
    window.addEventListener('beforeunload', function() {
        if (typeof LiveStreamViewer !== 'undefined') {
            LiveStreamViewer.stop();
        }
        if (refreshTimer) clearInterval(refreshTimer);
        if (typeof LiveMiniChat !== 'undefined' && LiveMiniChat.timer) {
            LiveMiniChat.stopPolling();
        }
        if (typeof LiveViewers !== 'undefined') {
            LiveViewers.stop();
        }
    });
});
</script>
{/literal}