<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

class myliveshoppingmodule extends Module
{
    public function __construct()
    {
        $this->name = 'myliveshoppingmodule';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'SplineOnline';
        $this->need_instance = 0;

        parent::__construct();

        $this->displayName = $this->l('My Live Shopping Module');
        $this->description = $this->l('Module de Live Shopping avec diffusion des articles et gestion du stock en direct.');
    }

    public function install()
{
    // Créer la table du minichat
    $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'minichat_messages` (
        `id_message` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
        `id_customer` INT(10) UNSIGNED NOT NULL DEFAULT 0,
        `id_employee` INT(10) UNSIGNED NOT NULL DEFAULT 0,
        `message` TEXT NOT NULL,
        `date_add` DATETIME NOT NULL,
        `is_deleted` TINYINT(1) NOT NULL DEFAULT 0,
        PRIMARY KEY (`id_message`),
        KEY `id_customer` (`id_customer`),
        KEY `id_employee` (`id_employee`),
        KEY `date_add` (`date_add`),
        KEY `is_deleted` (`is_deleted`)
    ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;';

    if (!Db::getInstance()->execute($sql)) {
        return false;
    }

    
    // Créer automatiquement le dossier stream avec les bonnes permissions
    $stream_dir = _PS_MODULE_DIR_ . 'myliveshoppingmodule/stream/';
    
    if (!file_exists($stream_dir)) {
        if (!mkdir($stream_dir, 0755, true)) {
            $this->_errors[] = $this->l('Impossible de créer le dossier stream. Vérifiez les permissions.');
            return false;
        }
    }
    
    // Créer le fichier .htaccess pour autoriser l'accès aux JPG
    $htaccess_content = "# Autoriser l'accès aux images du stream
        <FilesMatch \"\.(jpg|jpeg)$\">
            Order allow,deny
            Allow from all
        </FilesMatch>

        # Désactiver le cache
        <IfModule mod_headers.c>
            Header set Cache-Control \"no-cache, no-store, must-revalidate\"
            Header set Pragma \"no-cache\"
            Header set Expires 0
        </IfModule>";
    
    file_put_contents($stream_dir . '.htaccess', $htaccess_content);

    // TABLE POUR LES VIEWERS
    $sql_viewers = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'live_viewers` (
        `id_viewer` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
        `session_id` VARCHAR(100) NOT NULL,
        `id_customer` INT(10) UNSIGNED NOT NULL DEFAULT 0,
        `last_seen` DATETIME NOT NULL,
        `user_agent` VARCHAR(255) DEFAULT NULL,
        `ip_address` VARCHAR(45) DEFAULT NULL,
        PRIMARY KEY (`id_viewer`),
        UNIQUE KEY `session_id` (`session_id`),
        KEY `last_seen` (`last_seen`),
        KEY `id_customer` (`id_customer`)
    ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;';

    if (!Db::getInstance()->execute($sql_viewers)) {
        return false;
    }



    return parent::install()
        && $this->createCmsPage()
        && $this->registerHook('actionCartUpdateQuantityBefore')
        && $this->registerHook('actionCartUpdateQuantityAfter')
        && $this->registerHook('displayAdminAfterHeader')
        && $this->registerHook('actionAuthentication')
        && Configuration::updateValue('myliveshoppingmodule_ENABLED', 1)
        && Configuration::updateValue('myliveshoppingmodule_ID', 0)
        && Configuration::updateValue('myliveshoppingmodule_MAX_QTY', 3)
        && Configuration::updateValue('myliveshoppingmodule_RICH_TEXT', '')
        && Configuration::updateValue('myliveshoppingmodule_RICH_TEXT_2', '')
        && Configuration::updateValue('myliveshoppingmodule_SLIDE_LIST', '')
        && Configuration::updateValue('myliveshoppingmodule_SLIDE_INDEX', 0)
        && Configuration::updateValue('myliveshoppingmodule_CHAT_COLOR1', '#667eea')
        && Configuration::updateValue('myliveshoppingmodule_CHAT_COLOR2', '#d341a2')
        && Configuration::updateValue('myliveshoppingmodule_BG_COLOR', '#f08ec4')
        && Configuration::updateValue('myliveshoppingmodule_BORDER_COLOR', '#ff006a')
        && Configuration::updateValue('myliveshoppingmodule_TEXT_COLOR', '#333333')
        && Configuration::updateValue('myliveshoppingmodule_WEBCAM_FORMAT', 'landscape')
        && Configuration::updateValue('myliveshoppingmodule_WEBCAM_ACTIVE', 0);
}

private function createCmsPage()
{
    // 1. Create new CMS Object
    $cms = new CMS();
    $cms->active = true;
    $cms->id_cms_category = 1; // 1 is usually the "Home" or "Root" CMS category
    $cms->indexation = 0;

    $languages = Language::getLanguages(false);

    foreach ($languages as $lang) {
        $id_lang = (int) $lang['id_lang'];
        $cms->meta_title[$id_lang] = 'Page Live';
        $cms->link_rewrite[$id_lang] = 'my-custom-module-page';

        $live_url = $this->context->link->getModuleLink('myliveshoppingmodule', 'display');

        $cms->content[$id_lang] = '
            <p style="text-align: center;">
                <iframe 
                    width="100%" 
                    height="1100" 
                    src="' . $live_url . '" 
                    frameborder="0" 
                    allow="camera; microphone; autoplay; clipboard-write; encrypted-media" 
                    allowfullscreen>
                </iframe>
            </p>
        ';

        $cms->meta_description[$id_lang] = 'live';
    }

    if ($cms->add()) {
        Configuration::updateValue('YOURMODULE_CMS_PAGE_ID', $cms->id);
        return true;
    }

    return false;
}

private function deleteCmsPage()
{
    $id_cms = (int) Configuration::get('YOURMODULE_CMS_PAGE_ID');

    if ($id_cms) {
        $cms = new CMS($id_cms);

        if (Validate::isLoadedObject($cms)) {
            if ($cms->delete()) {
                Configuration::deleteByName('YOURMODULE_CMS_PAGE_ID');
                return true;
            }
            return false;
        }
    }

    return true;
}

public function uninstall()
{
    $this->myls_returnAbandonedStock();

    $stream_dir = _PS_MODULE_DIR_ . 'myliveshoppingmodule/stream/';
    
    // Supprimer tous les fichiers du dossier
    if (is_dir($stream_dir)) {
        $files = glob($stream_dir . '*');
        foreach ($files as $file) {
            if (is_file($file)) {
                @unlink($file);
            }
        }
        // Supprimer le dossier vide
        @rmdir($stream_dir);
    }

    // Supprimer la table du minichat
    $sql = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'minichat_messages`';
    Db::getInstance()->execute($sql);

    // SUPPRIMER LA TABLE VIEWERS
    $sql_viewers = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'live_viewers`';
    Db::getInstance()->execute($sql_viewers);

    return parent::uninstall()
        && $this->deleteCmsPage()
        && Configuration::deleteByName('myliveshoppingmodule_ENABLED')
        && Configuration::deleteByName('myliveshoppingmodule_ID')
        && Configuration::deleteByName('myliveshoppingmodule_MAX_QTY')
        && Configuration::deleteByName('myliveshoppingmodule_RICH_TEXT')
        && Configuration::deleteByName('myliveshoppingmodule_RICH_TEXT_2')
        && Configuration::deleteByName('myliveshoppingmodule_SLIDE_LIST')
        && Configuration::deleteByName('myliveshoppingmodule_SLIDE_INDEX')
        && Configuration::deleteByName('myliveshoppingmodule_CHAT_COLOR1')
        && Configuration::deleteByName('myliveshoppingmodule_CHAT_COLOR2')
        && Configuration::deleteByName('myliveshoppingmodule_BG_COLOR')
        && Configuration::deleteByName('myliveshoppingmodule_BORDER_COLOR')
        && Configuration::deleteByName('myliveshoppingmodule_TEXT_COLOR')
        && Configuration::deleteByName('myliveshoppingmodule_WEBCAM_FORMAT')
        && Configuration::deleteByName('myliveshoppingmodule_WEBCAM_ACTIVE');

 }

    public function hookActionCartUpdateQuantityBefore(array $params)
    {
        if (!isset($params['id_product'])) {
            return;
        }
        $live_product_id = (int)Configuration::get('myliveshoppingmodule_ID');
        $id_product = (int)$params['id_product'];
        $id_product_attribute = (int)$params['id_product_attribute'];
        $new_quantity = (int)$params['quantity'];
        $cart = $params['cart'];

        if ($id_product !== $live_product_id) {
            return;
        }

        $stock_physique = (int)StockAvailable::getQuantityAvailableByProduct(
            $id_product,
            $id_product_attribute,
            $this->context->shop->id
        );

        $old_quantity_in_cart = (int)$cart->getProductQuantity($id_product, $id_product_attribute);
        $quantity_difference = $new_quantity - $old_quantity_in_cart;

        $max_qty_allowed = (int)Configuration::get('myliveshoppingmodule_MAX_QTY', 3);
        if ($new_quantity > $max_qty_allowed) {
            throw new PrestaShopException(
                $this->l(sprintf('Limite max Live : %d unités.', $max_qty_allowed))
            );
        }

        if ($quantity_difference > 0) {
            if ($quantity_difference > $stock_physique) {
                throw new PrestaShopException($this->l('Stock insuffisant. La quantité disponible est de : ') . $stock_physique);
            }
        }
    }

    public function hookActionCartUpdateQuantityAfter($params)
    {
        return true;
    }

    public function hookDisplayAdminAfterHeader()
    {
        $is_enabled = (int)Configuration::get('myliveshoppingmodule_ENABLED');

        if ($is_enabled && Tools::getValue('configure') == $this->name) {
            $this->context->controller->warnings[] = $this->l('Attention, lorsque le module est actif, chaque mise en panier décrémente votre stock ! N\'oubliez pas de désactiver le module après utilisation.');
        }
    }

    public function hookDisplayHome($params)
    {
        $id_product = (int)Configuration::get('myliveshoppingmodule_ID');
        $product_combinations = $this->myls_getProductCombinations($id_product);
        $slide_ids_string = Configuration::get('myliveshoppingmodule_SLIDE_LIST');
        $products_slide_data = [];

        if (!empty($slide_ids_string)) {
            $list_ids = array_values(array_map('intval', array_filter(array_map('trim', explode(',', $slide_ids_string)))));
            $lang_id = (int)$this->context->language->id;

            foreach ($list_ids as $id_product_slide) {
                $product = new Product($id_product_slide, false, $lang_id);
                if (Validate::isLoadedObject($product) && $product->active) {
                    $image = Image::getCover($id_product_slide);
                    $image_url = $this->context->link->getImageLink(
                        $product->link_rewrite[$lang_id],
                        (int)$image['id_image'],
                        ImageType::getFormattedName('home_default')
                    );
                    $products_slide_data[] = [
                        'id' => $id_product_slide,
                        'name' => $product->name,
                        'link' => $this->context->link->getProductLink($product),
                        'price' => Tools::displayPrice($product->getPrice(), $this->context->currency),
                        'image_url' => $image_url
                    ];
                }
            }
        }

        $max_qty = (int)Configuration::get('myliveshoppingmodule_MAX_QTY', 3);
        $bg_color = Configuration::get('myliveshoppingmodule_BG_COLOR') ?: '#f08ec4';
        $border_color = Configuration::get('myliveshoppingmodule_BORDER_COLOR') ?: '#ff006a';
        $text_color = Configuration::get('myliveshoppingmodule_TEXT_COLOR') ?: '#333333';

        $this->context->smarty->assign([
            'module_dir' => $this->getPathUri(),
            'displayName' => $this->displayName,
            'logged' => $this->context->customer->isLogged(),
            'live_product_id' => $id_product,
            'product_combinations' => $product_combinations,
            'products_slide_list' => $products_slide_data,
            'max_qty_live' => $max_qty,
            'live_rich_text' => Configuration::get('myliveshoppingmodule_RICH_TEXT'),
            'live_rich_text_2' => Configuration::get('myliveshoppingmodule_RICH_TEXT_2'),
            'custom_bg_color' => $bg_color,
            'custom_border_color' => $border_color,
            'custom_text_color' => $text_color,
        ]);

        return $this->display($this->_path, 'myliveshoppingmodule.tpl');
    }

    public function hookActionAuthentication($params)
    {
        $customer = $params['customer'];
        $cart_id = (int)Db::getInstance()->getValue('SELECT c.id_cart FROM '._DB_PREFIX_.'cart c WHERE c.id_customer='.(int)$customer->id.' AND c.id_cart NOT IN (SELECT o.id_cart FROM '._DB_PREFIX_.'orders o) ORDER BY c.date_upd DESC');
        if ($cart_id) {
            $this->context->cart = new Cart($cart_id);
            $this->context->cookie->id_cart = (int)$cart_id;
        }
    }

    // ========================================
    // FONCTION PRINCIPALE getContent()
    // ========================================
    public function getContent()
    {
        $output = '';

        // ===== TOUS LES TRAITEMENTS DES FORMULAIRES =====

        // Toggle activation/désactivation
        if (Tools::isSubmit('submitToggle')) {
            $enabled = (int)Tools::getValue('myliveshoppingmodule_ENABLED') ? 1 : 0;

            if ($enabled) {
                if ($this->enable()) {
                    Configuration::updateValue('myliveshoppingmodule_ENABLED', 1);
                    $output .= $this->displayConfirmation($this->l('✅ Module activé avec succès.'));
                } else {
                    $output .= $this->displayError($this->l('❌ Erreur lors de l\'activation.'));
                }
            } else {
                if ($this->disable()) {
                    Configuration::updateValue('myliveshoppingmodule_ENABLED', 0);
                    $output .= $this->displayConfirmation($this->l('⚠️ Module désactivé avec succès.'));
                } else {
                    $output .= $this->displayError($this->l('❌ Erreur lors de la désactivation.'));
                }
            }
        }

        // Sauvegarde des couleurs du PRODUIT
        if (Tools::isSubmit('submitColors')) {
            $bg_color = Tools::getValue('myliveshoppingmodule_BG_COLOR');
            $border_color = Tools::getValue('myliveshoppingmodule_BORDER_COLOR');
            $text_color = Tools::getValue('myliveshoppingmodule_TEXT_COLOR');

            Configuration::updateValue('myliveshoppingmodule_BG_COLOR', $bg_color);
            Configuration::updateValue('myliveshoppingmodule_BORDER_COLOR', $border_color);
            Configuration::updateValue('myliveshoppingmodule_TEXT_COLOR', $text_color);

            $output .= $this->displayConfirmation($this->l('Les couleurs du produit ont été mises à jour avec succès.'));
        }

        // Sauvegarde des couleurs du CHAT
        if (Tools::isSubmit('submitChatColors')) {
            $chat_color1 = Tools::getValue('myliveshoppingmodule_CHAT_COLOR1');
            $chat_color2 = Tools::getValue('myliveshoppingmodule_CHAT_COLOR2');

            Configuration::updateValue('myliveshoppingmodule_CHAT_COLOR1', $chat_color1);
            Configuration::updateValue('myliveshoppingmodule_CHAT_COLOR2', $chat_color2);

            $output .= $this->displayConfirmation($this->l('Les couleurs du chat ont été mises à jour avec succès.'));
        }

        // Sauvegarde quantité max
        if (Tools::isSubmit('submitMaxQty')) {
            $max_qty = (int)Tools::getValue('myliveshoppingmodule_MAX_QTY');
            Configuration::updateValue('myliveshoppingmodule_MAX_QTY', $max_qty);
            $output .= $this->displayConfirmation($this->l('Quantité maximale mise à jour.'));
        }

        // Sauvegarde texte enrichi 1
        if (Tools::isSubmit('submitRichText')) {
            $rich_text = Tools::getValue('myliveshoppingmodule_RICH_TEXT');
            Configuration::updateValue('myliveshoppingmodule_RICH_TEXT', $rich_text, true);
            $output .= $this->displayConfirmation($this->l('Le texte a été mis à jour.'));
        }

        // Sauvegarde texte enrichi 2
        if (Tools::isSubmit('submitRichText_2')) {
            $rich_text_2 = Tools::getValue('myliveshoppingmodule_RICH_TEXT_2');
            Configuration::updateValue('myliveshoppingmodule_RICH_TEXT_2', $rich_text_2, true);
            $output .= $this->displayConfirmation($this->l('Le texte a été mis à jour.'));
        }

        // Sauvegarde liste slide
        if (Tools::isSubmit('submitSlideList')) {
            $new_slide_list = Tools::getValue('myliveshoppingmodule_SLIDE_LIST');
            $new_slide_list_clean = implode(',', array_filter(array_map('trim', explode(',', $new_slide_list))));
            Configuration::updateValue('myliveshoppingmodule_SLIDE_LIST', $new_slide_list_clean);
            Configuration::updateValue('myliveshoppingmodule_SLIDE_INDEX', 0);
            $output .= $this->displayConfirmation($this->l('Liste de produits pour le Slide mise à jour.'));
        }

        // Navigation slide suivant
        if (Tools::isSubmit('submitNextSlideProduct')) {
            $list_string = Configuration::get('myliveshoppingmodule_SLIDE_LIST');
            $list_ids = array_values(array_map('intval', array_filter(array_map('trim', explode(',', $list_string)))));
            $current_index = (int)Configuration::get('myliveshoppingmodule_SLIDE_INDEX');
            $total_products = count($list_ids);

            if (empty($list_ids)) {
                $output .= $this->displayError($this->l('La liste de produits du slide est vide.'));
            } elseif ($current_index < $total_products) {
                $next_product_id = $list_ids[$current_index];
                Configuration::updateValue('myliveshoppingmodule_ID', $next_product_id);
                Configuration::updateValue('myliveshoppingmodule_SLIDE_INDEX', $current_index + 1);

                $product = new Product($next_product_id, false, (int)$this->context->language->id);
                $product_name = Validate::isLoadedObject($product) ? $product->name : 'Produit ID ' . $next_product_id;

                $output .= $this->displayConfirmation(sprintf(
                    $this->l('✅ Produit LIVE : %s (Étape %d/%d)'),
                    $product_name,
                    $current_index + 1,
                    $total_products
                ));
            } else {
                Configuration::updateValue('myliveshoppingmodule_ID', 0);
                Configuration::updateValue('myliveshoppingmodule_SLIDE_INDEX', 0);
                $output .= $this->displayWarning($this->l('⚠️ Fin du slide atteinte. Réinitialisé à 0.'));
            }
        }

        // Navigation slide précédent
        if (Tools::isSubmit('submitPrevSlideProduct')) {
            $list_string = Configuration::get('myliveshoppingmodule_SLIDE_LIST');
            $list_ids = array_values(array_map('intval', array_filter(array_map('trim', explode(',', $list_string)))));
            $current_index = (int)Configuration::get('myliveshoppingmodule_SLIDE_INDEX');

            if (empty($list_ids)) {
                $output .= $this->displayError($this->l('La liste de produits du slide est vide.'));
            } elseif ($current_index > 1) {
                $prev_product_id = $list_ids[$current_index - 2];
                Configuration::updateValue('myliveshoppingmodule_ID', $prev_product_id);
                Configuration::updateValue('myliveshoppingmodule_SLIDE_INDEX', $current_index - 1);

                $product = new Product($prev_product_id, false, (int)$this->context->language->id);
                $product_name = Validate::isLoadedObject($product) ? $product->name : 'Produit ID ' . $prev_product_id;

                $output .= $this->displayConfirmation(sprintf(
                    $this->l('⬅️ Retour au produit : %s (Étape %d/%d)'),
                    $product_name,
                    $current_index - 1,
                    count($list_ids)
                ));
            } else {
                $output .= $this->displayWarning($this->l('⚠️ Vous êtes au début du slide.'));
            }
        }

        // Sélection produit unitaire
        if (Tools::isSubmit('submitProduct')) {
            $id_product = (int)Tools::getValue('myliveshoppingmodule_ID');
            Configuration::updateValue('myliveshoppingmodule_ID', $id_product);
            $output .= $this->displayConfirmation($this->l('Produit mis en live avec succès.'));
        }

        // Ajout au panier client
        if (Tools::isSubmit('submitAddToCart')) {
            $customerId = (int)Tools::getValue('customer_id');
            $productId = (int)Configuration::get('myliveshoppingmodule_ID');
            $quantity = (int)Tools::getValue('quantity', 1);
            $id_product_attribute = (int)Tools::getValue('id_product_attribute', 0);

            $result = $this->myls_addProductToCustomerCart($customerId, $productId, $quantity, $id_product_attribute);
            if ($result['success']) {
                $output .= $this->displayConfirmation($this->l('✅ Le produit a été ajouté au panier du client.'));
            } else {
                $output .= $this->displayError($this->l('❌ Erreur : ') . $result['message']);
            }
        }

        // Export paniers
        if (Tools::getValue('myls_export')) {
            $this->myls_exportCartsTxt();
        }

        // Récupérer l'onglet actif
        $active_tab = Tools::getValue('active_tab', 'tab1');

        // ===== STRUCTURE DES ONGLETS =====
        $output .= '
        <div class="panel">
            <div class="panel-heading">
                <i class="icon-video-camera"></i> Live Shopping Configuration
            </div>

            <div class="nav-tabs-container">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="'.($active_tab == 'tab1' ? 'active' : '').'">
                        <a href="'.$this->context->link->getAdminLink('AdminModules', true).'&configure='.$this->name.'&active_tab=tab1">
                            <i class="icon-home"></i> ACCUEIL
                        </a>
                    </li>
                    <li class="'.($active_tab == 'tab2' ? 'active' : '').'">
                        <a href="'.$this->context->link->getAdminLink('AdminModules', true).'&configure='.$this->name.'&active_tab=tab2">
                            <i class="icon-cogs"></i> CUSTOMISATION - PREPARATION
                        </a>
                    </li>
                    <li class="'.($active_tab == 'tab3' ? 'active' : '').'">
                        <a href="'.$this->context->link->getAdminLink('AdminModules', true).'&configure='.$this->name.'&active_tab=tab3">
                            <i class="icon-video-camera"></i> LIVE
                        </a>
                    </li>
                </ul>
            </div>

            <div class="tab-content panel-body">
                '.$this->renderTabContent($active_tab).'
            </div>
        </div>

        <style>
            .nav-tabs-container {
                margin-bottom: 0;
            }
            .nav-tabs {
                border-bottom: 1px solid #ff0000ff;
                list-style: none;
                padding: 0;
                margin: 0;
                display: flex;
                flex-direction: row;
            }
            .nav-tabs > li {
                margin-bottom: -1px;
                display: inline-block;
                float: left;
            }
            .nav-tabs > li > a {
                display: block;
                padding: 10px 15px;
                border: 1px solid transparent;
                border-radius: 4px 4px 0 0;
                text-decoration: none;
                color: #333;
            }
            .nav-tabs > li.active > a,
            .nav-tabs > li.active > a:hover,
            .nav-tabs > li.active > a:focus {
                background-color: #dfadadff;
                border: 1px solid #ff0000ff;
                border-bottom-color: transparent;
                color: #555;
            }
            .nav-tabs > li > a:hover {
                background-color: #ebc9c9ff;
                border-color: #eee #eee #ddd;
            }
            .tab-content {
                padding-top: 30px !important;
            }
            .switch-toggle:hover .slider {
                opacity: 0.9;
            }
        </style>
        ';

        return $output;
    }

    // ========================================
    // GESTION DES ONGLETS
    // ========================================

    private function renderTabContent($active_tab)
    {
        switch ($active_tab) {
            case 'tab1':
                return $this->renderTabAccueil();
            case 'tab2':
                return $this->renderTabCustomisation();
            case 'tab3':
                return $this->renderTabLive();
            default:
                return $this->renderTabAccueil();
        }
    }

    // ========================================
    // ONGLET 1 : ACCUEIL
    // ========================================

    private function renderTabAccueil()
    {
        $output = '';
        $is_enabled = (int)Configuration::get('myliveshoppingmodule_ENABLED');
        $shop_url = $this->context->shop->getBaseURL(true);
        $iframe_code = '<iframe width="100%" height="700" style="border: 0;" src="' . $shop_url . 'module/myliveshoppingmodule/display" frameborder="0"></iframe>';

        // Logo et présentation
        $output .= '<div class="form-group text-center">';
        $output .= '<img src="../modules/'.$this->name.'/logo.png" alt="Logo" style="max-width:120px; margin-bottom:10px;">';
        $output .= '<p>'.$this->l('Merci d\'utiliser le module My Live Shopping Module. Ce module unique et professionnel va transformer vos clients en acheteurs immédiats.').'</p>';
        $output .= '</div>';

        $output .= '<hr>';

        // 0. ACTIVATION DU MODULE
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-power-off"></i> 0. Activation du module';
        $output .= '</h3>';

        $status_text = $is_enabled ? 'ACTIF' : 'INACTIF';
        $output .= '<div class="alert alert-' . ($is_enabled ? 'success' : 'danger') . '" style="text-align: center; padding: 20px;">';
        $output .= '<h4 style="margin: 0;"><strong>Statut du module : <span style="font-size: 24px;">'.$status_text.'</span></strong></h4>';
        $output .= '</div>';

        $output .= '<div class="alert alert-' . ($is_enabled ? 'warning' : 'info') . '">';
        $output .= '<p><strong>ℹ️ Comment fonctionne ce module :</strong></p>';
        $output .= '<ul style="margin-bottom: 0;">';
        $output .= '<li><strong>Quand ACTIF :</strong> Le stock est décrémenté dès qu\'un client ajoute le produit dans son panier</li>';
        $output .= '<li><strong>Quand INACTIF :</strong> Le stock fonctionne normalement (décrémentation lors de la commande)</li>';
        $output .= '</ul>';
        if ($is_enabled) {
            $output .= '<hr style="margin: 10px 0;">';
            $output .= '<p style="margin: 0; color: #8a6d3b;"><strong>⚠️ ATTENTION :</strong> Le module est actuellement ACTIF. N\'oubliez pas de le désactiver après votre session de live shopping !</p>';
        }
        $output .= '</div>';

        // Bouton toggle
        $output .= '<div style="text-align: center; padding: 30px; background: #f9f9f9; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<p style="font-size: 16px; margin-bottom: 20px;"><strong>Cliquez pour activer ou désactiver le module :</strong></p>';
        $output .= '<form method="post" id="toggleForm" style="display: inline-block;">';
        $output .= '<input type="hidden" name="submitToggle" value="1">';
        $output .= '<input type="hidden" name="myliveshoppingmodule_ENABLED" id="hiddenToggleValue" value="' . ($is_enabled ? '1' : '0') . '">';
        $output .= '<label class="switch-toggle" style="position: relative; display: inline-block; width: 120px; height: 60px; cursor: pointer;">';
        $output .= '<input type="checkbox" id="toggleSwitch" ' . ($is_enabled ? 'checked' : '') . ' style="opacity: 0; width: 0; height: 0;">';
        $output .= '<span class="slider" style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background-color: ' . ($is_enabled ? '#5cb85c' : '#d9534f') . '; border-radius: 60px; transition: 0.4s;"></span>';
        $output .= '<span class="slider-text-on" style="position: absolute; color: white; font-weight: bold; font-size: 14px; left: 15px; top: 50%; transform: translateY(-50%); display: ' . ($is_enabled ? 'block' : 'none') . ';">ON</span>';
        $output .= '<span class="slider-text-off" style="position: absolute; color: white; font-weight: bold; font-size: 14px; right: 15px; top: 50%; transform: translateY(-50%); display: ' . ($is_enabled ? 'none' : 'block') . ';">OFF</span>';
        $output .= '<span class="slider-button" style="position: absolute; height: 52px; width: 52px; left: ' . ($is_enabled ? '64px' : '4px') . '; bottom: 4px; background-color: white; border-radius: 50%; transition: 0.4s; box-shadow: 0 2px 5px rgba(0,0,0,0.2);"></span>';
        $output .= '</label>';
        $output .= '</form>';
        $output .= '</div>';

        $output .= '<script>
        document.addEventListener("DOMContentLoaded", function() {
            var toggleSwitch = document.getElementById("toggleSwitch");
            var slider = document.querySelector(".slider");
            var sliderButton = document.querySelector(".slider-button");
            var textOn = document.querySelector(".slider-text-on");
            var textOff = document.querySelector(".slider-text-off");
            var hiddenInput = document.getElementById("hiddenToggleValue");
            var form = document.getElementById("toggleForm");

            toggleSwitch.addEventListener("change", function() {
                var isChecked = this.checked;
                var currentlyEnabled = ' . ($is_enabled ? 'true' : 'false') . ';

                var confirmMessage = "";
                if (isChecked && !currentlyEnabled) {
                    confirmMessage = "⚠️ ATTENTION\\n\\nVous allez ACTIVER le live shopping.\\n\\nÀ partir de maintenant, chaque ajout au panier décrémentera immédiatement le stock réel.\\n\\nContinuer ?";
                } else if (!isChecked && currentlyEnabled) {
                    confirmMessage = "✅ Vous allez DÉSACTIVER le live shopping.\\n\\nLe stock reviendra à son fonctionnement normal.\\n\\nConfirmer ?";
                }

                if (confirmMessage && !confirm(confirmMessage)) {
                    this.checked = !isChecked;
                    return false;
                }

                if (isChecked) {
                    slider.style.backgroundColor = "#5cb85c";
                    sliderButton.style.left = "64px";
                    textOn.style.display = "block";
                    textOff.style.display = "none";
                    hiddenInput.value = "1";
                } else {
                    slider.style.backgroundColor = "#d9534f";
                    sliderButton.style.left = "4px";
                    textOn.style.display = "none";
                    textOff.style.display = "block";
                    hiddenInput.value = "0";
                }

                form.submit();
            });
        });
        </script>';

        $output .= '<hr>';

        // INTÉGRATION
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-code"></i> Intégration : Dans une page créée spécialement';
        $output .= '</h3>';

        $output .= '<div class="alert alert-info">';
        $output .= '<strong>📋 Instructions :</strong>';
        $output .= '<ol style="margin: 10px 0 0 0; padding-left: 20px;">';
        $output .= '<li>Allez dans <strong>Apparence > Pages</strong></li>';
        $output .= '<li>Cliquez sur <strong>Ajouter une page</strong></li>';
        $output .= '<li>Créez votre page</li>';
        $output .= '<li>Cliquez sur <strong>Modifier</strong></li>';
        $output .= '<li>Dans <strong>Contenu de la page</strong>, cliquez sur <strong>&lt;&gt;</strong> (mode HTML)</li>';
        $output .= '<li>Copiez-collez le code ci-dessous</li>';
        $output .= '<li>Enregistrez</li>';
        $output .= '</ol>';
        $output .= '</div>';

        $output .= '<div class="alert alert-success">';
        $output .= '<strong>🌐 URL de votre site :</strong> <code>' . htmlspecialchars($shop_url) . '</code>';
        $output .= '</div>';

        $output .= '<div style="background: white; padding: 15px; border: 1px solid #ddd; border-radius: 5px;">';
        $output .= '<label style="font-weight: bold; margin-bottom: 10px; display: block;">📄 Code à copier :</label>';
        $output .= '<pre style="background: #2d2d2d; color: #f8f8f2; padding: 15px; border-radius: 5px; overflow-x: auto; margin: 0 0 10px 0;"><code>' . htmlspecialchars($iframe_code) . '</code></pre>';
        $output .= '<button type="button" class="btn btn-primary" onclick="copyIframeCode()">';
        $output .= '<i class="icon-copy"></i> Copier le code';
        $output .= '</button>';
        $output .= '</div>';

        $output .= '<script>
        function copyIframeCode() {
            var code = ' . json_encode($iframe_code) . ';
            var temp = document.createElement("textarea");
            temp.value = code;
            document.body.appendChild(temp);
            temp.select();
            try {
                document.execCommand("copy");
                alert("✅ Code copié dans le presse-papier !");
            } catch (err) {
                alert("❌ Erreur lors de la copie. Copiez manuellement le code.");
            }
            document.body.removeChild(temp);
        }
        </script>';

        return $output;
    }

    // ========================================
    // ONGLET 2 : CUSTOMISATION - PREPARATION
    // ========================================

        private function renderTabCustomisation()
    {
        $output = '';

        // 1-1. CUSTOMISATION DES COULEURS DU BLOC PRODUIT
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-paint-brush"></i> 1-1. 🎨 Customisation des couleurs du bloc produit en LIVE';
        $output .= '</h3>';

        $output .= '<form method="post" action="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'">';
        $output .= '<div class="row">';

        // Couleur de fond
        $output .= '<div class="col-md-4">';
        $output .= '<div class="form-group">';
        $output .= '<label>Couleur de fond du bloc produit</label>';
        $current_bg = Configuration::get('myliveshoppingmodule_BG_COLOR') ?: '#f08ec4';
        $output .= '<input type="color" name="myliveshoppingmodule_BG_COLOR" value="'.$current_bg.'" class="form-control" style="height: 45px;">';
        $output .= '<input type="text" value="'.$current_bg.'" class="form-control" style="margin-top:5px;" readonly>';
        $output .= '<small class="help-block">Valeur actuelle : '.$current_bg.'</small>';
        $output .= '</div>';
        $output .= '</div>';

        // Couleur de bordure
        $output .= '<div class="col-md-4">';
        $output .= '<div class="form-group">';
        $output .= '<label>Couleur de la bordure</label>';
        $current_border = Configuration::get('myliveshoppingmodule_BORDER_COLOR') ?: '#ff006a';
        $output .= '<input type="color" name="myliveshoppingmodule_BORDER_COLOR" value="'.$current_border.'" class="form-control" style="height: 45px;">';
        $output .= '<input type="text" value="'.$current_border.'" class="form-control" style="margin-top:5px;" readonly>';
        $output .= '<small class="help-block">Valeur actuelle : '.$current_border.'</small>';
        $output .= '</div>';
        $output .= '</div>';

        // Couleur du texte
        $output .= '<div class="col-md-4">';
        $output .= '<div class="form-group">';
        $output .= '<label>Couleur du texte</label>';
        $current_text = Configuration::get('myliveshoppingmodule_TEXT_COLOR') ?: '#333333';
        $output .= '<input type="color" name="myliveshoppingmodule_TEXT_COLOR" value="'.$current_text.'" class="form-control" style="height: 45px;">';
        $output .= '<input type="text" value="'.$current_text.'" class="form-control" style="margin-top:5px;" readonly>';
        $output .= '<small class="help-block">Valeur actuelle : '.$current_text.'</small>';
        $output .= '</div>';
        $output .= '</div>';

        $output .= '</div>';
        $output .= '<button type="submit" name="submitColors" value="1" class="btn btn-success">';
        $output .= '<i class="icon-paint-brush"></i> Sauvegarder les couleurs du produit';
        $output .= '</button>';
        $output .= '</form>';

        $output .= '<hr>';

        // 1-2. CUSTOMISATION DES COULEURS DU MINICHAT
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-comments"></i> 1-2. 💬 Customisation des couleurs du MiniChat';
        $output .= '</h3>';

        $output .= '<form method="post" action="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'">';
        $output .= '<div class="row">';

        // Couleur 1 du header chat
        $output .= '<div class="col-md-6">';
        $output .= '<div class="form-group">';
        $output .= '<label>Couleur 1 du header chat (dégradé gauche)</label>';
        $current_chat_color1 = Configuration::get('myliveshoppingmodule_CHAT_COLOR1') ?: '#667eea';
        $output .= '<input type="color" name="myliveshoppingmodule_CHAT_COLOR1" value="'.$current_chat_color1.'" class="form-control" style="height: 45px;">';
        $output .= '<input type="text" value="'.$current_chat_color1.'" class="form-control" style="margin-top:5px;" readonly>';
        $output .= '<small class="help-block">Valeur actuelle : '.$current_chat_color1.'</small>';
        $output .= '</div>';
        $output .= '</div>';

        // Couleur 2 du header chat
        $output .= '<div class="col-md-6">';
        $output .= '<div class="form-group">';
        $output .= '<label>Couleur 2 du header chat (dégradé droite)</label>';
        $current_chat_color2 = Configuration::get('myliveshoppingmodule_CHAT_COLOR2') ?: '#d341a2';
        $output .= '<input type="color" name="myliveshoppingmodule_CHAT_COLOR2" value="'.$current_chat_color2.'" class="form-control" style="height: 45px;">';
        $output .= '<input type="text" value="'.$current_chat_color2.'" class="form-control" style="margin-top:5px;" readonly>';
        $output .= '<small class="help-block">Valeur actuelle : '.$current_chat_color2.'</small>';
        $output .= '</div>';
        $output .= '</div>';

        $output .= '</div>';

        // Aperçu en direct
        $output .= '<div class="alert alert-info">';
        $output .= '<strong>📌 Aperçu du dégradé :</strong><br>';
        $output .= '<div style="height: 60px; background: linear-gradient(135deg, '.$current_chat_color1.' 0%, '.$current_chat_color2.' 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 16px; margin-top: 10px;">';
        $output .= '💬 Discussion Live';
        $output .= '</div>';
        $output .= '</div>';

        $output .= '<button type="submit" name="submitChatColors" value="1" class="btn btn-success">';
        $output .= '<i class="icon-paint-brush"></i> Sauvegarder les couleurs du chat';
        $output .= '</button>';
        $output .= '</form>';

        $output .= '<hr>';


        // 1-3. QUANTITÉ MAXIMALE
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-shopping-cart"></i> 1-2. 🛒 Quantité maximum pour mise en panier';
        $output .= '</h3>';

        $output .= '<form method="post" action="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'">';
        $output .= '<div class="row">';
        $output .= '<div class="col-lg-6">';
        $output .= '<div class="form-group">';
        $output .= '<label class="control-label col-lg-4">';
        $output .= $this->l('Quantité maximale par client');
        $output .= '</label>';
        $output .= '<div class="col-lg-8">';
        $output .= '<input type="number" name="myliveshoppingmodule_MAX_QTY" value="'.(int)Configuration::get('myliveshoppingmodule_MAX_QTY', 3).'" required="required" class="fixed-width-sm" min="1" />';
        $output .= '<p class="help-block">'.$this->l('Quantité maximale par client pour chaque déclinaison.').'</p>';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '<div class="panel-footer">';
        $output .= '<button type="submit" name="submitMaxQty" class="btn btn-default pull-right">';
        $output .= '<i class="process-icon-save"></i> '.$this->l('Enregistrer la quantité');
        $output .= '</button>';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '</form>';

        $output .= '<hr>';

        // 2-1. BLOC TEXTE ENRICHI 1
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-text-width"></i> 2-1. Bloc Customisation texte ou vidéo numéro 1';
        $output .= '</h3>';

        $helper = new HelperForm();
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');
        $helper->allow_employee_form_lang = (int)Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG');
        $helper->fields_value['myliveshoppingmodule_RICH_TEXT'] = Configuration::get('myliveshoppingmodule_RICH_TEXT', $this->context->language->id);

        $fields_form = [
            'form' => [
                'legend' => ['title' => $this->l('Texte ou vidéo (pour vidéo live : cliquez sur <> et collez votre iframe)'), 'icon' => 'icon-text'],
                'input' => [['type' => 'textarea', 'label' => $this->l('Contenu'), 'name' => 'myliveshoppingmodule_RICH_TEXT', 'cols' => 60, 'rows' => 10, 'class' => 'rte', 'autoload_rte' => true]],
                'submit' => ['title' => $this->l('Sauvegarder'), 'class' => 'btn btn-default pull-right', 'name' => 'submitRichText']
            ]
        ];
        $output .= $helper->generateForm([$fields_form]);

        $output .= '<hr>';

        // 2-2. BLOC TEXTE ENRICHI 2
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-text-width"></i> 2-2. Bloc Customisation texte ou vidéo numéro 2';
        $output .= '</h3>';

        $helper2 = new HelperForm();
        $helper2->module = $this;
        $helper2->name_controller = $this->name;
        $helper2->token = Tools::getAdminTokenLite('AdminModules');
        $helper2->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper2->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');
        $helper2->allow_employee_form_lang = (int)Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG');
        $helper2->fields_value['myliveshoppingmodule_RICH_TEXT_2'] = Configuration::get('myliveshoppingmodule_RICH_TEXT_2', $this->context->language->id);

        $fields_form_2 = [
            'form' => [
                'legend' => ['title' => $this->l('Texte ou vidéo (pour vidéo live : cliquez sur <> et collez votre iframe)'), 'icon' => 'icon-text'],
                'input' => [['type' => 'textarea', 'label' => $this->l('Contenu'), 'name' => 'myliveshoppingmodule_RICH_TEXT_2', 'cols' => 60, 'rows' => 10, 'class' => 'rte', 'autoload_rte' => true]],
                'submit' => ['title' => $this->l('Sauvegarder'), 'class' => 'btn btn-default pull-right', 'name' => 'submitRichText_2']
            ]
        ];
        $output .= $helper2->generateForm([$fields_form_2]);

        return $output;
    }

    // ========================================
    // ONGLET 3 : LIVE
    // ========================================

    private function renderTabLive()
    {
        $output = '';
        $lang_id = (int)$this->context->language->id;
        $current_product_id = (int)Configuration::get('myliveshoppingmodule_ID');
        $current_slide_list = Configuration::get('myliveshoppingmodule_SLIDE_LIST');
        $current_slide_index = (int)Configuration::get('myliveshoppingmodule_SLIDE_INDEX');
        $total_slide_products = count(array_filter(array_map('trim', explode(',', $current_slide_list))));


        // ==================================================
        // CONTRÔLE WEBCAM (BACK-OFFICE UNIQUEMENT)
        // Remplacer le Bloc 1 existant dans renderTabLive()
        // ==================================================

        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 2px; border-radius: 5px; margin-bottom: 2px;">';
        $output .= '<i class="icon-video-camera"></i> 2. 🎥 Contrôle de la Webcam en Direct';
        $output .= '</h3>';

        // Traitement du formulaire webcam
        if (Tools::isSubmit('submitWebcamControl')) {
            $webcam_active = (int)Tools::getValue('webcam_active', 0);
            $webcam_format = pSQL(Tools::getValue('webcam_format', 'landscape'));
            
            Configuration::updateValue('myliveshoppingmodule_WEBCAM_ACTIVE', $webcam_active);
            Configuration::updateValue('myliveshoppingmodule_WEBCAM_FORMAT', $webcam_format);
            
            if ($webcam_active) {
                $output .= $this->displayConfirmation($this->l('✅ Webcam activée ! Les visiteurs voient maintenant votre caméra en direct.'));
            } else {
                $output .= $this->displayConfirmation($this->l('⏹️ Webcam désactivée. Le flux vidéo n\'est plus visible sur le live.'));
            }
        }

        $webcam_active = (int)Configuration::get('myliveshoppingmodule_WEBCAM_ACTIVE', 0);
        $webcam_format = Configuration::get('myliveshoppingmodule_WEBCAM_FORMAT', 'landscape');

        $output .= '<div class="panel">';
        $output .= '<div class="panel-heading"><i class="icon-video-camera"></i> Pilotage de la Webcam</div>';
        $output .= '<div class="panel-body">';

        // Statut actuel GRAND ET VISIBLE
        $status_text = $webcam_active ? '🔴 EN DIRECT' : '⚫ ARRÊTÉE';
        $status_class = $webcam_active ? 'success' : 'danger';
        $status_bg = $webcam_active ? '#28a745' : '#dc3545';

        $output .= '<div class="alert alert-' . $status_class . '" style="text-align: center; padding: 5px; margin-bottom: 5px; background: ' . $status_bg . '; color: white; border: none;">';
        $output .= '<h3style="margin: 0; font-size: 40px; font-weight: bold;">' . $status_text . '</h3>';
        $output .= '<p style="margin: 10px 0 0 0; font-size: 14px; opacity: 0.9;">';
        if ($webcam_active) {
            $output .= 'Les visiteurs voient votre webcam sur la page du live';
        } else {
            $output .= 'La webcam n\'est pas diffusée actuellement';
        }
        $output .= '</p>';
        $output .= '</div>';

        // Formulaire de contrôle
        $output .= '<form method="post" id="webcamControlForm">';

        // ==========================================
        // BOUTONS DE CONTRÔLE PRINCIPAUX
        // ==========================================
        $output .= '<div style="text-align: center; margin-bottom: 5px;">';

        if (!$webcam_active) {
            // Bouton DÉMARRER (grand et visible)
            $output .= '<button type="submit" name="submitWebcamControl" class="btn btn-success btn-lg" style="padding: 20px 50px; font-size: 24px; font-weight: bold; border-radius: 40px; box-shadow: 0 4px 15px rgba(40, 167, 69, 0.4);">';
            $output .= '<input type="hidden" name="webcam_active" value="1">';
            $output .= '<input type="hidden" name="webcam_format" value="' . $webcam_format . '">';
            $output .= '<i class="icon-play-circle" style="font-size: 32px; margin-right: 15px;"></i> DÉMARRER LA WEBCAM';
            $output .= '</button>';
        } else {
            // Bouton ARRÊTER (grand et visible)
            $output .= '<button type="submit" name="submitWebcamControl" class="btn btn-danger btn-lg" style="padding: 20px 40px; font-size: 24px; font-weight: bold; border-radius: 50px; box-shadow: 0 4px 15px rgba(220, 53, 69, 0.4);">';
            $output .= '<input type="hidden" name="webcam_active" value="0">';
            $output .= '<input type="hidden" name="webcam_format" value="' . $webcam_format . '">';
            $output .= '<i class="icon-stop" style="font-size: 32px; margin-right: 15px;"></i> ARRÊTER LA WEBCAM';
            $output .= '</button>';
        }

        $output .= '</div>';

        $output .= '</form>';

        // ==========================================
        // CONFIGURATION DU FORMAT (Formulaire séparé)
        // ==========================================
        $output .= '<hr style="margin: 10px 0;">';

        $output .= '<h4><i class="icon-desktop"></i> Format d\'affichage de la webcam</h4>';

        $output .= '<form method="post">';
        $output .= '<input type="hidden" name="webcam_active" value="' . $webcam_active . '">';

        $output .= '<div class="form-group">';
        $output .= '<label class="control-label"><strong>Choisissez le format vidéo</strong></label>';
        $output .= '<div style="margin-top: 5px;">';

        $formats = [
            'landscape' => ['label' => '📺 Paysage (16:9)', 'icon' => '▬', 'desc' => 'Format horizontal classique - Recommandé pour ordinateurs'],
            'portrait' => ['label' => '📱 Portrait (9:16)', 'icon' => '▮', 'desc' => 'Format vertical - Idéal pour smartphones'],
            'square' => ['label' => '⬜ Carré (1:1)', 'icon' => '▪', 'desc' => 'Format carré - Style Instagram/TikTok']
        ];

        foreach ($formats as $format => $data) {
            $checked = ($webcam_format === $format) ? 'checked' : '';
            
            $output .= '<label class="radio-block webcam-format-option" style="display: block; margin-bottom: 10px; padding: 20px; border: 2px solid ' . ($checked ? '#007bff' : '#ddd') . '; border-radius: 8px; cursor: pointer; transition: all 0.3s; background: ' . ($checked ? '#e7f3ff' : 'white') . ';">';
            $output .= '<input type="radio" name="webcam_format" value="' . $format . '" ' . $checked . ' style="margin-right: 12px;">';
            $output .= '<span style="font-size: 28px; margin-right: 12px; vertical-align: middle;">' . $data['icon'] . '</span>';
            $output .= '<strong style="font-size: 16px; vertical-align: middle;">' . $data['label'] . '</strong>';
            $output .= '<br><small style="color: #666; margin-left: 52px;">' . $data['desc'] . '</small>';
            $output .= '</label>';
        }

        $output .= '</div>';
        $output .= '<p class="help-block"><i class="icon-info-circle"></i> Le format sera appliqué lors du prochain démarrage de la webcam</p>';
        $output .= '</div>';

        $output .= '<button type="submit" name="submitWebcamControl" class="btn btn-primary">';
        $output .= '<i class="icon-save"></i> Enregistrer le format';
        $output .= '</button>';

        $output .= '</form>';

        // ==========================================
        // INFORMATIONS & INSTRUCTIONS
        // ==========================================
        $output .= '<hr style="margin: 40px 0;">';

        $output .= '<div class="alert alert-info">';
        $output .= '<strong><i class="icon-lightbulb-o"></i> Comment ça fonctionne :</strong>';
        $output .= '<ol style="margin: 10px 0 0 20px;">';
        $output .= '<li><strong>Cliquez sur "DÉMARRER LA WEBCAM"</strong> ci-dessus</li>';
        $output .= '<li>Votre navigateur demandera l\'autorisation d\'accéder à votre caméra</li>';
        $output .= '<li><strong>Autorisez l\'accès</strong> (une seule fois)</li>';
        $output .= '<li>La webcam sera <strong>automatiquement diffusée</strong> sur votre page live</li>';
        $output .= '<li>Les visiteurs verront votre caméra en temps réel (latence ~1-2 secondes)</li>';
        $output .= '<li>Pour arrêter : cliquez sur <strong>"ARRÊTER LA WEBCAM"</strong></li>';
        $output .= '</ol>';
        $output .= '</div>';

        $output .= '<div class="alert alert-warning">';
        $output .= '<strong><i class="icon-warning-sign"></i> Important :</strong>';
        $output .= '<ul style="margin: 10px 0 0 0;">';
        $output .= '<li>Testez votre webcam <strong>avant</strong> de démarrer le live officiel</li>';
        $output .= '<li>Assurez-vous d\'avoir une <strong>bonne connexion internet</strong> (minimum 5 Mbps en upload)</li>';
        $output .= '<li>La webcam doit être <strong>libre</strong> (pas utilisée par Zoom, Teams, etc.)</li>';
        $output .= '<li>Pour diffuser sur <strong>YouTube/Facebook/Twitch</strong>, utilisez OBS Studio (voir Bloc 2)</li>';
        $output .= '</ul>';
        $output .= '</div>';

        // Prévisualisation du flux (si actif)
        if ($webcam_active) {
            $output .= '<hr style="margin: 40px 0;">';
            $output .= '<h4><i class="icon-eye"></i> Prévisualisation de votre webcam</h4>';
            $output .= '<div style="max-width: 600px; margin: 20px auto; border: 3px solid #28a745; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 20px rgba(0,0,0,0.2);">';
            
            $preview_styles = [
                'landscape' => 'aspect-ratio: 16/9;',
                'portrait' => 'aspect-ratio: 9/16; max-width: 400px;',
                'square' => 'aspect-ratio: 1/1; max-width: 500px;'
            ];
            
            $output .= '<video id="admin-webcam-preview" autoplay playsinline muted style="width: 100%; height: 100%; display: block; background: #000; ' . $preview_styles[$webcam_format] . '"></video>';
            $output .= '</div>';
            $output .= '<p style="text-align: center; color: #666; margin-top: 10px;"><small>👆 Ceci est ce que vos visiteurs voient actuellement</small></p>';
            
            // Script pour activer la prévisualisation
            $output .= '<script>
            (function() {
                var preview = document.getElementById("admin-webcam-preview");
                if (preview && navigator.mediaDevices && navigator.mediaDevices.getUserMedia) {
                    navigator.mediaDevices.getUserMedia({
                        video: {
                            width: { ideal: ' . ($webcam_format === 'portrait' ? '720' : ($webcam_format === 'square' ? '1080' : '1280')) . ' },
                            height: { ideal: ' . ($webcam_format === 'portrait' ? '1280' : ($webcam_format === 'square' ? '1080' : '720')) . ' },
                            facingMode: "user"
                        },
                        audio: true
                    })
                    .then(function(stream) {
                        preview.srcObject = stream;
                        console.log("✅ Prévisualisation webcam activée");
                    })
                    .catch(function(err) {
                        console.error("Erreur prévisualisation:", err);
                        preview.style.background = "linear-gradient(135deg, #dc3545 0%, #c82333 100%)";
                        preview.innerHTML = "<div style=\"display:flex;align-items:center;justify-content:center;height:100%;color:white;text-align:center;padding:20px;\"><div><i class=\"icon-warning-sign\" style=\"font-size:48px;margin-bottom:10px;\"></i><br>Impossible d\'afficher la prévisualisation</div></div>";
                    });
                }
            })();
            </script>';
        }

        $output .= '</div></div>'; // panel-body + panel

        // JavaScript pour le style interactif
        $output .= '<script>
        $(document).ready(function() {
            $("input[name=webcam_format]").on("change", function() {
                $(".webcam-format-option").css({
                    "border-color": "#ddd",
                    "background": "white"
                });
                
                $(this).closest(".webcam-format-option").css({
                    "border-color": "#007bff",
                    "background": "#e7f3ff"
                });
            });
            
            // Animation du bouton au survol
            $(".btn-lg").hover(
                function() {
                    $(this).css("transform", "scale(1.05)");
                },
                function() {
                    $(this).css("transform", "scale(1)");
                }
            );
        });
        </script>';

        $output .= '<style>
        .webcam-format-option:hover {
            border-color: #007bff !important;
            box-shadow: 0 2px 12px rgba(0,123,255,0.3);
        }

        .btn-lg {
            transition: all 0.3s ease;
        }
        </style>';

        $output .= '<hr>';

        // ============================================
        // SECTION ADMINISTRATION DU CHAT
        // ============================================

        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-comments"></i> 3. 💬 Administration du Chat Live';
        $output .= '</h3>';


        // ✅ COMPTEUR VIEWERS EN TEMPS RÉEL (ADMIN)
        $clients_connectes = (int)Db::getInstance()->getValue(
            'SELECT COUNT(DISTINCT session_id) FROM `' . _DB_PREFIX_ . 'live_viewers`
            WHERE last_seen > DATE_SUB(NOW(), INTERVAL 10 SECOND)
            AND id_customer > 0
            AND id_customer != 999999'
        );

        $output .= '<div class="panel" style="background: linear-gradient(135deg, #ff0e87ff 0%, #ff6600ff 100%); border: none; margin-bottom: 10px; position: relative; overflow: hidden;">';

        // Animation de fond
        $output .= '<div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; opacity: 0.1; background: linear-gradient(90deg, transparent, white, transparent); animation: wave 3s infinite;"></div>';

        $output .= '<div id="live_stats_container" class="panel-body" style="color: white; padding: 20px; position: relative; z-index: 1;">';
        $output .= '<div style="text-align: center;">';

        // Affichage simplifié du compteur
        $output .= '<div style="display: flex; align-items: center; justify-content: center; gap: 15px;">';

        // Icône et nombre de clients
        $output .= '<div style="display: flex; flex-direction: column; align-items: center;">';
        $output .= '<span style="font-size: 30px; line-height: 1; margin-bottom: 5px;">✓</span>'; // Icône ✓
        $output .= '<span style="font-size: 28px; font-weight: 900; text-shadow: 2px 2px 4px rgba(0,0,0,0.3);">' . $clients_connectes . '</span>';
        $output .= '<span style="font-size: 14px; font-weight: 600; text-transform: uppercase; letter-spacing: 1px; opacity: 0.95; margin-top: 5px;">';
        $output .= 'Client' . ($clients_connectes > 1 ? 's' : '') . ' connecté' . ($clients_connectes > 1 ? 's' : '');
        $output .= '</span>';
        $output .= '</div>';
        // --- Fin de la partie à simplifier ---

        $output .= '</div>'; // Fermeture du flex centré

        // Indicateur live
        if ($clients_connectes > 0) {
            $output .= '<div style="margin-top: 20px; display: inline-flex; align-items: center; gap: 10px; background: rgba(255,255,255,0.2); padding: 10px 20px; border-radius: 25px;">';
            $output .= '<div style="width: 12px; height: 12px; background: #ff00aaff; border-radius: 50%; box-shadow: 0 0 20px #ff0000; animation: pulse-live 2s infinite;"></div>';
            $output .= '<span style="font-size: 14px; font-weight: 600;">EN DIRECT</span>';
            $output .= '</div>';
        } else {
            $output .= '<div style="margin-top: 20px; font-size: 14px; opacity: 0.7;">⏸️ Aucun spectateur actuellement</div>';
        }

        $output .= '</div>';
        $output .= '</div>';
        $output .= '</div>';

        // Info actualisation
        $output .= '<div style="text-align: center; margin-top: 25px; font-size: 12px; opacity: 0.8; border-top: 1px solid rgba(255,255,255,0.2); padding-top: 15px;">';
        $output .= '<i class="icon-refresh"></i> Actualisation automatique toutes les 10 secondes';
        $output .= '</div>';

        $output .= '</div></div>';

        // Styles et animation
        $output .= '<style>
        @keyframes wave {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }

        @keyframes pulse-live {
            0%, 100% {
                opacity: 1;
                transform: scale(1);
                box-shadow: 0 0 20px #ff0000;
            }
            50% {
                opacity: 0.5;
                transform: scale(1.3);
                box-shadow: 0 0 30px #ff0000;
            }
        }
        </style>';

        // Script auto-refresh (sans reload complet)
        $output .= '<script>
        var viewerRefreshTimer = setInterval(function() {
            // Refresh uniquement la section du compteur via AJAX
            fetch(window.location.href, {
                headers: { "X-Requested-With": "XMLHttpRequest" }
            })
            .then(function(response) { return response.text(); })
            .then(function(html) {
                var parser = new DOMParser();
                var doc = parser.parseFromString(html, "text/html");
                
                // CIBLAGE PRÉCIS PAR ID (Ne touche plus à la webcam)
                var newCounter = doc.getElementById("live_stats_container");
                var currentCounter = document.getElementById("live_stats_container");
                
                // Sécurité supplémentaire : on vérifie qu on a bien trouvé les éléments
                if (newCounter && currentCounter) {
                    currentCounter.innerHTML = newCounter.innerHTML;
                }
            })
            .catch(function(error) {
                console.log("Refresh viewer count failed:", error);
            });
        }, 10000); // Toutes les 10 secondes

        // Arrêter le refresh si on quitte la page
        window.addEventListener("beforeunload", function() {
            if (viewerRefreshTimer) clearInterval(viewerRefreshTimer);
        });
        </script>';

        $employee = $this->context->employee;
        if (!$employee || !$employee->id) {
            $output .= '<div class="alert alert-danger">Erreur : Employé non connecté</div>';
        } else {
            // Compter les messages
            $sql = 'SELECT COUNT(*) FROM `'._DB_PREFIX_.'minichat_messages` WHERE is_deleted = 0';
            $messageCount = Db::getInstance()->getValue($sql);

            $output .= '<div class="panel">';
            $output .= '<div class="panel-heading"><i class="icon-comments"></i> Chat Support - Vue Administrateur</div>';
            $output .= '<div class="panel-body">';

            // Boutons d'actions
            $output .= '<div class="row" style="margin-bottom: 15px;">';
            $output .= '<div class="col-md-12">';
            $output .= '<div class="btn-group">';
            $output .= '<button type="button" onclick="exportChatHistory()" class="btn btn-default">';
            $output .= '<i class="icon-download"></i> Exporter en TXT';
            $output .= '</button>';
            $output .= '<button type="button" onclick="clearChatHistory()" class="btn btn-danger">';
            $output .= '<i class="icon-trash"></i> Vider l\'historique';
            $output .= '</button>';
            $output .= '<span class="badge" style="margin-left: 15px; padding: 7px 12px; background: #25b9d7; color: white; font-size: 14px;">';
            $output .= sprintf('%d messages', $messageCount);
            $output .= '</span>';
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';

            // Widget du chat admin
            $output .= '<div id="admin-minichat-container" style="height: 400px; border: 1px solid #ddd; border-radius: 4px; display: flex; flex-direction: column;">';
            $output .= '<div id="admin-chat-messages" style="flex: 1; overflow-y: auto; padding: 15px 35px; background: #f8f9fa; position: relative;"></div>';
            $output .= '<div style="padding: 10px; background: white; border-top: 1px solid #ddd;">';
            $output .= '<div style="display: flex;">';
            $output .= '<input type="text" id="admin-chat-input" placeholder="Tapez votre message..." style="flex: 1; padding: 8px; border: 1px solid #ddd; border-radius: 4px;" maxlength="200">';
            $output .= '<button onclick="AdminMiniChat.send()" class="btn btn-primary" style="margin-left: 10px;">Envoyer</button>';
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';

            $output .= '<div style="margin-top: 10px; padding: 10px; background: #f8f9fa; border-radius: 4px;">';
            $output .= '<small style="color: #666;">';
            $output .= '<i class="icon-info-circle"></i> Astuce : Survolez les messages pour voir le bouton de suppression (×). Les messages supprimés sont masqués mais peuvent être récupérés depuis la base de données si nécessaire.';
            $output .= '</small>';
            $output .= '</div>';

            $output .= '</div></div>';

            // JavaScript pour le chat admin
            $output .= '<script>
            var AdminMiniChat = {
                url: "' . $this->_path . 'ajax_chat.php",
                employeeId: ' . (int)$employee->id . ',
                adminToken: "' . Tools::substr(Tools::encrypt('minichat'.$employee->id), 0, 10) . '",
                lastMessageId: 0,
                timer: null,

                init: function() {
                    this.loadMessages();
                    this.startPolling();

                    document.getElementById("admin-chat-input").addEventListener("keypress", function(e) {
                        if (e.key === "Enter") {
                            AdminMiniChat.send();
                        }
                    });
                },

                loadMessages: function() {
                    fetch(this.url + "?action=getMessages&lastId=" + this.lastMessageId)
                        .then(response => response.json())
                        .then(data => {
                            if (data.success && data.messages) {
                                this.displayMessages(data.messages);
                            }
                        });
                },

                displayMessages: function(messages) {
                    var container = document.getElementById("admin-chat-messages");

                    messages.forEach(function(msg) {
                        if (document.querySelector("[data-admin-msg-id=\\"" + msg.id_message + "\\"]")) {
                            return;
                        }

                        var messageDiv = document.createElement("div");
                        messageDiv.setAttribute("data-admin-msg-id", msg.id_message);
                        messageDiv.style.marginBottom = "10px";
                        messageDiv.style.position = "relative";

                        var isOwnMessage = (msg.id_employee == AdminMiniChat.employeeId);

                        // Bouton de suppression
                        var deleteBtn = "<button onclick=\\"AdminMiniChat.deleteMessage(" + msg.id_message + ")\\" " +
                            "style=\\"position: absolute; top: 0; " + (isOwnMessage ? "left" : "right") + ": -30px; " +
                            "background: #dc3545; color: white; border: none; " +
                            "width: 24px; height: 24px; border-radius: 50%; " +
                            "cursor: pointer; font-size: 12px; opacity: 0.6; transition: opacity 0.2s;\\" " +
                            "onmouseover=\\"this.style.opacity=1\\" onmouseout=\\"this.style.opacity=0.6\\" " +
                            "title=\\"Supprimer le message\\">×</button>";

                        messageDiv.innerHTML =
                            "<div style=\\"display: flex; align-items: flex-start; " + (isOwnMessage ? "flex-direction: row-reverse;" : "") + "\\">" +
                            deleteBtn +
                            "<div style=\\"max-width: 70%;\\">" +
                            "<div style=\\"font-size: 12px; color: #666; margin-bottom: 4px;\\">" +
                            "<strong>" + msg.display_name + "</strong> " +
                            "<span style=\\"background: #e9ecef; padding: 2px 6px; border-radius: 10px; font-size: 10px;\\">" + msg.customer_id_display + "</span> " +
                            "<span style=\\"color: #999;\\">" + msg.time + "</span>" +
                            "</div>" +
                            "<div style=\\"padding: 10px; border-radius: 10px; background: " + (isOwnMessage ? "#007bff; color: white;" : "#f1f1f1;") + "\\">" +
                            msg.message +
                            "</div>" +
                            "</div>" +
                            "</div>";

                        container.appendChild(messageDiv);
                        AdminMiniChat.lastMessageId = Math.max(AdminMiniChat.lastMessageId, parseInt(msg.id_message));
                    });

                    container.scrollTop = container.scrollHeight;
                },

                deleteMessage: function(messageId) {
                    if (!confirm("Êtes-vous sûr de vouloir supprimer ce message ?")) {
                        return;
                    }

                    var formData = new FormData();
                    formData.append("action", "deleteMessage");
                    formData.append("message_id", messageId);
                    formData.append("id_employee", this.employeeId);
                    formData.append("admin_token", this.adminToken);

                    fetch(this.url, {
                        method: "POST",
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            var msgElement = document.querySelector("[data-admin-msg-id=\\"" + messageId + "\\"]");
                            if (msgElement) {
                                msgElement.style.transition = "opacity 0.3s";
                                msgElement.style.opacity = "0";
                                setTimeout(function() {
                                    msgElement.remove();
                                }, 300);
                            }
                        } else {
                            alert("Erreur : " + (data.error || "Échec de la suppression"));
                        }
                    })
                    .catch(error => {
                        console.error("Erreur de suppression:", error);
                        alert("Erreur lors de la suppression");
                    });
                },

                send: function() {
                    var input = document.getElementById("admin-chat-input");
                    if (!input.value.trim()) return;

                    var formData = new FormData();
                    formData.append("action", "sendAdminMessage");
                    formData.append("message", input.value.trim());
                    formData.append("id_employee", this.employeeId);
                    formData.append("admin_token", this.adminToken);

                    fetch(this.url, {
                        method: "POST",
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            input.value = "";
                            this.loadMessages();
                        }
                    });
                },

                startPolling: function() {
                    this.timer = setInterval(() => {
                        this.loadMessages();
                    }, 3000);
                }
            };

            document.addEventListener("DOMContentLoaded", function() {
                AdminMiniChat.init();
            });

            function exportChatHistory() {
                window.open("' . $this->_path . 'export_chat.php", "_blank");
            }

            function clearChatHistory() {
                if (!confirm("Êtes-vous sûr de vouloir vider tout l\'historique du chat ? Cette action est irréversible.")) {
                    return;
                }

                fetch("' . $this->_path . 'ajax_chat.php", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/x-www-form-urlencoded"
                    },
                    body: "action=clearHistory&token=' . Tools::getAdminTokenLite('AdminModules') . '"
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert("Historique vidé avec succès");
                        location.reload();
                    } else {
                        alert("Erreur : " + (data.error || "Échec du vidage"));
                    }
                });
            }
            </script>';
        }

        $output .= '<hr>';

        // 4. LISTE DE PRODUITS SLIDE
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-list"></i> 4. Produit à diffuser en live : Faites une LISTE avec des ID ARTICLES';
        $output .= '</h3>';

        $output .= '<div class="panel">';
        $output .= '<div class="panel-heading"><i class="icon-list"></i> Gestion du slide</div>';
        $output .= '<div class="panel-body">';

        // Statut actuel
        $list_string = Configuration::get('myliveshoppingmodule_SLIDE_LIST');
        $list_ids = array_values(array_map('intval', array_filter(array_map('trim', explode(',', $list_string)))));

        $current_product_name = 'Aucun';
        if ($current_product_id > 0) {
            $prod = new Product($current_product_id, false, $lang_id);
            if (Validate::isLoadedObject($prod)) {
                $current_product_name = $prod->name . ' (ID: ' . $current_product_id . ')';
            }
        }

        $next_product_name = 'Aucun';
        if (!empty($list_ids) && $current_slide_index < count($list_ids)) {
            $next_id = $list_ids[$current_slide_index];
            $next_prod = new Product($next_id, false, $lang_id);
            if (Validate::isLoadedObject($next_prod)) {
                $next_product_name = $next_prod->name . ' (ID: ' . $next_id . ')';
            }
        }

        $output .= '<div class="row">';
        $output .= '<div class="col-md-6">';
        $output .= '<div class="alert alert-info">';
        $output .= '<h3 style="margin-top:0;"><i class="icon-shopping-cart"></i> Produit en LIVE</h3>';
        $output .= '<p style="margin:0;"><strong>' . $current_product_name . '</strong></p>';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '<div class="col-md-6">';
        $output .= '<div class="alert alert-warning">';
        $output .= '<h4 style="margin-top:0;"><i class="icon-forward"></i> Produit suivant</h4>';
        $output .= '<p style="margin:0;"><strong>' . $next_product_name . '</strong></p>';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '</div>';

        // Barre de progression
        $progress_percent = $total_slide_products > 0 ? round(($current_slide_index / $total_slide_products) * 100) : 0;
        $output .= '<div style="margin-bottom: 20px;">';
        $output .= '<div style="display: flex; justify-content: space-between; margin-bottom: 5px;">';
        $output .= '<span><strong>Progression du slide</strong></span>';
        $output .= '<span><strong>' . $current_slide_index . ' / ' . $total_slide_products . '</strong></span>';
        $output .= '</div>';
        $output .= '<div style="background: #e9ecef; height: 25px; border-radius: 4px; overflow: hidden;">';
        $output .= '<div style="background: linear-gradient(to right, #28a745, #20c997); height: 100%; width: ' . $progress_percent . '%; transition: width 0.3s; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold;">';
        $output .= $progress_percent > 10 ? $progress_percent . '%' : '';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '</div>';

        $output .= '<hr>';

        // Configuration de la liste
        $output .= '<h4><i class="icon-edit"></i> Configuration de la liste</h4>';
        $output .= '<form method="post">';
        $output .= '<div class="form-group">';
        $output .= '<label>Liste des ID produits (séparés par virgule) :</label>';
        $output .= '<textarea name="myliveshoppingmodule_SLIDE_LIST" class="form-control" rows="3" placeholder="Exemple : 12,25,8,45,67">' . htmlspecialchars($current_slide_list) . '</textarea>';
        $output .= '<p class="help-block"><i class="icon-info-circle"></i> Entrez les ID des produits dans l\'ordre de diffusion.</p>';
        $output .= '</div>';
        $output .= '<button type="submit" name="submitSlideList" value="1" class="btn btn-primary">';
        $output .= '<i class="icon-save"></i> Enregistrer la Liste';
        $output .= '</button>';
        $output .= '</form>';

        $output .= '<hr>';

        // Navigation
        $output .= '<h4><i class="icon-play-circle"></i> Navigation dans le slide</h4>';

        $output .= '<div class="col-md-6">';
        $output .= '<form method="post" style="margin: 0;">';
        $disabled_next = ($current_slide_index >= $total_slide_products || empty($list_ids)) ? ' disabled' : '';
        $output .= '<button type="submit" name="submitNextSlideProduct" value="1" class="btn btn-success btn-lg" style="width: 100%;"' . $disabled_next . '>';
        $output .= '<i class="icon-arrow-right"></i> DEBUTER ou ATICLE SUIVANT';
        $output .= '</button>';
        $output .= '</form>';
        $output .= '</div>';
        $output .= '</div>';

        $output .= '<div class="row">';
        $output .= '<div class="col-md-6">';
        $output .= '<form method="post" style="margin: 0;">';
        $disabled_prev = ($current_slide_index <= 1 || empty($list_ids)) ? ' disabled' : '';
        $output .= '<button type="submit" name="submitPrevSlideProduct" value="1" class="btn btn-default btn-lg" style="width: 100%;"' . $disabled_prev . '>';
        $output .= '<i class="icon-arrow-left"></i> ATICLE PRÉCÉDENT';
        $output .= '</button>';
        $output .= '</form>';
        $output .= '</div>';

        $output .= '</div></div>';

        $output .= '<hr>';

        // 5. SÉLECTION UNITAIRE
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-hand-o-up"></i> 5. Produit à diffuser en LIVE : par sélection unitaire';
        $output .= '</h3>';

        $products = Product::getProducts($lang_id, 0, 1000, 'id_product', 'ASC');

        $output .= '<form method="post">';
        $output .= '<div class="form-group">';
        $output .= '<label>Catégorie :</label>';
        $output .= '<select id="category-select" class="form-control">';
        $output .= '<option value="0">-- Choisir --</option>';
        $categories_tree = Category::getNestedCategories(null, $lang_id, true);
        $this->buildCategoryOptions($categories_tree, $output, 0);
        $output .= '</select></div>';
        $output .= '<div class="form-group">';
        $output .= '<label>Produit :</label>';
        $output .= '<select name="myliveshoppingmodule_ID" id="product-select" class="form-control" disabled>';
        $output .= '<option value="0">-- Choisir catégorie d\'abord --</option>';
        $output .= '</select></div>';
        $output .= '<button type="submit" name="submitProduct" value="1" class="btn btn-primary" id="submit-product-btn" disabled>Mettre en live</button>';
        $output .= '</form>';

        // Préparer les données produits
        $products_data = array();
        foreach ($products as $product) {
            $product_obj = new Product($product['id_product']);
            $categories_ids = $product_obj->getCategories();
            foreach ($categories_ids as $cat_id) {
                if (!isset($products_data[$cat_id])) $products_data[$cat_id] = array();
                $products_data[$cat_id][] = array(
                    'id' => $product['id_product'],
                    'name' => $product['name'],
                    'price' => Tools::displayPrice($product['price'])
                );
            }
        }

        $output .= '<script>
        var productsData = ' . json_encode($products_data) . ';
        var currentProductId = ' . (int)$current_product_id . ';
        $(document).ready(function(){
            function updateProducts(categoryId){
                var $productSelect=$("#product-select");
                $productSelect.empty();
                if(categoryId==0){
                    $productSelect.append(\'<option value="0">-- Sélectionner catégorie --</option>\');
                    $productSelect.prop("disabled",true);
                    $("#submit-product-btn").prop("disabled",true);
                    return;
                }
                $productSelect.append(\'<option value="0">-- Choisir produit --</option>\');
                var hasProducts=false;
                if(productsData[categoryId]){
                    hasProducts=true;
                    $.each(productsData[categoryId],function(index,product){
                        var selected=(product.id==currentProductId)?"selected":"";
                        $productSelect.append(\'<option value="\'+product.id+\'" \'+selected+\'>\'+product.name+\' - \'+product.price+\'</option>\');
                    });
                }
                if(hasProducts){
                    $productSelect.prop("disabled",false);
                }else{
                    $productSelect.append(\'<option value="0">Aucun produit</option>\');
                    $productSelect.prop("disabled",true);
                }
            }
            $("#category-select").on("change",function(){updateProducts($(this).val())});
            $("#product-select").on("change",function(){$("#submit-product-btn").prop("disabled",$(this).val()<=0)});
        });
        </script>';

        $output .= '<hr>';

        // 6. STOCK EN TEMPS RÉEL
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-bar-chart"></i> 6. 📊 Stock en temps réel';
        $output .= '</h3>';
        $output .= $this->myls_displayStockInfo();

        $output .= '<hr>';

        // 7 - AJOUTER AU PANIER DU CLIENT
        $output .= '<hr>';

        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">
        <i class="icon-code"></i> 7. Ajouter le produit en live à un panier client
        </h3>';

        // Vérifier qu'un produit est bien sélectionné en live
        if ($current_product_id > 0) {
            $current_product = new Product($current_product_id, false, $this->context->language->id);
            if (Validate::isLoadedObject($current_product)) {
                $output .= '<div class="alert alert-info">';
                $output .= '<strong>Produit actuellement en live :</strong> ' . $current_product->name . ' (ID: ' . $current_product_id . ')';
                $output .= '</div>';
            }

            // Charger TOUS les clients, triés par ID
            $sql = 'SELECT c.id_customer, c.firstname, c.lastname, c.email
                    FROM ' . _DB_PREFIX_ . 'customer c
                    WHERE c.active = 1
                    ORDER BY c.id_customer ASC';
            $all_customers = Db::getInstance()->executeS($sql);

            $output .= '<div class="panel">';
            $output .= '<div class="panel-heading">Sélectionner un client afin de leur composer un panier. Le client devra vérifier et ajuster ou non son panier pour validation et continuer son processus de paiement. </div>';
            $output .= '<div class="panel-body">';

            // MÉTHODE 1 : Menu déroulant avec tous les clients
            $output .= '<div class="form-group">';
            $output .= '<label><strong>Méthode 1 : Sélectionner dans la liste complète</strong></label>';
            $output .= '<select id="customer-dropdown" class="form-control" style="width: 100%;">';
            $output .= '<option value="">-- Choisir un client --</option>';

            if ($all_customers) {
                foreach ($all_customers as $customer) {
                    $customer_display = sprintf(
                        '[ID: %d] %s %s - %s',
                        $customer['id_customer'],
                        $customer['lastname'],
                        $customer['firstname'],
                        $customer['email']
                    );
                    $output .= '<option value="' . $customer['id_customer'] . '" ';
                    $output .= 'data-firstname="' . htmlspecialchars($customer['firstname']) . '" ';
                    $output .= 'data-lastname="' . htmlspecialchars($customer['lastname']) . '" ';
                    $output .= 'data-email="' . htmlspecialchars($customer['email']) . '">';
                    $output .= htmlspecialchars($customer_display);
                    $output .= '</option>';
                }
            }

            $output .= '</select>';
            $output .= '<p class="help-block">Total : ' . count($all_customers) . ' clients actifs</p>';
            $output .= '</div>';

            $output .= '<hr>';

            // MÉTHODE 2 : Recherche par texte
            $output .= '<div class="form-group">';
            $output .= '<label><strong>Méthode 2 : Recherche rapide</strong></label>';
            $output .= '<div class="input-group">';
            $output .= '<input type="text" id="customer-search-text" class="form-control" placeholder="Tapez nom, prénom ou email...">';
            $output .= '<span class="input-group-btn">';
            $output .= '<button type="button" id="btn-search" class="btn btn-primary">';
            $output .= '<i class="icon-search"></i> Rechercher';
            $output .= '</button>';
            $output .= '</span>';
            $output .= '</div>';
            $output .= '<div id="search-results" style="margin-top: 10px; max-height: 200px; overflow-y: auto;"></div>';
            $output .= '</div>';

            $output .= '<hr>';

            // MÉTHODE 3 : Recherche par ID
            $output .= '<div class="form-group">';
            $output .= '<label><strong>Méthode 3 : Recherche par ID client</strong></label>';
            $output .= '<div class="input-group">';
            $output .= '<input type="number" id="customer-id-search" class="form-control" placeholder="Entrez l\'ID du client" min="1">';
            $output .= '<span class="input-group-btn">';
            $output .= '<button type="button" id="btn-search-id" class="btn btn-info">';
            $output .= '<i class="icon-search"></i> Rechercher par ID';
            $output .= '</button>';
            $output .= '</span>';
            $output .= '</div>';
            $output .= '</div>';

            $output .= '</div>'; // Fin panel-body
            $output .= '</div>'; // Fin panel

            // Zone d'affichage du client sélectionné
            $output .= '<div id="selected-customer-panel" class="panel panel-success" style="display: none;">';
            $output .= '<div class="panel-heading">';
            $output .= '<h3 class="panel-title"><i class="icon-user"></i> Client sélectionné pour l\'ajout au panier</h3>';
            $output .= '</div>';
            $output .= '<div class="panel-body">';

            $output .= '<div class="row">';
            $output .= '<div class="col-md-6">';
            $output .= '<table class="table table-condensed">';
            $output .= '<tr><td><strong>ID Client :</strong></td><td id="display-customer-id">-</td></tr>';
            $output .= '<tr><td><strong>Nom :</strong></td><td id="display-customer-lastname">-</td></tr>';
            $output .= '<tr><td><strong>Prénom :</strong></td><td id="display-customer-firstname">-</td></tr>';
            $output .= '<tr><td><strong>Email :</strong></td><td id="display-customer-email">-</td></tr>';
            $output .= '</table>';
            $output .= '</div>';
            $output .= '<div class="col-md-6">';
            $output .= '<div id="customer-cart-info" class="alert alert-info">';
            $output .= 'Chargement des informations du panier...';
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';

            // Formulaire d'ajout au panier
            $output .= '<form method="post" id="add-to-cart-form">';
            $output .= '<input type="hidden" name="customer_id" id="hidden-customer-id">';

            // Si le produit a des déclinaisons
            if ($current_product->hasAttributes()) {
                $combinations = $current_product->getAttributeCombinations($this->context->language->id);
                if ($combinations) {
                    $output .= '<div class="form-group">';
                    $output .= '<label>Sélectionner une déclinaison :</label>';
                    $output .= '<select name="id_product_attribute" class="form-control">';
                    $output .= '<option value="0">-- Produit sans déclinaison --</option>';

                    $processed_combinations = array();
                    foreach ($combinations as $combination) {
                        $id_pa = $combination['id_product_attribute'];
                        if (!isset($processed_combinations[$id_pa])) {
                            $processed_combinations[$id_pa] = array(
                                'attributes' => array(),
                                'quantity' => StockAvailable::getQuantityAvailableByProduct($current_product_id, $id_pa)
                            );
                        }
                        $processed_combinations[$id_pa]['attributes'][] = $combination['attribute_name'];
                    }

                    foreach ($processed_combinations as $id_pa => $comb_data) {
                        $attributes_str = implode(' - ', $comb_data['attributes']);
                        $stock_info = ' (Stock: ' . $comb_data['quantity'] . ')';
                        $output .= '<option value="' . $id_pa . '">' . $attributes_str . $stock_info . '</option>';
                    }

                    $output .= '</select>';
                    $output .= '</div>';
                }
            }

            $output .= '<div class="form-group">';
            $output .= '<label>Quantité :</label>';
            $output .= '<input type="number" name="quantity" value="1" min="1" max="2" class="form-control" style="width: 100px;">';
            $output .= '<small class="help-block">Maximum 2 unités pendant le live shopping</small>';
            $output .= '</div>';

            $output .= '<div class="form-group">';
            $output .= '<button type="submit" name="submitAddToCart" value="1" class="btn btn-success btn-lg">';
            $output .= '<i class="icon-shopping-cart"></i> Ajouter le produit en live dans son panier';
            $output .= '</button>';
            $output .= ' <button type="button" id="btn-reset-selection" class="btn btn-default">Changer de client</button>';
            $output .= '</div>';
            $output .= '</form>';

            $output .= '</div>'; // Fin panel-body
            $output .= '</div>'; // Fin panel

            // JavaScript pour gérer les interactions
            $output .= '<script>
                $(document).ready(function(){
                    var customersData = ' . json_encode($all_customers) . ';
                    var selectedCustomerId = null;

                    function selectCustomer(customerId, firstname, lastname, email) {
                        if (!customerId) return;

                        $("#display-customer-id").text(customerId);
                        $("#display-customer-firstname").text(firstname);
                        $("#display-customer-lastname").text(lastname);
                        $("#display-customer-email").text(email);
                        $("#hidden-customer-id").val(customerId);

                        selectedCustomerId = customerId;
                        $("#selected-customer-panel").slideDown();

                        loadCartInfo(customerId);
                    }

                    // Charger le dernier panier ouvert
                    function loadCartInfo(customerId) {
                        $("#customer-cart-info").html(\'<i class="icon-spinner icon-spin"></i> Chargement...\');

                        $.ajax({
                            url: "' . $this->context->link->getAdminLink('AdminModules') . '",
        data: {
            ajax: 1,
            action: "getLastCart",
            module: "myliveshoppingmodule",
            configure: "myliveshoppingmodule",
            id_customer: customerId
        },

                            success: function(response) {
                                if (response && response.id_cart) {
                                    var html = "<strong>Dernier panier actif :</strong> #" + response.id_cart + " (" + response.date_upd + ")<br>";
                                    if (response.products && response.products.length > 0) {
                                        html += "<ul>";
                                        response.products.forEach(function(p){
                                            html += "<li>" + p.qty + "x " + p.name + "</li>";
                                        });
                                        html += "</ul>";
                                    } else {
                                        html += "<em>Panier vide</em>";
                                    }
                                    $("#customer-cart-info").html(html);
                                } else {
                                    $("#customer-cart-info").html("<em>Aucun panier actif pour ce client</em>");
                                }
                            },
                            error: function() {
                                $("#customer-cart-info").html("<em>Erreur lors du chargement du panier</em>");
                            }
                        });
                    }


                    // Sélection depuis le menu déroulant
                    $("#customer-dropdown").on("change", function(){
                        var customerId = $(this).val();
                        if (customerId) {
                            var option = $(this).find("option:selected");
                            selectCustomer(
                                customerId,
                                option.data("firstname"),
                                option.data("lastname"),
                                option.data("email")
                            );
                        }
                    });

                    // Recherche par texte
                    $("#btn-search, #customer-search-text").on("click keyup", function(e){
                        if (e.type === "keyup" && e.which !== 13) return;
                        if (e.type === "click" && e.target.id !== "btn-search") return;

                        var searchText = $("#customer-search-text").val().toLowerCase();
                        if (searchText.length < 2) {
                            $("#search-results").html(\'<div class="alert alert-warning">Tapez au moins 2 caractères</div>\');
                            return;
                        }

                        var results = customersData.filter(function(customer) {
                            return customer.firstname.toLowerCase().includes(searchText) ||
                                customer.lastname.toLowerCase().includes(searchText) ||
                                customer.email.toLowerCase().includes(searchText);
                        });

                        if (results.length > 0) {
                            var html = \'<div class="list-group">\';
                            results.slice(0, 10).forEach(function(customer) {
                                html += \'<a href="#" class="list-group-item search-result-item" \';
                                html += \'data-id="\' + customer.id_customer + \'" \';
                                html += \'data-firstname="\' + customer.firstname + \'" \';
                                html += \'data-lastname="\' + customer.lastname + \'" \';
                                html += \'data-email="\' + customer.email + \'">\';
                                html += \'<strong>[ID: \' + customer.id_customer + \']</strong> \';
                                html += customer.lastname + \' \' + customer.firstname + \' - \' + customer.email;
                                html += \'</a>\';
                            });
                            html += \'</div>\';
                            if (results.length > 10) {
                                html += \'<p class="text-muted">... et \' + (results.length - 10) + \' autres résultats</p>\';
                            }
                            $("#search-results").html(html);
                        } else {
                            $("#search-results").html(\'<div class="alert alert-info">Aucun client trouvé</div>\');
                        }
                    });

                    // Clic sur un résultat de recherche
                    $(document).on("click", ".search-result-item", function(e){
                        e.preventDefault();
                        selectCustomer(
                            $(this).data("id"),
                            $(this).data("firstname"),
                            $(this).data("lastname"),
                            $(this).data("email")
                        );
                        $("#search-results").empty();
                        $("#customer-search-text").val("");
                    });

                    // Recherche par ID
                    $("#btn-search-id").on("click", function(){
                        var customerId = $("#customer-id-search").val();
                        if (!customerId) {
                            alert("Entrez un ID client");
                            return;
                        }

                        var customer = customersData.find(function(c) {
                            return c.id_customer == customerId;
                        });

                        if (customer) {
                            selectCustomer(
                                customer.id_customer,
                                customer.firstname,
                                customer.lastname,
                                customer.email
                            );
                            $("#customer-dropdown").val(customer.id_customer);
                        } else {
                            alert("Client avec l\\\'ID " + customerId + " non trouvé");
                        }
                    });

                    // Réinitialiser la sélection
                    $("#btn-reset-selection").on("click", function(){
                        $("#selected-customer-panel").slideUp();
                        $("#customer-dropdown").val("");
                        $("#customer-search-text").val("");
                        $("#customer-id-search").val("");
                        $("#search-results").empty();
                        selectedCustomerId = null;
                    });

                    // Validation avant soumission
                    $("#add-to-cart-form").on("submit", function(e){
                        if (!selectedCustomerId) {
                            e.preventDefault();
                            alert("Veuillez d\\\'abord sélectionner un client");
                            return false;
                        }
                    });
                });
            </script>';

        } else {
            $output .= '<div class="alert alert-warning">';
            $output .= '<i class="icon-warning-sign"></i> Veuillez d\'abord sélectionner un produit en live (étape 3) avant de pouvoir l\'ajouter aux paniers clients.';
            $output .= '</div>';
        }

        $output .= '<hr>';

        $live_start_time = Configuration::get('MYLIVESHOPPING_LIVE_START_DATE');
        $adminToken = Tools::getAdminTokenLite('AdminModules');

        $output .= '<hr>';

        // 8. STATISTIQUE DU LIVE
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-bar-chart"></i> 8. STATISTIQUE DU LIVE';
        $output .= '</h3>';

        $output .= '
        <div class="panel">
            <div class="panel-heading">
                <i class="icon-bar-chart"></i> Statistiques du Live
            </div>

            <div class="alert alert-info">
                Cette section analyse les performances depuis le démarrage du live.
            </div>

            ' . ($live_start_time ?
                '<div class="alert alert-success" id="live_start_time_display_container">
                    Collecte active depuis : <strong><span id="live_start_time_display">' . Tools::displayDate($live_start_time, null, true) . '</span></strong>
                </div>' :
                '<div class="alert alert-warning" id="live_start_time_display_container">
                    Le Live n\'a pas encore été démarré.
                </div>'
            ) . '

            <div class="form-group">
                <button type="button" class="btn btn-danger" id="resetLiveStatsButton">
                    <i class="icon-power-off"></i> Démarrer / Réinitialiser le Live
                </button>
                <button type="button" class="btn btn-default" id="exportLiveStatsButton">
                    <i class="icon-file-text"></i> Exporter (CSV)
                </button>
            </div>

            <hr/>

            <div id="liveStatsDashboard">
                <h4 class="text-center">📊 Performance du Live</h4>

                <!-- ROW 1 : AUDIENCE -->
                <div class="row">
                    <div class="col-md-4">
                        <div class="panel panel-info">
                            <div class="panel-body text-center">
                                <p class="h4">👥 Visiteurs Uniques</p>
                                <p class="h1 text-info" id="stat_visiteurs_uniques">0</p>
                                <small class="text-muted">Total depuis le début</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="panel panel-success">
                            <div class="panel-body text-center">
                                <p class="h4">✅ Acheteurs</p>
                                <p class="h1 text-success" id="stat_nb_acheteurs">0</p>
                                <small class="text-muted">Commandes validées</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="panel panel-warning">
                            <div class="panel-body text-center">
                                <p class="h4">🎯 Taux de Conversion</p>
                                <p class="h1 text-warning" id="stat_taux_conversion">0%</p>
                                <small class="text-muted">Visiteurs → Acheteurs</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ROW 2 : FINANCIER -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="panel panel-primary">
                            <div class="panel-body text-center">
                                <p class="h4">💰 CA Brut Total</p>
                                <p class="h1 text-primary" id="stat_ca_brut">0.00 €</p>
                                <small class="text-muted">Commandes validées</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="panel panel-default">
                            <div class="panel-body text-center">
                                <p class="h4">📈 Dépense Moyenne</p>
                                <p class="h1" id="stat_depense_moyenne">0.00 €</p>
                                <small class="text-muted">Par acheteur</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ROW 3 : STOCK & PANIER -->
                <div class="row">
                    <div class="col-md-4">
                        <div class="panel panel-default">
                            <div class="panel-body text-center">
                                <p class="h4">📦 Stock Initial</p>
                                <p class="h2" id="stat_stock_initial">0</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="panel panel-default">
                            <div class="panel-body text-center">
                                <p class="h4">📉 Ratio Vendu</p>
                                <p class="h2 text-danger" id="stat_ratio_vente">0%</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="panel panel-default">
                            <div class="panel-body text-center">
                                <p class="h4">🛍️ Articles / Acheteur</p>
                                <p class="h2" id="stat_articles_moyen">0</p>
                            </div>
                        </div>
                    </div>
                </div>

                <p class="text-center text-muted">
                    <small><i class="icon-clock-o"></i> Dernière mise à jour : <span id="stat_last_update">...</span></small>
                </p>
            </div>
        </div>

        <script>
        $(document).ready(function() {
            var adminToken = "' . $adminToken . '";
            var ajaxUrl = "' . __PS_BASE_URI__ . 'modules/' . $this->name . '/ajax_admin_stats.php";
            var statsTimer;

            function updateLiveStats() {
                $.ajax({
                    url: ajaxUrl,
                    type: "POST",
                    dataType: "json",
                    data: { action: "getLiveStats" },
                    success: function(response) {
                        if (response.success && response.stats) {
                            if (!response.stats.live_active) {
                                $("#liveStatsDashboard").hide();
                                $("#live_start_time_display_container")
                                    .removeClass("alert-success").addClass("alert-warning")
                                    .html(\'<i class="icon-warning-sign"></i> \' + response.stats.message);
                                return;
                            }

                            $("#liveStatsDashboard").show();
                            $("#live_start_time_display_container")
                                .removeClass("alert-warning").addClass("alert-success")
                                .html(\'Collecte active depuis : <strong><span id="live_start_time_display">\' + response.stats.live_start_time + \'</span></strong>\');

                            // Mise à jour des stats
                            $("#stat_visiteurs_uniques").text(response.stats.visiteurs_uniques);
                            $("#stat_nb_acheteurs").text(response.stats.nb_acheteurs);
                            $("#stat_taux_conversion").text(response.stats.taux_conversion);
                            $("#stat_ca_brut").text(response.stats.ca_brut);
                            $("#stat_depense_moyenne").text(response.stats.depense_moyenne);
                            $("#stat_stock_initial").text(response.stats.stock_initial);
                            $("#stat_ratio_vente").text(response.stats.ratio_vente);
                            $("#stat_articles_moyen").text(response.stats.articles_moyen);
                            $("#stat_last_update").text(response.timestamp);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAX Error:", status, error);
                    }
                });
            }

            $("#resetLiveStatsButton").click(function() {
                if (!confirm("Réinitialiser les statistiques du live ?")) return;

                $.ajax({
                    url: ajaxUrl,
                    type: "POST",
                    dataType: "json",
                    data: { action: "resetLiveStats", token: adminToken },
                    success: function(response) {
                        if (response.success) {
                            alert(response.message);
                            updateLiveStats();
                        } else {
                            alert("Erreur: " + response.error);
                        }
                    }
                });
            });

            $("#exportLiveStatsButton").click(function() {
                window.location.href = ajaxUrl + "?action=exportLiveStats&token=" + adminToken;
            });

            updateLiveStats();
            statsTimer = setInterval(updateLiveStats, 10000);
        });
        </script>
        ';

        $output .= '<hr>';

        // 8. PANIERS EN COURS
        $output .= '<h3 style="background-color: #dc3545; color: white; padding: 15px; border-radius: 5px; margin-bottom: 20px;">';
        $output .= '<i class="icon-shopping-cart"></i> 8. Paniers en cours';
        $output .= '</h3>';

        $refreshUrl = AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&myls_refresh=1';
        $exportUrl = AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&myls_export=1';
        $clearUrl = AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&myls_clear=1';

        $myls_carts = Tools::getValue('myls_clear') ? [] : $this->myls_getCarts();

        $output .= '<a class="btn btn-default" href="'.$refreshUrl.'"><i class="icon-refresh"></i> Actualiser</a> ';
        $output .= '<a class="btn btn-default" href="'.$exportUrl.'"><i class="icon-download"></i> Exporter</a> ';
        $output .= '<a class="btn btn-danger" href="'.$clearUrl.'"><i class="icon-trash"></i> Vider</a>';

        if (!empty($myls_carts)) {
            $output .= '<table class="table table-bordered" style="margin-top:10px;">';
            $output .= '<thead><tr>';
            $output .= '<th>ID</th><th>Nom</th><th>Prénom</th><th>Articles</th><th>Qté</th><th>Prix</th><th>Statut</th>';
            $output .= '</tr></thead><tbody>';

            foreach ($myls_carts as $cart) {
                $articles = array();
                foreach ($cart['products'] as $prod) {
                    $attr = !empty($prod['attributes']) ? ' - '.$prod['attributes'] : '';
                    $articles[] = htmlspecialchars($prod['name'] ?? '', ENT_QUOTES, 'UTF-8').$attr.' x'.$prod['quantity'];
                }
                $currency = $this->context->currency ?: new Currency((int)Configuration::get('PS_CURRENCY_DEFAULT'));

                $output .= '<tr>';
                $output .= '<td>'.(int)$cart['id_customer'].'</td>';
                $output .= '<td>'.htmlspecialchars($cart['lastname'] ?? '', ENT_QUOTES, 'UTF-8').'</td>';
                $output .= '<td>'.htmlspecialchars($cart['firstname'] ?? '', ENT_QUOTES, 'UTF-8').'</td>';
                $output .= '<td>'.implode('<br>', $articles).'</td>';
                $output .= '<td>'.(int)$cart['total_qty'].'</td>';
                $output .= '<td>'.Tools::displayPrice($cart['total_price'], $currency).'</td>';
                $output .= '<td>'.htmlspecialchars($cart['status'] ?? '', ENT_QUOTES, 'UTF-8').'</td>';
                $output .= '</tr>';
            }

            $output .= '</tbody></table>';
        } else {
            $output .= '<p style="margin-top: 20px;">Aucun panier en cours.</p>';
        }


        // ========================================
// SCRIPT BROADCASTER WEBCAM 
// ========================================

// ========================================
        // SCRIPT BROADCASTER WEBCAM AVEC SON
        // ========================================

        $output .= '<script>
var AdminWebcamBroadcaster = {
    stream: null,
    mediaRecorder: null,
    streamUrl: "' . $this->_path . 'ajax_stream.php",
    isStreaming: false,
    chunkDuration: 1000,
    checkInterval: null,
    
    init: function() {
        console.log("🎥 Initialisation broadcaster admin...");
        var self = this;
        var webcamActive = ' . (int)Configuration::get('myliveshoppingmodule_WEBCAM_ACTIVE', 0) . ';
        
        if (webcamActive) {
            // Attendre que la prévisualisation soit prête
            this.checkInterval = setInterval(function() {
                var videoEl = document.getElementById("admin-webcam-preview");
                if (videoEl && videoEl.srcObject && videoEl.srcObject.active) {
                    clearInterval(self.checkInterval);
                    console.log("📹 Flux vidéo détecté, démarrage broadcast...");
                    self.startBroadcast(videoEl);
                }
            }, 500);
            
            // Timeout après 10 secondes
            setTimeout(function() {
                if (self.checkInterval) {
                    clearInterval(self.checkInterval);
                    console.warn("⚠️ Timeout: flux vidéo non détecté après 10s");
                }
            }, 10000);
        }
    },
    
    startBroadcast: function(videoEl) {
        var self = this;
        this.stream = videoEl.srcObject;
        
        console.log("📡 Démarrage diffusion vers serveur...");
        
        // Informer le serveur
        fetch(this.streamUrl + "?action=startStream", { 
            method: "POST",
            credentials: "same-origin"
        })
        .then(function(r) { return r.json(); })
        .then(function(data) {
            console.log("📡 Réponse serveur:", data);
            if (data.success) {
                console.log("✅ Stream serveur OK:", data.stream_id);
                self.startRecording();
            } else {
                console.error("❌ Erreur serveur:", data.error);
            }
        })
        .catch(function(e) { 
            console.error("❌ Erreur connexion:", e); 
        });
    },
    
    startRecording: function() {
        var self = this;
        
        // Trouver le meilleur codec supporté
        var mimeTypes = [
            "video/webm;codecs=vp8,opus",
            "video/webm;codecs=vp9,opus", 
            "video/webm;codecs=vp8",
            "video/webm",
            "video/mp4"
        ];
        
        var mimeType = null;
        for (var i = 0; i < mimeTypes.length; i++) {
            if (MediaRecorder.isTypeSupported(mimeTypes[i])) {
                mimeType = mimeTypes[i];
                break;
            }
        }
        
        if (!mimeType) {
            console.error("❌ Aucun codec vidéo supporté par ce navigateur");
            alert("Votre navigateur ne supporte pas l\'enregistrement vidéo. Utilisez Chrome ou Firefox.");
            return;
        }
        
        console.log("🎬 Codec sélectionné:", mimeType);
        
        try {
            this.mediaRecorder = new MediaRecorder(this.stream, {
                mimeType: mimeType,
                videoBitsPerSecond: 500000,
                audioBitsPerSecond: 64000
            });
        } catch (e) {
            console.error("❌ Erreur création MediaRecorder:", e);
            return;
        }
        
        this.mediaRecorder.ondataavailable = function(event) {
            if (event.data && event.data.size > 0 && self.isStreaming) {
                console.log("📦 Chunk généré:", event.data.size, "bytes");
                self.uploadChunk(event.data);
            }
        };
        
        this.mediaRecorder.onerror = function(e) {
            console.error("❌ Erreur MediaRecorder:", e.error);
        };
        
        this.mediaRecorder.onstart = function() {
            console.log("✅ Enregistrement démarré");
        };
        
        this.isStreaming = true;
        this.mediaRecorder.start(this.chunkDuration);
        
        console.log("🎥 Diffusion en cours... (chunks toutes les " + this.chunkDuration + "ms)");
    },
    
    uploadChunk: function(blob) {
        var self = this;
        var formData = new FormData();
        formData.append("action", "uploadChunk");
        formData.append("chunk", blob, "chunk.webm");
        
        fetch(this.streamUrl, {
            method: "POST",
            body: formData,
            credentials: "same-origin"
        })
        .then(function(r) { return r.json(); })
        .then(function(data) {
            if (data.success) {
                console.log("✅ Chunk envoyé #" + data.chunk_index);
            } else {
                console.warn("⚠️ Erreur upload:", data.error);
            }
        })
        .catch(function(e) {
            console.warn("⚠️ Erreur réseau upload:", e.message);
        });
    },
    
    stopBroadcast: function() {
        console.log("🛑 Arrêt diffusion...");
        this.isStreaming = false;
        
        if (this.checkInterval) {
            clearInterval(this.checkInterval);
        }
        
        if (this.mediaRecorder && this.mediaRecorder.state !== "inactive") {
            this.mediaRecorder.stop();
        }
        
        fetch(this.streamUrl + "?action=stopStream", { 
            method: "POST",
            credentials: "same-origin"
        }).catch(function(e) { 
            console.log("Info: stopStream -", e.message); 
        });
    }
};

// Lancement automatique
document.addEventListener("DOMContentLoaded", function() {
    var previewEl = document.getElementById("admin-webcam-preview");
    if (previewEl) {
        console.log("🎛️ Page admin Live détectée");
        
        // Petit délai pour laisser la webcam s\'initialiser
        setTimeout(function() {
            AdminWebcamBroadcaster.init();
        }, 2000);
        
        // Arrêt propre en quittant
        window.addEventListener("beforeunload", function() {
            AdminWebcamBroadcaster.stopBroadcast();
        });
    }
});
</script>';


        return $output;
    }

    // ========================================
    // FONCTIONS UTILITAIRES
    // ========================================

    private function buildCategoryOptions($categories, &$output, $level = 0, $parent_id = null)
    {
        foreach ($categories as $category) {
            if ($category['id_category'] == 1 || $category['id_category'] == 2) {
                if (isset($category['children'])) {
                    $this->buildCategoryOptions($category['children'], $output, $level);
                }
                continue;
            }

            $indent = str_repeat('— ', $level);
            $output .= '<option value="' . $category['id_category'] . '">';
            $output .= $indent . htmlspecialchars($category['name']);
            $output .= '</option>';

            if (isset($category['children']) && !empty($category['children'])) {
                $this->buildCategoryOptions($category['children'], $output, $level + 1, $category['id_category']);
            }
        }
    }

    private function myls_getProductCombinations($id_product)
    {
        $combinations = array();
        $product = new Product((int)$id_product);

        if (Validate::isLoadedObject($product) && $product->hasCombinations()) {
            $product_attributes = $product->getAttributesGroups($this->context->language->id);

            foreach ($product_attributes as $attribute) {
                $quantity = StockAvailable::getQuantityAvailableByProduct(
                    (int)$id_product,
                    (int)$attribute['id_product_attribute'],
                    (int)Context::getContext()->shop->id
                );

                $combinations[] = array(
                    'name' => $attribute['attribute_name'],
                    'group_name' => $attribute['group_name'],
                    'quantity' => (int)$quantity
                );
            }
        }

        return $combinations;
    }

    private function myls_getRealStock($id_product, $id_product_attribute = 0)
    {
        $stock = StockAvailable::getQuantityAvailableByProduct(
            (int)$id_product,
            (int)$id_product_attribute,
            (int)$this->context->shop->id
        );
        return (int)$stock;
    }

    private function myls_getStockOverview()
    {
        $live_product_id = (int)Configuration::get('myliveshoppingmodule_ID');

        if (!$live_product_id) {
            return null;
        }

        $product = new Product($live_product_id, false, $this->context->language->id);

        if (!Validate::isLoadedObject($product)) {
            return null;
        }

        $overview = [
            'product_name' => $product->name,
            'product_id' => $live_product_id,
            'stock_info' => []
        ];

        if (!$product->hasAttributes()) {
            $stock = $this->myls_getRealStock($live_product_id, 0);
            $overview['stock_info'][] = [
                'label' => 'Produit principal',
                'stock' => $stock,
                'id_product_attribute' => 0
            ];
        } else {
            $combinations = $product->getAttributeCombinations($this->context->language->id);
            $processed = [];

            foreach ($combinations as $combination) {
                $id_pa = (int)$combination['id_product_attribute'];

                if (!isset($processed[$id_pa])) {
                    $stock = $this->myls_getRealStock($live_product_id, $id_pa);
                    $attributes = [];
                    $processed[$id_pa] = true;

                    foreach ($combinations as $c) {
                        if ((int)$c['id_product_attribute'] === $id_pa) {
                            $attributes[] = $c['attribute_name'];
                        }
                    }

                    $overview['stock_info'][] = [
                        'label' => implode(' - ', $attributes),
                        'stock' => $stock,
                        'id_product_attribute' => $id_pa
                    ];
                }
            }
        }

        return $overview;
    }

    private function myls_displayStockInfo()
    {
        $overview = $this->myls_getStockOverview();

        if (!$overview) {
            return '<div class="alert alert-warning">⚠️ Aucun produit en live actuellement</div>';
        }

        $output = '<div class="panel">';
        $output .= '<div class="panel-heading"><i class="icon-bar-chart"></i> Stock en temps réel</div>';
        $output .= '<div class="panel-body">';
        $output .= '<h4>' . htmlspecialchars($overview['product_name']) . ' (ID: ' . $overview['product_id'] . ')</h4>';

        $total_stock = 0;
        foreach ($overview['stock_info'] as $info) {
            $total_stock += $info['stock'];
        }

        $output .= '<div class="alert alert-info" style="margin-bottom: 15px;">';
        $output .= '<strong>Stock total disponible : ' . $total_stock . '</strong>';
        $output .= '</div>';

        $output .= '<table class="table table-bordered table-striped">';
        $output .= '<thead><tr>';
        $output .= '<th style="width: 70%;">Déclinaison</th>';
        $output .= '<th style="width: 30%; text-align: center;">Stock disponible</th>';
        $output .= '</tr></thead><tbody>';

        foreach ($overview['stock_info'] as $info) {
            $color = $info['stock'] > 0 ? 'green' : 'red';
            $icon = $info['stock'] > 0 ? '✅' : '❌';

            $output .= '<tr>';
            $output .= '<td>' . htmlspecialchars($info['label']) . '</td>';
            $output .= '<td style="color: ' . $color . '; font-weight: bold; text-align: center; font-size: 16px;">';
            $output .= $icon . ' ' . $info['stock'];
            $output .= '</td>';
            $output .= '</tr>';
        }

        $output .= '</tbody></table>';

        $refresh_url = AdminController::$currentIndex . '&configure=' . $this->name . '&token=' . Tools::getAdminTokenLite('AdminModules');
        $output .= '<a href="' . $refresh_url . '" class="btn btn-primary">';
        $output .= '<i class="icon-refresh"></i> Actualiser le stock';
        $output .= '</a>';

        $output .= '<p style="margin-top: 10px; color: #999; font-size: 12px;">';
        $output .= '<i class="icon-clock-o"></i> Dernière actualisation : ' . date('d/m/Y H:i:s');
        $output .= '</p>';

        $output .= '</div></div>';


        return $output;
    }

    private function myls_getCarts()
    {
        $sql = 'SELECT c.*, cu.firstname, cu.lastname, o.id_order, c.date_upd
                FROM `'._DB_PREFIX_.'cart` c
                LEFT JOIN `'._DB_PREFIX_.'orders` o ON o.id_cart=c.id_cart
                LEFT JOIN `'._DB_PREFIX_.'customer` cu ON cu.id_customer=c.id_customer
                WHERE o.id_order IS NULL
                AND c.id_shop='.(int)Context::getContext()->shop->id.'
                AND c.date_upd>DATE_SUB(NOW(),INTERVAL 7 DAY)
                ORDER BY c.date_upd DESC';

        $rows = Db::getInstance()->executeS($sql);
        $carts = array();

        foreach ($rows as $row) {
            $cart = new Cart((int)$row['id_cart']);
            $products = $cart->getProducts(true);
            $status = empty($products) ? 'Abandonné' : (strtotime($row['date_upd']) > strtotime('-48 hours') ? 'En cours' : 'Abandonné');

            $qty = 0;
            $products_fmt = array();
            foreach ($products as $p) {
                $qty += (int)$p['cart_quantity'];
                $products_fmt[] = array(
                    'name' => $p['name'],
                    'attributes' => $p['attributes'],
                    'quantity' => (int)$p['cart_quantity']
                );
            }

            $carts[] = array(
                'id_cart' => (int)$row['id_cart'],
                'id_customer' => (int)$row['id_customer'],
                'firstname' => $row['firstname'],
                'lastname' => $row['lastname'],
                'products' => $products_fmt,
                'total_qty' => $qty,
                'total_price' => $cart->getOrderTotal(true, Cart::BOTH),
                'status' => $status,
                'date_upd' => $row['date_upd']
            );
        }

        return $carts;
    }

    private function myls_returnAbandonedStock()
    {
        $live_product_id = (int)Configuration::get('myliveshoppingmodule_ID');
        $returned_qty = 0;

        if ($live_product_id > 0) {
            $sql = 'SELECT c.id_cart, cp.id_product_attribute, cp.quantity
                    FROM `'._DB_PREFIX_.'cart` c
                    JOIN `'._DB_PREFIX_.'cart_product` cp ON cp.id_cart=c.id_cart
                    LEFT JOIN `'._DB_PREFIX_.'orders` o ON o.id_cart=c.id_cart
                    WHERE o.id_order IS NULL
                    AND cp.id_product='.(int)$live_product_id;

            $carts_to_clean = Db::getInstance()->executeS($sql);

            foreach ($carts_to_clean as $cart_product) {
                $current_stock = StockAvailable::getQuantityAvailableByProduct(
                    (int)$live_product_id,
                    (int)$cart_product['id_product_attribute']
                );

                if ($current_stock !== false) {
                    StockAvailable::updateQuantity(
                        (int)$live_product_id,
                        (int)$cart_product['id_product_attribute'],
                        (int)$cart_product['quantity'],
                        (int)Context::getContext()->shop->id
                    );
                    $returned_qty += (int)$cart_product['quantity'];
                }

                $cart = new Cart((int)$cart_product['id_cart']);
                $cart->deleteProduct((int)$live_product_id, (int)$cart_product['id_product_attribute']);
            }
        }

        return $returned_qty;
    }

    public function myls_addProductToCustomerCart($customer_id, $product_id, $quantity = 1, $id_product_attribute = 0)
    {
        $customer = new Customer((int)$customer_id);
        $cart = Cart::getCartByCustomerId((int)$customer->id);

        if (!$cart) {
            $cart = new Cart();
            $cart->id_shop_group = $this->context->shop->id_shop_group;
            $cart->id_shop = $this->context->shop->id;
            $cart->id_customer = (int)$customer->id;
            $cart->id_lang = (int)$this->context->language->id;
            $cart->id_currency = (int)$this->context->currency->id;

            if (!$cart->add()) {
                return ['success' => false, 'message' => $this->l('Erreur lors de la création du panier.')];
            }
        }

        // Assurez-vous que le panier est associé au contexte
        $this->context->cart = $cart;

        // Ajout du produit au panier
        $updateQuantity = $cart->updateQty(
            $quantity,
            $product_id,
            $id_product_attribute,
            false, // id_customization
            'up', // operation : 'up' pour ajouter
            $this->context->shop->id // id_shop
        );

        if ($updateQuantity) {
            // --- LOGIQUE CRITIQUE DE DÉCRÉMENTATION DU STOCK ---

            // La méthode updateQty de Cart met à jour la table ps_cart_product.
            // C'est StockAvailable::updateQuantity qui met à jour la table ps_stock_available.

            // 🚀 Solution : Décrémenter la quantité pour refléter l'ajout immédiat.
            // Utilisation de la fonction PrestaShop pour décrémenter le stock disponible.
            $success_stock = StockAvailable::updateQuantity(
                (int)$product_id,
                (int)$id_product_attribute,
                -1 * (int)$quantity, // Utiliser une quantité NÉGATIVE pour décrémenter
                (int)$this->context->shop->id
            );

            if (!$success_stock) {
                // Optionnel : Gérer l'échec de la décrémentation du stock (peu probable si l'ajout au panier a réussi)
                // Pour l'instant, on ignore cette erreur pour ne pas bloquer.
                // Si le stock n'est pas géré, cette ligne n'aura aucun effet.
            }

            // Mise à jour de la date et du récapitulatif du panier
            $cart->update();
            $cart->getPackageList(true); // Rafraîchir les produits du panier

            return [
                'success' => true,
                'message' => $this->l('Produit ajouté au panier et stock décrémenté.'),
                'cart_id' => $cart->id
            ];
        }

        return ['success' => false, 'message' => $this->l('Erreur lors de l\'ajout du produit au panier.')];
    }

    private function myls_exportCartsTxt()
    {
        $carts = $this->myls_getCarts();
        $filename = 'export_carts_'.date('Ymd_His').'.txt';

        header('Content-Type: text/plain; charset=utf-8');
        header('Content-Disposition: attachment; filename="'.$filename.'"');

        foreach ($carts as $cart) {
            echo "========================================\n";
            echo "Panier ID: " . $cart['id_cart'] . "\n";
            echo "Statut: " . $cart['status'] . "\n";
            echo "ID Client: " . (int)$cart['id_customer'] . "\n";
            echo "Nom: " . $cart['lastname'] . "\n";
            echo "Prénom: " . $cart['firstname'] . "\n";
            echo "Total TTC: " . $cart['total_price'] . "\n";
            echo "Quantité totale: " . (int)$cart['total_qty'] . "\n";
            echo "Articles:\n";

            foreach ($cart['products'] as $product) {
                $attributes = !empty($product['attributes']) ? ' (' . $product['attributes'] . ')' : '';
                echo " - " . $product['name'] . $attributes . " x" . $product['quantity'] . "\n";
            }

            echo "========================================\n\n";
        }

        exit;
    }

    public function ajaxProcessGetLastCart()
    {
        header('Content-Type: application/json; charset=utf-8');
        if (ob_get_length()) ob_clean();

        $id_customer = (int)Tools::getValue('id_customer');
        if (!$id_customer) {
            echo json_encode(['error' => 'Aucun client']);
            exit;
        }

        $allCarts = $this->myls_getCarts();
        $carts = array_filter($allCarts, function ($c) use ($id_customer) {
            return (int)$c['id_customer'] === $id_customer;
        });

        if (empty($carts)) {
            echo json_encode(['id_cart' => null, 'products' => []]);
            exit;
        }

        $lastCart = reset($carts);
        echo json_encode([
            'id_cart' => (int)$lastCart['id_cart'],
            'date_upd' => $lastCart['date_upd'],
            'products' => $lastCart['products'],
            'total_qty' => $lastCart['total_qty'],
            'total_price' => $lastCart['total_price'],
            'status' => $lastCart['status']
        ]);
        exit;
    }

    public function ajaxProcessAddToCart()
    {
        if (Tools::isSubmit('ajax') && Tools::isSubmit('action') && Tools::getValue('action') == 'addToCart') {
            if (!$this->context->employee || !$this->context->employee->isLoggedBack()) {
                die(json_encode(['success' => false, 'message' => $this->l('Non autorisé')]));
            }

            $customer_id = (int)Tools::getValue('customer_id');
            $product_id = (int)Tools::getValue('product_id');
            $quantity = (int)Tools::getValue('quantity', 1);
            $id_product_attribute = (int)Tools::getValue('id_product_attribute', 0);
            $id_lang = (int)$this->context->language->id;

            // --- 1. Exécuter l'ajout au panier ---
            $result = $this->myls_addProductToCustomerCart(
                $customer_id,
                $product_id,
                $quantity,
                $id_product_attribute
            );

            // --- 2. LOGIQUE D'ENVOI DU MESSAGE AU CHAT (AJOUTÉE) ---
            if ($result['success'] && $customer_id == 999999) { // Vérifie si l'ajout est réussi ET que c'est un ajout "Admin" (client ID 999999)

                // Récupérer le nom du produit de base
                $product_name = Product::getProductName($product_id, null, $id_lang);
                $combination_attributes = '';

                // Si c'est une déclinaison, récupérer les noms des attributs
                if ($id_product_attribute > 0) {
                    $attributes = Db::getInstance()->executeS('
                        SELECT
                            al.name AS attribute_name
                        FROM ' . _DB_PREFIX_ . 'product_attribute_combination pac
                        LEFT JOIN ' . _DB_PREFIX_ . 'attribute a ON a.id_attribute = pac.id_attribute
                        LEFT JOIN ' . _DB_PREFIX_ . 'attribute_lang al ON al.id_attribute = a.id_attribute
                        WHERE pac.id_product_attribute = ' . $id_product_attribute . '
                        AND al.id_lang = ' . $id_lang
                    );

                    if (!empty($attributes)) {
                        $attribute_list = [];
                        foreach ($attributes as $attribute) {
                            $attribute_list[] = $attribute['attribute_name'];
                        }
                        // Concaténer les attributs (ex: "Rouge Taille Unique")
                        $combination_attributes = implode(' ', $attribute_list);
                    }
                }

                // Construire le titre complet du produit
                $full_product_title = $product_name . ($combination_attributes ? ' ' . $combination_attributes : '');

                // Construire le message à envoyer au chat
                $message_content = 'J\'ai ajouté au panier : ' . $full_product_title;

                // Envoyer le message au chat. L'id_customer doit être 999999 (admin) pour que ce soit un message du live.
                $this->myls_sendChatMessage(
                    $message_content,
                    $customer_id // id_customer doit être 999999
                );
            }
            // --- FIN LOGIQUE D'ENVOI DU MESSAGE AU CHAT ---

            header('Content-Type: application/json; charset=utf-8');
            die(json_encode($result));
        }
    }
}