<?php
require_once dirname(__FILE__) . '/../../config/config.inc.php';
require_once dirname(__FILE__) . '/../../init.php';

$context = Context::getContext();

// Vérifier que c'est un employé connecté
if (!$context->employee->isLogged()) {
    die('Accès refusé');
}

// Récupérer tous les messages
$sql = 'SELECT m.*, 
        CASE 
            WHEN m.id_employee > 0 THEN CONCAT(\'Admin \', e.firstname, \' \', e.lastname)
            WHEN c.firstname IS NOT NULL THEN CONCAT(c.firstname, \' \', c.lastname)
            ELSE \'Guest\'
        END as full_name,
        CASE 
            WHEN m.id_employee > 0 THEN \'ADMIN\'
            ELSE CONCAT(\'#\', LPAD(m.id_customer, 4, \'0\'))
        END as user_id
        FROM `' . _DB_PREFIX_ . 'minichat_messages` m
        LEFT JOIN `' . _DB_PREFIX_ . 'customer` c ON m.id_customer = c.id_customer
        LEFT JOIN `' . _DB_PREFIX_ . 'employee` e ON m.id_employee = e.id_employee
        WHERE m.is_deleted = 0
        ORDER BY m.date_add ASC';

$messages = Db::getInstance()->executeS($sql);

// Créer le contenu du fichier
$content = "=================================\n";
$content .= "LIVE SHOPPING CHAT EXPORT - " . date('Y-m-d H:i:s') . "\n";
$content .= "Total Messages: " . count($messages) . "\n";
$content .= "=================================\n\n";

$currentDate = '';
foreach ($messages as $msg) {
    $msgDate = date('Y-m-d', strtotime($msg['date_add']));
    
    // Ajouter un séparateur de date si nouveau jour
    if ($msgDate != $currentDate) {
        $currentDate = $msgDate;
        $content .= "\n--- " . date('l, F j, Y', strtotime($msg['date_add'])) . " ---\n\n";
    }
    
    // Format: [HH:MM] Nom (ID): Message
    $content .= "[" . date('H:i', strtotime($msg['date_add'])) . "] ";
    $content .= $msg['full_name'] . " (" . $msg['user_id'] . "): ";
    $content .= $msg['message'] . "\n";
}

$content .= "\n=================================\n";
$content .= "FIN DE L'EXPORT\n";
$content .= "=================================\n";

// Envoyer le fichier
header('Content-Type: text/plain; charset=utf-8');
header('Content-Disposition: attachment; filename="live_chat_export_' . date('Y-m-d_His') . '.txt"');
header('Content-Length: ' . strlen($content));
echo $content;
exit;