<?php

class MyLiveShoppingModuleDisplayModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();
        header('Content-Type: text/html; charset=UTF-8');
        header('Cache-Control: no-cache, must-revalidate');
        header('Pragma: no-cache');

        $live_product = null;
        $is_enabled_for_display = false;
        $message = '';
        
        // Récupération des configurations
        $bg_color = Configuration::get('myliveshoppingmodule_BG_COLOR');
        $border_color = Configuration::get('myliveshoppingmodule_BORDER_COLOR');
        $text_color = Configuration::get('myliveshoppingmodule_TEXT_COLOR');
        $live_rich_text = Configuration::get('myliveshoppingmodule_RICH_TEXT', $this->context->language->id);
        $live_rich_text_2 = Configuration::get('myliveshoppingmodule_RICH_TEXT_2', $this->context->language->id);
        $max_qty = (int)Configuration::get('myliveshoppingmodule_MAX_QTY', 3);
        
        // 🎥 CONFIGURATION WEBCAM
        $webcam_enabled = (int)Configuration::get('myliveshoppingmodule_WEBCAM_ACTIVE', 0);
        $webcam_format = Configuration::get('myliveshoppingmodule_WEBCAM_FORMAT', 'landscape');

        // ✅ GÉNÉRATION TOKEN ET URL
        $csrf_token = Tools::getToken(false);
        $ajax_viewers_url = $this->module->getPathUri() . 'ajax_viewers.php';
        $ajax_cart_url = $this->context->link->getPageLink('cart', null, $this->context->language->id, ['ajax' => 1]);
        
        // Détection de la connexion
        $is_logged = (isset($this->context->customer) && $this->context->customer->isLogged()) ||
                     (isset($this->context->employee) && $this->context->employee->isLogged());
        
        $is_module_enabled = (int)Configuration::get('myliveshoppingmodule_ENABLED');
        
        // Logique de statut
        if (!$is_module_enabled) {
            $message = 'Live shopping actuellement désactivé.';
            $is_enabled_for_display = false;
        } elseif (!$is_logged) {
            $message = 'Veuillez vous connecter pour suivre le live.';
            $is_enabled_for_display = false;
        } else {
            $id_product = (int)Configuration::get('myliveshoppingmodule_ID');

            if (!$id_product) {
                $message = 'Le live shopping est temporairement indisponible.';
                $is_enabled_for_display = true;
            } else {
                $product = new Product($id_product, false, $this->context->language->id);
                if (Validate::isLoadedObject($product) && $product->active) {
                    $live_product = $product;
                    $is_enabled_for_display = true;
                } else {
                    $message = 'Le produit Live est introuvable, désactivé ou n\'existe plus.';
                    $is_enabled_for_display = true;
                }
            }
        }
        
        // Assignation finale à Smarty
        $this->context->smarty->assign([
            'module_dir' => $this->module->getPathUri(),
            'displayName' => $this->module->displayName,
            'live_rich_text' => $live_rich_text,
            'live_rich_text_2' => $live_rich_text_2,
            'custom_bg_color' => !empty($bg_color) ? $bg_color : '#f08ec4',
            'custom_border_color' => !empty($border_color) ? $border_color : '#ff006a',
            'custom_text_color' => !empty($text_color) ? $text_color : '#333333',
            'live_product' => $live_product,
            'is_enabled' => $is_enabled_for_display,
            'message' => $message,
            'max_qty_live' => $max_qty,
            'logged' => $is_logged,
            'myls_csrf_token' => $csrf_token,
            'ajax_viewers_url' => $ajax_viewers_url,
            'ajax_cart_url' => $ajax_cart_url,
            'webcam_enabled' => $webcam_enabled,
            'webcam_format' => $webcam_format,
        ]);
        
        $this->setTemplate('module:myliveshoppingmodule/views/templates/front/myliveshoppingmodule.tpl');
    }

    public function getPageTitle()
    {
        return $this->module->l('Live Shopping', 'display');
    }

    public function setMedia()
    {
        parent::setMedia();
        $this->context->smarty->assign('meta_viewport', 'width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no');
    }
}