<?php
require_once dirname(__FILE__) . '/../../config/config.inc.php';
require_once dirname(__FILE__) . '/../../init.php';

header('Content-Type: application/json; charset=utf-8');

$context = Context::getContext();
$action = Tools::getValue('action');

// HEARTBEAT : Enregistrer la présence
if ($action === 'heartbeat') {
    // Vérifier que le client est connecté
    if (!$context->customer->isLogged()) {
        echo json_encode(['success' => false, 'error' => 'Not logged']);
        exit;
    }
    
    $customer_id = (int)$context->customer->id;
    $session_id = session_id();
    
    // Nettoyer les vieux
    Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'live_viewers` WHERE last_seen < DATE_SUB(NOW(), INTERVAL 30 SECOND)');
    
    // Vérifier si existe déjà
    $exists = Db::getInstance()->getValue('SELECT id_viewer FROM `'._DB_PREFIX_.'live_viewers` WHERE id_customer = '.(int)$customer_id);
    
    if ($exists) {
        // Mise à jour
        Db::getInstance()->execute('UPDATE `'._DB_PREFIX_.'live_viewers` SET last_seen = NOW() WHERE id_customer = '.(int)$customer_id);
    } else {
        // Insertion
        Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.'live_viewers` (session_id, id_customer, last_seen) VALUES ("'.pSQL($session_id).'", '.(int)$customer_id.', NOW())');
    }
    
    echo json_encode(['success' => true, 'customer_id' => $customer_id]);
    exit;
}

// GET VIEWERS : Compter
if ($action === 'getViewers') {
    $count = (int)Db::getInstance()->getValue('SELECT COUNT(*) FROM `'._DB_PREFIX_.'live_viewers` WHERE last_seen > DATE_SUB(NOW(), INTERVAL 30 SECOND) AND id_customer > 0 AND id_customer != 999999');
    
    echo json_encode(['success' => true, 'logged' => $count]);
    exit;
}

echo json_encode(['error' => 'Invalid action']);