<?php
/**
 * Système de streaming WebM avec son pour diffuser la webcam admin
 * Compatible tous navigateurs modernes
 */

require_once(dirname(__FILE__).'/../../config/config.inc.php');

// Headers CORS et cache
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');

if (!Module::isInstalled('myliveshoppingmodule')) {
    header('Content-Type: application/json');
    die(json_encode(['success' => false, 'error' => 'Module non installé']));
}

$action = Tools::getValue('action');
$stream_dir = _PS_MODULE_DIR_ . 'myliveshoppingmodule/stream/';

// Créer le dossier si nécessaire
if (!file_exists($stream_dir)) {
    mkdir($stream_dir, 0755, true);
}

switch ($action) {
    
    case 'getStreamStatus':
        header('Content-Type: application/json');
        $webcam_active = (int)Configuration::get('myliveshoppingmodule_WEBCAM_ACTIVE', 0);
        $webcam_format = Configuration::get('myliveshoppingmodule_WEBCAM_FORMAT', 'landscape');
        $last_chunk = (int)Configuration::get('myliveshoppingmodule_LAST_CHUNK', 0);
        $stream_active = (time() - $last_chunk) < 5;
        
        echo json_encode([
            'success' => true,
            'webcam_active' => $webcam_active,
            'webcam_format' => $webcam_format,
            'stream_active' => $stream_active
        ]);
        break;
        
    case 'startStream':
        header('Content-Type: application/json');
        $employee = Context::getContext()->employee;
        if (!$employee || !$employee->id) {
            die(json_encode(['success' => false, 'error' => 'Non autorisé']));
        }
        
        // Nettoyer les anciens chunks
        $files = glob($stream_dir . 'chunk_*.webm');
        foreach ($files as $file) {
            @unlink($file);
        }
        
        $stream_id = 'stream_' . time();
        Configuration::updateValue('myliveshoppingmodule_STREAM_ID', $stream_id);
        Configuration::updateValue('myliveshoppingmodule_CHUNK_INDEX', 0);
        Configuration::updateValue('myliveshoppingmodule_LAST_CHUNK', time());
        
        echo json_encode([
            'success' => true,
            'stream_id' => $stream_id,
            'message' => 'Stream démarré'
        ]);
        break;
        
    case 'stopStream':
        header('Content-Type: application/json');
        $employee = Context::getContext()->employee;
        if (!$employee || !$employee->id) {
            die(json_encode(['success' => false, 'error' => 'Non autorisé']));
        }
        
        // Nettoyer les chunks
        $files = glob($stream_dir . 'chunk_*.webm');
        foreach ($files as $file) {
            @unlink($file);
        }
        
        Configuration::deleteByName('myliveshoppingmodule_STREAM_ID');
        Configuration::updateValue('myliveshoppingmodule_CHUNK_INDEX', 0);
        Configuration::updateValue('myliveshoppingmodule_LAST_CHUNK', 0);
        
        echo json_encode(['success' => true, 'message' => 'Stream arrêté']);
        break;
        
    case 'uploadChunk':
        header('Content-Type: application/json');
        $employee = Context::getContext()->employee;
        if (!$employee || !$employee->id) {
            die(json_encode(['success' => false, 'error' => 'Non autorisé']));
        }
        
        if (!isset($_FILES['chunk']) || $_FILES['chunk']['error'] !== UPLOAD_ERR_OK) {
            die(json_encode(['success' => false, 'error' => 'Aucun chunk reçu']));
        }
        
        $chunk_index = (int)Configuration::get('myliveshoppingmodule_CHUNK_INDEX', 0);
        $new_index = ($chunk_index + 1) % 10; // Garder 10 chunks max (buffer circulaire)
        
        $chunk_file = $stream_dir . 'chunk_' . $new_index . '.webm';
        
        if (move_uploaded_file($_FILES['chunk']['tmp_name'], $chunk_file)) {
            Configuration::updateValue('myliveshoppingmodule_CHUNK_INDEX', $new_index);
            Configuration::updateValue('myliveshoppingmodule_LAST_CHUNK', time());
            
            echo json_encode([
                'success' => true,
                'chunk_index' => $new_index,
                'timestamp' => time()
            ]);
        } else {
            echo json_encode(['success' => false, 'error' => 'Erreur écriture']);
        }
        break;
        
    case 'getChunkInfo':
        header('Content-Type: application/json');
        $webcam_active = (int)Configuration::get('myliveshoppingmodule_WEBCAM_ACTIVE', 0);
        
        if (!$webcam_active) {
            die(json_encode(['success' => false, 'error' => 'Stream inactif', 'active' => false]));
        }
        
        $last_chunk = (int)Configuration::get('myliveshoppingmodule_LAST_CHUNK', 0);
        $age = time() - $last_chunk;
        
        if ($age > 5) {
            die(json_encode(['success' => false, 'error' => 'Stream périmé', 'active' => false]));
        }
        
        $chunk_index = (int)Configuration::get('myliveshoppingmodule_CHUNK_INDEX', 0);
        
        echo json_encode([
            'success' => true,
            'active' => true,
            'chunk_index' => $chunk_index,
            'timestamp' => $last_chunk
        ]);
        break;
        
    case 'getChunk':
        $index = (int)Tools::getValue('index', -1);
        $chunk_file = $stream_dir . 'chunk_' . $index . '.webm';
        
        if ($index < 0 || !file_exists($chunk_file)) {
            header('HTTP/1.1 404 Not Found');
            exit;
        }
        
        $filesize = filesize($chunk_file);
        header('Content-Type: video/webm');
        header('Content-Length: ' . $filesize);
        header('Accept-Ranges: bytes');
        
        readfile($chunk_file);
        exit;
        break;
        
    // Compatibilité avec l'ancien système (fallback images)
    case 'getStreamFrame':
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'error' => 'Utilisez getChunkInfo/getChunk']);
        break;
        
    default:
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'error' => 'Action inconnue: ' . $action]);
}