<?php
require_once dirname(__FILE__) . '/../../config/config.inc.php';
require_once dirname(__FILE__) . '/../../init.php';

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-cache, no-store, must-revalidate');

$context = Context::getContext();

// Vérification de l'authentification de l'employé
if (!$context->employee->isLogged()) {
    http_response_code(403);
    echo json_encode(['error' => 'Accès refusé.']);
    exit;
}

$customer_id = (int)Tools::getValue('id');
$check_cart = (int)Tools::getValue('check_cart', 0);

if (!$customer_id) {
    echo json_encode(['error' => 'ID client manquant.']);
    exit;
}

// Vérification du token pour les actions sensibles
if (Tools::getValue('action') && in_array(Tools::getValue('action'), ['sendMessage', 'sendAdminMessage', 'deleteMessage'])) {
    $token = Tools::getValue('token');
    if (!$token || $token !== Tools::getToken(false)) {
        http_response_code(403);
        echo json_encode(['error' => 'Token CSRF invalide']);
        exit;
    }
}

// Charger le client
$customer = new Customer($customer_id);
if (!Validate::isLoadedObject($customer)) {
    echo json_encode(['error' => 'Client introuvable.']);
    exit;
}

// Préparer les données du client
$customer_data = [
    'id' => (int)$customer->id,
    'firstname' => Tools::htmlentitiesUTF8($customer->firstname),
    'lastname' => Tools::htmlentitiesUTF8($customer->lastname),
    'email' => Tools::htmlentitiesUTF8($customer->email),
    'active' => (bool)$customer->active,
    'date_add' => Tools::displayDate($customer->date_add, null, true),
    'date_upd' => Tools::displayDate($customer->date_upd, null, true)
];

// Compter les commandes du client
$sql = 'SELECT COUNT(*) FROM ' . _DB_PREFIX_ . 'orders 
        WHERE id_customer = ' . (int)$customer_id . ' 
        AND valid = 1';
$customer_data['orders_count'] = (int)Db::getInstance()->getValue($sql);

// Récupérer le panier actuel du client
$sql = 'SELECT c.id_cart 
        FROM ' . _DB_PREFIX_ . 'cart c
        LEFT JOIN ' . _DB_PREFIX_ . 'orders o ON c.id_cart = o.id_cart
        WHERE c.id_customer = ' . (int)$customer_id . '
        AND o.id_order IS NULL
        AND c.id_shop = ' . (int)$context->shop->id . '
        ORDER BY c.date_add DESC
        LIMIT 1';

$cart_id = Db::getInstance()->getValue($sql);

$customer_data['current_cart'] = [
    'id' => 0,
    'products_count' => 0,
    'total' => '0,00 €',
    'products' => []
];

if ($cart_id) {
    $cart = new Cart($cart_id);
    if (Validate::isLoadedObject($cart)) {
        $products = $cart->getProducts();
        $products_count = 0;
        $products_list = [];
        
        foreach ($products as $product) {
            $products_count += (int)$product['cart_quantity'];
            $products_list[] = [
                'id' => $product['id_product'],
                'id_product_attribute' => $product['id_product_attribute'],
                'name' => $product['name'],
                'attributes' => $product['attributes_small'],
                'quantity' => (int)$product['cart_quantity'],
                'price' => Tools::displayPrice($product['price_wt'])
            ];
        }
        
        $customer_data['current_cart'] = [
            'id' => $cart->id,
            'products_count' => $products_count,
            'total' => Tools::displayPrice($cart->getOrderTotal(true, Cart::BOTH)),
            'products' => $products_list
        ];
    }
}

// Si on demande spécifiquement de vérifier le panier (après ajout)
if ($check_cart && $cart_id) {
    // Récupérer plus de détails sur le panier pour vérification
    $live_product_id = (int)Configuration::get('myliveshoppingmodule_ID');
    
    if ($live_product_id) {
        foreach ($customer_data['current_cart']['products'] as &$product) {
            if ($product['id'] == $live_product_id) {
                $product['is_live_product'] = true;
                $product['name'] = '⭐ ' . $product['name'] . ' (PRODUIT LIVE)';
            }
        }
    }
}

// Ajouter des informations supplémentaires si disponibles
try {
    // Dernière connexion
    $sql = 'SELECT date_add FROM ' . _DB_PREFIX_ . 'connections 
            WHERE id_customer = ' . (int)$customer_id . ' 
            ORDER BY date_add DESC LIMIT 1';
    $last_connection = Db::getInstance()->getValue($sql);
    if ($last_connection) {
        $customer_data['last_connection'] = Tools::displayDate($last_connection, null, true);
    }
    
    // Groupe client
    $group = new Group($customer->id_default_group, $context->language->id);
    if (Validate::isLoadedObject($group)) {
        $customer_data['group'] = $group->name;
    }
    
} catch (Exception $e) {
    // Ignorer les erreurs pour les infos supplémentaires
}

echo json_encode($customer_data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);