{extends file='layouts/layout.tpl'}{block name='content'}
<div class="panel">
  <div class="panel-heading"><h3>myDropBridges - Simple</h3></div>
  <div class="panel-body">
    {if $confirmations}<div class="alert alert-success">{foreach from=$confirmations item=c}{$c}<br/>{/foreach}</div>{/if}
    <form method="post">
      <div class="form-group">
        <label>Nom de l'entreprise</label>
        <input class="form-control" type="text" name="company_name" value="{$company_name|escape:'html'}" />
      </div>
      <div class="form-group">
        <label>API Key</label>
        <input class="form-control" type="text" name="api_key" value="{$api_key|escape:'html'}" />
      </div>
      <h4>Fournisseurs</h4>
      <table class="table">
        <thead><tr><th>ID</th><th>Nom</th><th>Activé</th></tr></thead>
        <tbody>
          {foreach from=$suppliers item=s}
            <tr>
              <td>{$s.id_supplier_ext}</td>
              <td>{$s.name}</td>
              <td><input type="checkbox" name="supplier_enabled_{$s.id_supplier_ext}" value="1" {if $s.enabled}checked{/if} /></td>
            </tr>
          {/foreach}
        </tbody>
      </table>
      <button class="btn btn-primary" type="submit" name="submitMyDropBridgesConfig">Enregistrer</button>
    </form>

    <hr/>

    <h4>Catalogue</h4>
    <ul class="nav nav-tabs">
      {foreach from=$suppliers item=s}
        <li class="{if $s.id_supplier_ext == $selected}active{/if}"><a href="{$link->getAdminLink('AdminMyDropBridges')}&supplier={$s.id_supplier_ext}">{$s.name}</a></li>
      {/foreach}
    </ul>

    <div style="margin-top:15px;">
      {if $products}
        <table class="table table-hover">
          <thead><tr><th>Image</th><th>Nom</th><th>SKU</th><th>Prix</th><th>Variantes</th><th>Action</th></tr></thead>
          <tbody>
            {foreach from=$products item=p}
              <tr>
                <td><img src="{$p.image}" style="max-width:80px" /></td>
                <td>{$p.title}</td>
                <td>{$p.sku}</td>
                <td>{$p.price}</td>
                <td>{foreach from=$p.variants item=v}{$v.sku}&nbsp;{/foreach}</td>
                <td><button class="btn btn-success js-import" data-sku="{$p.sku}" data-name="{$p.title}" data-price="{$p.price}">Importer</button></td>
              </tr>
            {/foreach}
          </tbody>
        </table>
      {else}
        <div class="alert alert-info">Sélectionnez l'onglet Test pour voir la liste de produits fictifs.</div>
      {/if}
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function(){
  document.querySelectorAll('.js-import').forEach(function(btn){
    btn.addEventListener('click', function(e){
      e.preventDefault();
      var sku = this.getAttribute('data-sku');
      var name = this.getAttribute('data-name');
      var price = this.getAttribute('data-price');
      fetch('index.php?controller=AdminMyDropBridges&ajax=1&action=importProduct', {
        method: 'POST',
        headers: {'Content-Type':'application/x-www-form-urlencoded'},
        body: 'sku='+encodeURIComponent(sku)+'&name='+encodeURIComponent(name)+'&price='+encodeURIComponent(price)
      }).then(function(r){ return r.json(); }).then(function(json){
        if (json.success) {
          alert(json.message);
        } else {
          alert('Erreur lors de l\'import');
        }
      }).catch(function(){ alert('Erreur réseau'); });
    });
  });
});
</script>
{/block}