<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

class MyDropBridges extends Module
{
    public function __construct()
    {
        $this->name = 'mydropbridges';
        $this->tab = 'administration';
        $this->version = '1.0.0';
        $this->author = 'SplineOnline';
        $this->need_instance = 0;
        $this->bootstrap = true; // Important pour Bootstrap

        $this->ps_versions_compliancy = [
            'min' => '1.7.0.0',
            'max' => _PS_VERSION_
        ];

        parent::__construct();

        $this->displayName = $this->l('MyDropBridges');
        $this->description = $this->l('Module de gestion de dropshipping avec 5 fournisseurs et un onglet test.');
    }

    public function install()
    {
        return parent::install()
            && $this->installDB()
            && $this->installTab()
            && $this->registerHook('displayBackOfficeHeader');
    }

    public function uninstall()
    {
        return parent::uninstall()
            && $this->uninstallDB()
            && $this->uninstallTab()
            && Configuration::deleteByName('MYDROPBRIDGES_API_KEY');
    }

    private function installDB()
    {
        $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'mydropbridges_imports` (
            `id_import` INT UNSIGNED NOT NULL AUTO_INCREMENT,
            `supplier` VARCHAR(50) NOT NULL,
            `product_name` VARCHAR(255) NOT NULL,
            PRIMARY KEY (`id_import`)
        ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;';
        return Db::getInstance()->execute($sql);
    }

    private function uninstallDB()
    {
        return Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'mydropbridges_imports`');
    }

    private function installTab()
    {
        $tab = new Tab();
        $tab->active = 1;
        $tab->class_name = 'AdminMyDropBridges';
        $tab->name = array_fill_keys(Language::getIDs(false), 'MyDropBridges');
        $tab->id_parent = (int) Tab::getIdFromClassName('IMPROVE'); // Catégorie Back Office
        $tab->module = $this->name;
        return $tab->add();
    }

    private function uninstallTab()
    {
        $id_tab = (int) Tab::getIdFromClassName('AdminMyDropBridges');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            return $tab->delete();
        }
        return true;
    }

    public function getContent()
    {
        $output = '';
        if (Tools::isSubmit('submit'.$this->name)) {
            Configuration::updateValue('MYDROPBRIDGES_API_KEY', Tools::getValue('MYDROPBRIDGES_API_KEY'));
            $output .= $this->displayConfirmation($this->l('Configuration mise à jour'));
        }

        return $output.$this->renderForm().$this->renderTabs();
    }

    protected function renderForm()
    {
        $default_lang = (int) Configuration::get('PS_LANG_DEFAULT');

        $fields_form[0]['form'] = [
            'legend' => [
                'title' => $this->l('Configuration'),
            ],
            'input' => [
                [
                    'type' => 'text',
                    'label' => $this->l('Clé API'),
                    'name' => 'MYDROPBRIDGES_API_KEY',
                    'size' => 50,
                    'required' => true
                ]
            ],
            'submit' => [
                'title' => $this->l('Sauvegarder')
            ]
        ];

        $helper = new HelperForm();
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        $helper->default_form_language = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;
        $helper->title = $this->displayName;
        $helper->show_toolbar = false;
        $helper->submit_action = 'submit'.$this->name;
        $helper->fields_value['MYDROPBRIDGES_API_KEY'] = Configuration::get('MYDROPBRIDGES_API_KEY');

        return $helper->generateForm($fields_form);
    }

    protected function renderTabs()
    {
        $tabs = [
            'AliExpress (Chine)',
            'Banggood (Chine)',
            'Spocket (États-Unis)',
            'BigBuy (Espagne)',
            'SaleHoo (Royaume-Uni)',
            'Test'
        ];

        $html = '<h2>'.$this->l('Fournisseurs').'</h2>';
        $html .= '<ul class="nav nav-tabs">';

        foreach ($tabs as $index => $tab) {
            $active = ($index === 0) ? 'active' : '';
            $html .= '<li class="'.$active.'"><a data-toggle="tab" href="#tab'.$index.'">'.$tab.'</a></li>';
        }

        $html .= '</ul><div class="tab-content">';

        foreach ($tabs as $index => $tab) {
            $active = ($index === 0) ? 'active in' : '';
            $html .= '<div id="tab'.$index.'" class="tab-pane fade '.$active.'">';
            
            if ($tab === 'Test') {
                $html .= '<h3>'.$this->l('Produits fictifs').'</h3>';
                $products = [
                    ['name' => 'Produit Test 1'],
                    ['name' => 'Produit Test 2'],
                    ['name' => 'Produit Test 3']
                ];
                foreach ($products as $p) {
                    $html .= '<p>'.$p['name'].' 
                    <button class="btn btn-success">'.$this->l('Importer').'</button></p>';
                }
            } else {
                $html .= '<p>'.$this->l('Gestion du fournisseur').' : '.$tab.'</p>';
            }
            $html .= '</div>';
        }

        $html .= '</div>';

        return $html;
    }
}
