<?php
class AdminMyDropBridgesController extends ModuleAdminController
{
    public function __construct()
    {
        $this->bootstrap = true;
        parent::__construct();
    }

    private function getSuppliersSeed()
    {
        return [
            ['id'=>1,'code'=>'aliexpress','name'=>'AliExpress'],
            ['id'=>2,'code'=>'alibaba','name'=>'Alibaba'],
            ['id'=>3,'code'=>'amazon','name'=>'Amazon'],
            ['id'=>4,'code'=>'ebay','name'=>'eBay'],
            ['id'=>5,'code'=>'cdiscount','name'=>'CDiscount'],
            ['id'=>6,'code'=>'test','name'=>'Test (Produits fictifs)'],
        ];
    }

    public function initContent()
    {
        parent::initContent();
        $module = Module::getInstanceByName('mydropbridges');

        // Handle config save
        if (Tools::isSubmit('submitMyDropBridgesConfig')) {
            Configuration::updateValue('MDB_COMPANY_NAME', Tools::getValue('company_name'));
            Configuration::updateValue('MDB_API_KEY', Tools::getValue('api_key'));
            foreach ($this->getSuppliersSeed() as $s) {
                $key = 'supplier_enabled_'.$s['id'];
                $val = Tools::getValue($key, 0);
                Db::getInstance()->update('mydb_supplier', ['enabled' => (int)$val], 'id_supplier_ext='.(int)$s['id']);
            }
            $this->confirmations[] = $this->l('Configuration enregistrée.');
        }

        // Seed suppliers if not present
        $existing = Db::getInstance()->executeS('SELECT id_supplier_ext FROM '._DB_PREFIX_.'mydb_supplier');
        if (empty($existing)) {
            foreach ($this->getSuppliersSeed() as $s) {
                Db::getInstance()->insert('mydb_supplier', [
                    'id_supplier_ext' => (int)$s['id'],
                    'name' => pSQL($s['name']),
                    'api_endpoint' => '',
                    'meta' => pSQL(json_encode(new stdClass())),
                    'enabled' => 1
                ]);
            }
        }

        $suppliers = Db::getInstance()->executeS('SELECT * FROM '._DB_PREFIX_.'mydb_supplier ORDER BY id_supplier_ext ASC');
        $selected = (int)Tools::getValue('supplier', 6);
        $products = [];

        if ($selected === 6) {
            $file = dirname(__FILE__).'/../../data/fake_products.json';
            if (file_exists($file)) {
                $products = json_decode(file_get_contents($file), true);
            }
        }

        $this->context->smarty->assign([
            'module_dir' => $module->getPathUri(),
            'suppliers' => $suppliers,
            'selected' => $selected,
            'products' => $products,
            'company_name' => Configuration::get('MDB_COMPANY_NAME',''),
            'api_key' => Configuration::get('MDB_API_KEY','')
        ]);

        $this->setTemplate('module:mydropbridges/views/templates/admin/dashboard.tpl');
    }

    public function ajaxProcessImportProduct()
    {
        $sku = pSQL(Tools::getValue('sku'));
        $name = pSQL(Tools::getValue('name'));
        $price = (float)Tools::getValue('price', 0);

        Db::getInstance()->insert('mydb_import_queue', [
            'product_id' => 0,
            'supplier_id' => 6,
            'status' => 'imported',
            'created_at' => date('Y-m-d H:i:s'),
            'processed_at' => date('Y-m-d H:i:s'),
            'payload' => pSQL(json_encode(['sku'=>$sku,'name'=>$name,'price'=>$price]))
        ]);

        die(json_encode(['success'=>true,'message'=>'Produit importé (simulation)','sku'=>$sku]));
    }
}
