{* Fichier: mycart/views/templates/hook/cart_recoverable_products.tpl *}

<div class="alert alert-info" id="mycart-recoverable-products">
    <h4 class="alert-heading">{l s='Articles enregistrés' mod='mycart'}</h4>
    <p>{l s='Nous avons trouvé des articles dans d\'anciens paniers (datant de moins de 7 jours) sur votre compte. Ajoutez-les en un clic à votre panier actuel.' mod='mycart'}</p>

    <div class="recoverable-products-list">
        {foreach from=$mycart_products_to_merge item=product}
            <div class="product-line-grid mycart-product-line-grid">
                <div class="product-line-grid-left col-md-3 col-xs-4">
                    <span class="product-image media-middle">
                        <img src="{$product.image_link}" alt="{$product.name}" class="img-fluid">
                    </span>
                </div>
                <div class="product-line-grid-body col-md-9 col-xs-8">
                    <div class="product-line-info">
                        <a class="label" href="{$product.url}" data-id_customization="0">
                            {$product.name}
                        </a>
                        <span class="pull-xs-right">{$product.price}</span>
                    </div>
                    {if isset($product.attributes_small) && $product.attributes_small != ''}
                        <div class="product-line-info product-line-info-secondary text-muted">
                            <span class="value">{$product.attributes_small}</span>
                        </div>
                    {/if}
                    <div class="product-line-info product-line-info-secondary text-muted">
                        <div class="row">
                            <div class="col-xs-6">
                                <span class="label">{l s='Quantité' mod='mycart'}</span>
                                <span class="value">{$product.quantity}</span>
                            </div>
                            <div class="col-xs-6">
                                {if $product.stock_quantity > 0}
                                    <span class="text-success">{l s='En stock' mod='mycart'}</span>
                                {else}
                                    <span class="text-danger">{l s='Rupture de stock' mod='mycart'}</span>
                                {/if}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        {/foreach}
    </div>

    <hr class="my-3">
    <a href="{$mycart_link->getModuleLink('mycart', 'cart')}" class="btn btn-primary btn-lg btn-block">
    {l s='Ajouter tous ces articles à mon panier' mod='mycart'}
</a>

</div>

<style>
#mycart-recoverable-products .product-line-grid {
    border-bottom: 1px solid #ccc;
    padding-bottom: 10px;
    margin-bottom: 10px;
}
</style>