<?php
/**
 * 2025 SplineOnline
 * Contrôleur de module pour la fusion de paniers
 */

class MycartCartModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();

        $context = Context::getContext();
        $id_customer = (int)$context->customer->id;
        $id_cart = (int)$context->cart->id;

        // Vérifier si le client est connecté
        if (!$id_customer) {
            Tools::redirect('index.php?controller=authentication&back=my-account');
        }

        // Appeler la méthode de fusion du module principal
        $this->module->mergeAllOpenCarts($id_customer, $id_cart);

        // Rediriger vers la page du panier après la fusion
        Tools::redirect($context->link->getPageLink('cart', true));
    }
}