<style>
.mybridges-header {
    background: linear-gradient(135deg, #f3bbe5ff 0%, #f0facbff 100%);
    color: #333;                /* Texte général en noir foncé */
    padding: 30px;
    border-radius: 10px;
    margin-bottom: 30px;
    text-align: center;
    border: none;
}

.mybridges-logo {
    width: 80px;
    height: 80px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    margin: 0 auto 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 40px;
}

.mybridges-header h1 {
    margin: 0 0 10px 0;
    font-size: 28px;
    color: #333;                /* Titre "My Bridges" en noir foncé */
}

.mybridges-header p {
    margin: 5px 0;
    opacity: 0.9;
    color: #666;                /* Descriptions en gris foncé */
}

.platform-panel {
    border: 1px solid #ddd;
    border-radius: 10px;
    margin-bottom: 25px;
    overflow: hidden;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    transition: transform 0.3s ease;
}

.platform-panel:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 20px rgba(0,0,0,0.15);
}

.platform-header {
    padding: 20px;
    color: white;
    display: flex;
    align-items: center;
    font-size: 18px;
    font-weight: bold;
}

.platform-header.amazon { background-color: #f0c88dff; }
.platform-header.ebay { background-color: #93c59eff; }
.platform-header.metashop { background-color: #67a3f1ff; }
.platform-header.tiktok { background-color: #ffaec8ff; }

.platform-logo {
    width: 40px;
    height: 40px;
    background: rgba(255,255,255,0.2);
    border-radius: 8px;
    margin-right: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
}

.platform-body {
    padding: 25px;
    background: #fff;
}

.connection-status {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 8px 15px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
    margin-bottom: 20px;
}

.status-connected { 
    background: #d4edda; 
    color: #155724; 
}

.status-disconnected { 
    background: #f8d7da; 
    color: #721c24; 
}

.status-dot {
    width: 8px;
    height: 8px;
    border-radius: 50%;
}

.dot-connected { background: #28a745; }
.dot-disconnected { background: #dc3545; }

.form-row {
    display: flex;
    gap: 15px;
    margin-bottom: 15px;
}

.form-group {
    flex: 1;
}

.form-group label {
    display: block;
    margin-bottom: 5px;
    font-weight: 500;
    color: #333;
}

.form-control {
    width: 100%;
    padding: 10px 15px;
    border: 1px solid #ddd;
    border-radius: 5px;
    font-size: 14px;
    box-sizing: border-box;
}

.form-control:focus {
    outline: none;
    border-color: #007cff;
    box-shadow: 0 0 0 2px rgba(0,124,255,0.1);
}

.btn-actions {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
    margin-top: 20px;
}

.btn {
    padding: 10px 20px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.btn:hover {
    transform: translateY(-1px);
}

.btn-primary { 
    background: #007cff; 
    color: white; 
}
.btn-primary:hover { 
    background: #0056cc; 
}

.btn-success { 
    background: #28a745; 
    color: white; 
}
.btn-success:hover { 
    background: #1e7e34; 
}

.btn-info { 
    background: #17a2b8; 
    color: white; 
}
.btn-info:hover { 
    background: #117a8b; 
}

.btn-warning { 
    background: #ffc107; 
    color: #212529; 
}
.btn-warning:hover { 
    background: #e0a800; 
}

@media (max-width: 768px) {
    .form-row {
        flex-direction: column;
    }
    
    .btn-actions {
        justify-content: center;
    }
    
    .mybridges-header {
        padding: 20px;
    }
    
    .platform-body {
        padding: 15px;
    }
}
</style>

<!-- En-tête du module -->
<div class="panel mybridges-header">
    <img src="../modules/mybridges/logo.png" alt="Logo My Bridges" class="mybridges-logo" style="max-width:120px; margin-bottom:15px;">
    <h1>My Bridges</h1>
    <p>Connexion bilatérale avec vos plateformes marketplace</p>
    <p><small>Exportez vos produits, importez vos commandes et synchronisez vos stocks en temps réel</small></p>
</div>

<!-- Amazon -->
<div class="panel platform-panel">
    <div class="platform-header amazon">
        <div class="platform-logo">📦</div>
        <span>Amazon</span>
    </div>
    
    <div class="platform-body">
        <div class="connection-status status-disconnected">
            <span class="status-dot dot-disconnected"></span>
            Déconnecté
        </div>
        
        <form method="post" action="">
            <input type="hidden" name="platform" value="amazon" />
            <div class="form-row">
                <div class="form-group">
                    <label for="amazon_client_id">Client ID</label>
                    <input type="text" 
                           id="amazon_client_id"
                           name="amazon_client_id" 
                           class="form-control" 
                           placeholder="Entrez votre Amazon Client ID" />
                </div>
                
                <div class="form-group">
                    <label for="amazon_client_secret">Client Secret</label>
                    <input type="password" 
                           id="amazon_client_secret"
                           name="amazon_client_secret" 
                           class="form-control" 
                           placeholder="Entrez votre Amazon Client Secret" />
                </div>
            </div>
            
            <div class="btn-actions">
                <button type="submit" name="submitConnectionAmazon" class="btn btn-primary">
                    🔗 Connecter & Tester
                </button>
                <button type="submit" name="exportProductsAmazon" class="btn btn-success">
                    📤 Exporter Produits
                </button>
                <button type="submit" name="importOrdersAmazon" class="btn btn-info">
                    📥 Importer Commandes
                </button>
                <button type="submit" name="syncStockAmazon" class="btn btn-warning">
                    🔄 Synchroniser Stock
                </button>
            </div>
        </form>
    </div>
</div>

<!-- eBay -->
<div class="panel platform-panel">
    <div class="platform-header ebay">
        <div class="platform-logo">🏷️</div>
        <span>eBay</span>
    </div>
    
    <div class="platform-body">
        <div class="connection-status status-disconnected">
            <span class="status-dot dot-disconnected"></span>
            Déconnecté
        </div>
        
        <form method="post" action="">
            <input type="hidden" name="platform" value="ebay" />
            <div class="form-row">
                <div class="form-group">
                    <label for="ebay_client_id">Client ID</label>
                    <input type="text" 
                           id="ebay_client_id"
                           name="ebay_client_id" 
                           class="form-control" 
                           placeholder="Entrez votre eBay Client ID" />
                </div>
                
                <div class="form-group">
                    <label for="ebay_client_secret">Client Secret</label>
                    <input type="password" 
                           id="ebay_client_secret"
                           name="ebay_client_secret" 
                           class="form-control" 
                           placeholder="Entrez votre eBay Client Secret" />
                </div>
            </div>
            
            <div class="btn-actions">
                <button type="submit" name="submitConnectionEbay" class="btn btn-primary">
                    🔗 Connecter & Tester
                </button>
                <button type="submit" name="exportProductsEbay" class="btn btn-success">
                    📤 Exporter Produits
                </button>
                <button type="submit" name="importOrdersEbay" class="btn btn-info">
                    📥 Importer Commandes
                </button>
                <button type="submit" name="syncStockEbay" class="btn btn-warning">
                    🔄 Synchroniser Stock
                </button>
            </div>
        </form>
    </div>
</div>

<!-- MetaShop -->
<div class="panel platform-panel">
    <div class="platform-header metashop">
        <div class="platform-logo">👥</div>
        <span>MetaShop</span>
    </div>
    
    <div class="platform-body">
        <div class="connection-status status-disconnected">
            <span class="status-dot dot-disconnected"></span>
            Déconnecté
        </div>
        
        <form method="post" action="">
            <input type="hidden" name="platform" value="metashop" />
            <div class="form-row">
                <div class="form-group">
                    <label for="metashop_client_id">Client ID</label>
                    <input type="text" 
                           id="metashop_client_id"
                           name="metashop_client_id" 
                           class="form-control" 
                           placeholder="Entrez votre MetaShop Client ID" />
                </div>
                
                <div class="form-group">
                    <label for="metashop_client_secret">Client Secret</label>
                    <input type="password" 
                           id="metashop_client_secret"
                           name="metashop_client_secret" 
                           class="form-control" 
                           placeholder="Entrez votre MetaShop Client Secret" />
                </div>
            </div>
            
            <div class="btn-actions">
                <button type="submit" name="submitConnectionMetashop" class="btn btn-primary">
                    🔗 Connecter & Tester
                </button>
                <button type="submit" name="exportProductsMetashop" class="btn btn-success">
                    📤 Exporter Produits
                </button>
                <button type="submit" name="importOrdersMetashop" class="btn btn-info">
                    📥 Importer Commandes
                </button>
                <button type="submit" name="syncStockMetashop" class="btn btn-warning">
                    🔄 Synchroniser Stock
                </button>
            </div>
        </form>
    </div>
</div>

<!-- TikTok Shop -->
<div class="panel platform-panel">
    <div class="platform-header tiktok">
        <div class="platform-logo">🎵</div>
        <span>TikTok Shop</span>
    </div>
    
    <div class="platform-body">
        <div class="connection-status status-disconnected">
            <span class="status-dot dot-disconnected"></span>
            Déconnecté
        </div>
        
        <form method="post" action="">
            <input type="hidden" name="platform" value="tiktokshop" />
            <div class="form-row">
                <div class="form-group">
                    <label for="tiktokshop_client_id">Client ID</label>
                    <input type="text" 
                           id="tiktokshop_client_id"
                           name="tiktokshop_client_id" 
                           class="form-control" 
                           placeholder="Entrez votre TikTok Shop Client ID" />
                </div>
                
                <div class="form-group">
                    <label for="tiktokshop_client_secret">Client Secret</label>
                    <input type="password" 
                           id="tiktokshop_client_secret"
                           name="tiktokshop_client_secret" 
                           class="form-control" 
                           placeholder="Entrez votre TikTok Shop Client Secret" />
                </div>
            </div>
            
            <div class="btn-actions">
                <button type="submit" name="submitConnectionTiktokshop" class="btn btn-primary">
                    🔗 Connecter & Tester
                </button>
                <button type="submit" name="exportProductsTiktokshop" class="btn btn-success">
                    📤 Exporter Produits
                </button>
                <button type="submit" name="importOrdersTiktokshop" class="btn btn-info">
                    📥 Importer Commandes
                </button>
                <button type="submit" name="syncStockTiktokshop" class="btn btn-warning">
                    🔄 Synchroniser Stock
                </button>
            </div>
        </form>
    </div>
</div>