<?php
/**
 * Module MyBridges pour PrestaShop 1.7/8
 * Connexion bilatérale aux plateformes marketplace
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class MyBridges extends Module
{
    public function __construct()
    {
        $this->name = 'mybridges';
        $this->tab = 'administration';
        $this->version = '1.0.0';
        $this->author = 'SplineOnline';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = [
            'min' => '1.7.0.0',
            'max' => _PS_VERSION_
        ];
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('My Bridges');
        $this->description = $this->l('Connexion bilatérale à MetaShop, TikTok Shop, Amazon, eBay.');
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');
    }

    /**
     * Installation du module
     */
    public function install()
    {
        if (!parent::install()) {
            return false;
        }

        // Configuration par défaut
        Configuration::updateValue('MYBRIDGES_ENABLED', 1);
        
        return true;
    }

    /**
     * Désinstallation du module
     */
    public function uninstall()
    {
        // Suppression de la configuration
        Configuration::deleteByName('MYBRIDGES_ENABLED');
        Configuration::deleteByName('MYBRIDGES_AMAZON_CLIENT_ID');
        Configuration::deleteByName('MYBRIDGES_AMAZON_CLIENT_SECRET');
        Configuration::deleteByName('MYBRIDGES_EBAY_CLIENT_ID');
        Configuration::deleteByName('MYBRIDGES_EBAY_CLIENT_SECRET');
        Configuration::deleteByName('MYBRIDGES_METASHOP_CLIENT_ID');
        Configuration::deleteByName('MYBRIDGES_METASHOP_CLIENT_SECRET');
        Configuration::deleteByName('MYBRIDGES_TIKTOK_CLIENT_ID');
        Configuration::deleteByName('MYBRIDGES_TIKTOK_CLIENT_SECRET');

        if (!parent::uninstall()) {
            return false;
        }

        return true;
    }

    /**
     * Configuration du module
     */
    public function getContent()
    {
        $output = '';
        
        // Traitement des formulaires
        if (Tools::isSubmit('submitConnection')) {
            $output .= $this->processConnectionForm();
        }
        
        if (Tools::isSubmit('exportProducts')) {
            $output .= $this->processExportProducts();
        }
        
        if (Tools::isSubmit('importOrders')) {
            $output .= $this->processImportOrders();
        }
        
        if (Tools::isSubmit('syncStock')) {
            $output .= $this->processSyncStock();
        }

        // Assignation des variables Smarty
        $this->context->smarty->assign([
            'module_dir' => $this->getPathUri(),
            'platforms' => $this->getPlatforms(),
        ]);

        return $output . $this->display(__FILE__, 'views/templates/admin/configure.tpl');
    }

    /**
     * Retourne la liste des plateformes
     */
    private function getPlatforms()
    {
        return [
            'amazon' => [
                'name' => 'Amazon',
                'logo' => 'amazon-logo.png',
                'color' => '#f0c88dff'
            ],
            'ebay' => [
                'name' => 'eBay',
                'logo' => 'ebay-logo.png',
                'color' => '#93c59eff'
            ],
            'metashop' => [
                'name' => 'MetaShop',
                'logo' => 'meta-logo.png',
                'color' => '#67a3f1ff'
            ],
            'tiktokshop' => [
                'name' => 'TikTok Shop',
                'logo' => 'tiktok-logo.png',
                'color' => '#ffaec8ff'
            ]
        ];
    }

    /**
     * Traitement du formulaire de connexion
     */
    private function processConnectionForm()
    {
        $platform = Tools::getValue('platform');
        $client_id = Tools::getValue('client_id');
        $client_secret = Tools::getValue('client_secret');

        Configuration::updateValue('MYBRIDGES_' . strtoupper($platform) . '_CLIENT_ID', $client_id);
        Configuration::updateValue('MYBRIDGES_' . strtoupper($platform) . '_CLIENT_SECRET', $client_secret);

        return $this->displayConfirmation($this->l('Configuration saved successfully for ' . $platform));
    }

    /**
     * Export des produits
     */
    private function processExportProducts()
    {
        $platform = Tools::getValue('platform');
        // Logique d'export à implémenter
        return $this->displayConfirmation($this->l('Products exported to ' . $platform));
    }

    /**
     * Import des commandes
     */
    private function processImportOrders()
    {
        $platform = Tools::getValue('platform');
        // Logique d'import à implémenter
        return $this->displayConfirmation($this->l('Orders imported from ' . $platform));
    }

    /**
     * Synchronisation du stock
     */
    private function processSyncStock()
    {
        $platform = Tools::getValue('platform');
        // Logique de sync à implémenter
        return $this->displayConfirmation($this->l('Stock synchronized with ' . $platform));
    }
}