{* views/templates/hook/displayFooter.tpl - VERSION FINALE AVEC AVATARS *}
{if isset($minichat_ajax_url)}

{* PARTIE HTML *}
<div id="minichat-widget" style="display:none;">
    <div class="minichat-header">
        <span class="minichat-title">💬 Minichat </span>
        <button class="minichat-toggle" onclick="MiniChat.toggle()">
            <span id="toggle-icon">−</span>
        </button>
    </div>
    
    <div class="minichat-body">
        {if $minichat_is_logged}
            {if !$minichat_is_banned}
                <div class="minichat-messages" id="chat-messages">
                    <div class="minichat-loading">Loading messages...</div>
                </div>
                
                <div class="minichat-input-wrapper">
                    <input type="text" 
                           id="chat-input" 
                           placeholder="Type your message..." 
                           maxlength="{$minichat_max_chars}"
                           onkeypress="if(event.keyCode==13) MiniChat.send()">
                    <button onclick="MiniChat.send()" class="minichat-send">Send</button>
                </div>
                <div class="minichat-char-counter">
                    <span id="char-count">0</span> / {$minichat_max_chars}
                </div>
            {else}
                <div class="minichat-notice">
                    <p>⛔ You have been banned from the chat.</p>
                </div>
            {/if}
        {else}
            <div class="minichat-notice">
                <p>🔒 Please login to use the chat</p>
                <a href="{$link->getPageLink('my-account')}" class="btn btn-primary">Login</a>
            </div>
        {/if}
    </div>
</div>

<button id="minichat-launcher" onclick="MiniChat.open()">
    💬 <span class="minichat-badge" id="unread-badge" style="display:none;">0</span>
</button>

{* PARTIE CSS *}
<style>
/* Chat Launcher Button */
#minichat-launcher {
    position: fixed;
    bottom: 20px;
    right: 20px;
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #667eea 0%, #d341a2 100%);
    border: none;
    border-radius: 50%;
    color: white;
    font-size: 24px;
    cursor: pointer;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    z-index: 9998;
    transition: transform 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
}

#minichat-launcher:hover {
    transform: scale(1.1);
}

.minichat-badge {
    position: absolute;
    top: -5px;
    right: -5px;
    background: #ff4444;
    color: white;
    border-radius: 10px;
    padding: 2px 6px;
    font-size: 11px;
    font-weight: bold;
}

/* Chat Widget */
#minichat-widget {
    position: fixed;
    bottom: 90px;
    right: 20px;
    width: 380px;
    height: 550px;
    background: white;
    border-radius: 12px;
    box-shadow: 0 5px 25px rgba(0,0,0,0.2);
    z-index: 9999;
    display: flex;
    flex-direction: column;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}

.minichat-header {
    background: linear-gradient(135deg, #667eea 0%, #d341a2 100%);
    color: white;
    padding: 15px;
    border-radius: 12px 12px 0 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.minichat-title {
    font-weight: 600;
    font-size: 16px;
}

.minichat-toggle {
    background: rgba(255,255,255,0.2);
    border: none;
    color: white;
    width: 30px;
    height: 30px;
    border-radius: 50%;
    cursor: pointer;
    font-size: 20px;
    line-height: 1;
    transition: background 0.3s;
}

.minichat-toggle:hover {
    background: rgba(255,255,255,0.3);
}

.minichat-body {
    display: flex;
    flex-direction: column;
    flex: 1;
    overflow: hidden;
}

.minichat-messages {
    flex: 1;
    overflow-y: auto;
    padding: 15px;
    background: #f8f9fa;
}

/* Messages avec Avatar */
.minichat-message {
    display: flex;
    margin-bottom: 15px;
    animation: fadeIn 0.3s;
    align-items: flex-start;
}

.minichat-message.own {
    flex-direction: row-reverse;
}

/* Avatar */
.minichat-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 14px;
    flex-shrink: 0;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    margin: 0 10px;
}

.minichat-message.own .minichat-avatar {
    margin-left: 10px;
    margin-right: 0;
}

/* Message Content */
.minichat-message-content {
    max-width: 65%;
    display: flex;
    flex-direction: column;
}

.minichat-message-header {
    display: flex;
    align-items: center;
    margin-bottom: 4px;
    font-size: 12px;
    color: #666;
}

.minichat-message.own .minichat-message-header {
    justify-content: flex-end;
}

.minichat-customer-name {
    font-weight: 600;
    color: #333;
    margin-right: 8px;
}

.minichat-customer-id {
    background: #e9ecef;
    padding: 2px 6px;
    border-radius: 10px;
    font-size: 10px;
    color: #6c757d;
    font-weight: 500;
    margin-right: 8px;
}

.minichat-message-time {
    color: #999;
    font-size: 10px;
}

.minichat-message.own .minichat-message-time {
    margin-left: 0;
    margin-right: 8px;
}

.minichat-bubble {
    padding: 10px 15px;
    border-radius: 18px;
    word-wrap: break-word;
    box-shadow: 0 1px 2px rgba(0,0,0,0.08);
}

.minichat-message.own .minichat-bubble {
    background: linear-gradient(135deg, #667eea 0%, #d341a2 100%);
    color: white;
    border-bottom-right-radius: 4px;
}

.minichat-message.other .minichat-bubble {
    background: white;
    border: 1px solid #e9ecef;
    border-bottom-left-radius: 4px;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

/* Input Area */
.minichat-input-wrapper {
    display: flex;
    padding: 15px;
    background: white;
    border-top: 1px solid #e0e0e0;
}

#chat-input {
    flex: 1;
    padding: 10px 15px;
    border: 1px solid #ddd;
    border-radius: 25px;
    outline: none;
    font-size: 14px;
}

#chat-input:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 2px rgba(102, 126, 234, 0.1);
}

.minichat-send {
    margin-left: 10px;
    padding: 10px 20px;
    background: linear-gradient(135deg, #667eea 0%, #d341a2 100%);
    color: white;
    border: none;
    border-radius: 25px;
    cursor: pointer;
    font-weight: 600;
    transition: transform 0.2s;
}

.minichat-send:hover {
    transform: scale(1.05);
}

.minichat-char-counter {
    padding: 0 15px 10px;
    font-size: 11px;
    color: #999;
    text-align: right;
    background: white;
    border-radius: 0 0 12px 12px;
}

.minichat-loading {
    text-align: center;
    padding: 20px;
    color: #999;
}

.minichat-notice {
    padding: 40px 20px;
    text-align: center;
}

/* Responsive */
@media (max-width: 480px) {
    #minichat-widget {
        width: calc(100% - 20px);
        right: 10px;
        left: 10px;
        bottom: 80px;
        height: 70vh;
    }
}

/* Scrollbar */
.minichat-messages::-webkit-scrollbar {
    width: 6px;
}

.minichat-messages::-webkit-scrollbar-track {
    background: #f1f1f1;
}

.minichat-messages::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 3px;
}
</style>

{* PARTIE JAVASCRIPT *}
<script>
var MiniChat = {
    url: '{$minichat_ajax_url|escape:"javascript"}',
    isLogged: {if $minichat_is_logged}true{else}false{/if},
    isBanned: {if $minichat_is_banned}true{else}false{/if},
    maxChars: {$minichat_max_chars|intval},
    refresh: {$minichat_refresh|intval},
    customerId: {$minichat_customer_id|intval},
    customerName: '{$minichat_customer_name|escape:"javascript"}',
    lastMessageId: 0,
    isOpen: false,
    timer: null,
    unreadCount: 0
};

(function() {
    'use strict';
    
    MiniChat.init = function() {
        if (!this.url) return;
        
        var input = document.getElementById('chat-input');
        if (input) {
            input.addEventListener('input', function() {
                document.getElementById('char-count').textContent = this.value.length;
            });
        }
        
        document.getElementById('minichat-widget').style.display = 'none';
        
        if (this.isLogged && !this.isBanned) {
            this.loadMessages();
        }
    };
    
    MiniChat.open = function() {
        var widget = document.getElementById('minichat-widget');
        var launcher = document.getElementById('minichat-launcher');
        
        if (widget) {
            widget.style.display = 'flex';
            launcher.style.display = 'none';
            this.isOpen = true;
            this.unreadCount = 0;
            document.getElementById('unread-badge').style.display = 'none';
            
            if (this.isLogged && !this.isBanned) {
                this.startPolling();
            }
        }
    };
    
    MiniChat.close = function() {
        var widget = document.getElementById('minichat-widget');
        var launcher = document.getElementById('minichat-launcher');
        
        if (widget) {
            widget.style.display = 'none';
            launcher.style.display = 'flex';
            this.isOpen = false;
            this.stopPolling();
        }
    };
    
    MiniChat.toggle = function() {
        if (this.isOpen) {
            this.close();
        } else {
            this.open();
        }
    };
    
    MiniChat.loadMessages = function() {
        var self = this;
        
        fetch(this.url + '?action=getMessages&lastId=' + this.lastMessageId)
            .then(function(response) {
                return response.json();
            })
            .then(function(data) {
                if (data.success && data.messages) {
                    self.displayMessages(data.messages);
                }
            })
            .catch(function(error) {
                console.error('Error loading messages:', error);
            });
    };
    
    MiniChat.displayMessages = function(messages) {
    var container = document.getElementById('chat-messages');
    if (!container) return;
    
    var loading = container.querySelector('.minichat-loading');
    if (loading) loading.remove();
    
    messages.forEach(function(msg) {
        if (document.querySelector('[data-msg-id="' + msg.id_message + '"]')) {
            return;
        }
        
        var messageDiv = document.createElement('div');
        messageDiv.className = 'minichat-message ' + (msg.is_own ? 'own' : 'other');
        messageDiv.setAttribute('data-msg-id', msg.id_message);
        
        var html = '';
        
        // AVATAR
        if (msg.avatar) {
            html += '<div class="minichat-avatar" style="background: linear-gradient(135deg, ' + 
                    msg.avatar.color1 + ' 0%, ' + msg.avatar.color2 + ' 100%);">' +
                    msg.avatar.initials + '</div>';
        }
        
        // CONTENU
        html += '<div class="minichat-message-content">';
        html += '<div class="minichat-message-header">';
        if (!msg.is_own) {
            html += '<span class="minichat-customer-name">' + MiniChat.escapeHtml(msg.display_name || 'Guest') + '</span>';
            if (msg.customer_id_display) {
                html += '<span class="minichat-customer-id">' + msg.customer_id_display + '</span>';
            }
        }
        html += '<span class="minichat-message-time">' + msg.time + '</span>';
        html += '</div>';
        html += '<div class="minichat-bubble">' + MiniChat.escapeHtml(msg.message) + '</div>';
        html += '</div>';
        
        messageDiv.innerHTML = html;
        container.appendChild(messageDiv);
        
        MiniChat.lastMessageId = Math.max(MiniChat.lastMessageId, parseInt(msg.id_message));
        
        if (!MiniChat.isOpen && !msg.is_own) {
            MiniChat.unreadCount++;
            var badge = document.getElementById('unread-badge');
            if (badge) {
                badge.textContent = MiniChat.unreadCount;
                badge.style.display = 'inline-block';
            }
        }
    });
    
    container.scrollTop = container.scrollHeight;
 };
    
    MiniChat.send = function() {
        var input = document.getElementById('chat-input');
        if (!input || !input.value.trim()) return;
        
        var message = input.value.trim();
        var self = this;
        
        var formData = new FormData();
        formData.append('action', 'sendMessage');
        formData.append('message', message);
        
        fetch(this.url, {
            method: 'POST',
            body: formData
        })
        .then(function(response) {
            return response.json();
        })
        .then(function(data) {
            if (data.success) {
                input.value = '';
                document.getElementById('char-count').textContent = '0';
                self.loadMessages();
            } else if (data.error) {
                alert(data.error);
            }
        })
        .catch(function(error) {
            console.error('Error sending message:', error);
        });
    };
    
    MiniChat.startPolling = function() {
        if (this.timer) return;
        
        var self = this;
        this.timer = setInterval(function() {
            self.loadMessages();
        }, this.refresh);
    };
    
    MiniChat.stopPolling = function() {
        if (this.timer) {
            clearInterval(this.timer);
            this.timer = null;
        }
    };
    
    MiniChat.escapeHtml = function(text) {
        var div = document.createElement('div');
        div.textContent = text;
        return div.innerHTML;
    };
    
    // Initialize when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            MiniChat.init();
        });
    } else {
        MiniChat.init();
    }
})();
</script>

<script>
// FORCER LES AVATARS ET ID CLIENT - VERSION FINALE
document.addEventListener('DOMContentLoaded', function() {
    setTimeout(function() {
        if (typeof MiniChat !== 'undefined') {
            console.log('🎨 Activation du système d\'avatars avec ID...');
            
            MiniChat.displayMessages = function(messages) {
                var container = document.getElementById('chat-messages');
                if (!container) return;
                
                var loading = container.querySelector('.minichat-loading');
                if (loading) loading.remove();
                
                messages.forEach(function(msg) {
                    if (document.querySelector('[data-msg-id="' + msg.id_message + '"]')) {
                        return;
                    }
                    
                    var messageDiv = document.createElement('div');
                    messageDiv.className = 'minichat-message ' + (msg.is_own ? 'own' : 'other');
                    messageDiv.setAttribute('data-msg-id', msg.id_message);
                    
                    // Générer les initiales
                    var initials = 'U';
                    var colors = ['#667eea', '#d341a2'];
                    
                    if (msg.avatar && msg.avatar.initials) {
                        initials = msg.avatar.initials;
                        colors = [msg.avatar.color1, msg.avatar.color2];
                    } else if (msg.display_name) {
                        var parts = msg.display_name.split(' ');
                        initials = parts[0].charAt(0).toUpperCase();
                        if (parts.length > 1) {
                            initials += parts[1].charAt(0).toUpperCase();
                        }
                    }
                    
                    // FORCER L'ID CLIENT - TOUJOURS L'AFFICHER
                    var customerId = '';
                    if (msg.customer_id_display) {
                        customerId = msg.customer_id_display;
                    } else if (msg.id_customer) {
                        // Créer l'ID à partir de id_customer
                        customerId = '#' + String(msg.id_customer).padStart(4, '0');
                    } else {
                        // ID par défaut si rien n'existe
                        customerId = '#0000';
                    }
                    
                    // Construire le HTML
                    var html = '<div class="minichat-avatar" style="background: linear-gradient(135deg, ' + 
                            colors[0] + ', ' + colors[1] + ');">' + initials + '</div>';
                    
                    html += '<div class="minichat-message-content">';
                    html += '<div class="minichat-message-header">';
                    
                    // TOUJOURS afficher nom et ID pour les messages des autres
                    if (!msg.is_own) {
                        html += '<span class="minichat-customer-name">' + (msg.display_name || 'Guest') + '</span>';
                        html += '<span class="minichat-customer-id" style="background:#e9ecef;padding:2px 6px;border-radius:10px;font-size:10px;color:#6c757d;margin:0 5px;">' + customerId + '</span>';
                    } else {
                        // Pour nos propres messages, afficher juste l'ID à droite
                        html += '<span class="minichat-customer-id" style="background:#e9ecef;padding:2px 6px;border-radius:10px;font-size:10px;color:#6c757d;margin:0 5px;">Vous ' + customerId + '</span>';
                    }
                    
                    html += '<span class="minichat-message-time">' + (msg.time || '') + '</span>';
                    html += '</div>';
                    html += '<div class="minichat-bubble">' + (msg.message || '') + '</div>';
                    html += '</div>';
                    
                    messageDiv.innerHTML = html;
                    container.appendChild(messageDiv);
                    
                    MiniChat.lastMessageId = Math.max(MiniChat.lastMessageId, parseInt(msg.id_message));
                });
                
                container.scrollTop = container.scrollHeight;
            };
            
            // Recharger immédiatement
            console.log('✅ Avatars et ID clients activés !');
            console.log('📝 Format ID: #0001, #0002, etc.');
            document.getElementById('chat-messages').innerHTML = '';
            MiniChat.lastMessageId = 0;
            MiniChat.loadMessages();
        }
    }, 1500);
});
</script>

{/if}