<?php

class MiniChatApiModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();
        
        header('Content-Type: application/json');
        
        if (!Configuration::get('MINICHAT_ENABLED')) {
            die(json_encode(['error' => 'Chat is disabled']));
        }
        
        $action = Tools::getValue('action');
        
        switch ($action) {
            case 'getMessages':
                $this->getMessages();
                break;
                
            case 'sendMessage':
                $this->sendMessage();
                break;
                
            case 'sendAdminMessage':
                $this->sendAdminMessage();
                break;
                
            case 'deleteMessage':
                $this->deleteMessage();
                break;
                
            default:
                die(json_encode(['error' => 'Action not recognized: ' . $action]));
        }
    }
    
    private function getMessages()
    {
        $lastId = (int)Tools::getValue('lastId', 0);
        $limit = (int)Configuration::get('MINICHAT_MAX_MESSAGES', 50000);
        
        $sql = 'SELECT m.*, 
                CASE 
                    WHEN m.id_employee > 0 THEN e.firstname
                    ELSE c.firstname
                END as firstname,
                CASE 
                    WHEN m.id_employee > 0 THEN e.lastname
                    ELSE c.lastname
                END as lastname,
                m.id_employee
                FROM `'._DB_PREFIX_.'minichat_messages` m
                LEFT JOIN `'._DB_PREFIX_.'customer` c ON m.id_customer = c.id_customer
                LEFT JOIN `'._DB_PREFIX_.'employee` e ON m.id_employee = e.id_employee
                WHERE m.is_deleted = 0 AND m.id_message > '.$lastId.'
                ORDER BY m.id_message ASC
                LIMIT '.$limit;
        
        $messages = Db::getInstance()->executeS($sql);
        
        if (!$messages) {
            $messages = [];
        }
        
        $currentCustomerId = (int)$this->context->customer->id;
        
        foreach ($messages as &$msg) {
            // Générer les initiales pour l'avatar
            $initials = '';
            $isAdmin = ($msg['id_employee'] > 0);
            
            if (!empty($msg['firstname'])) {
                $initials = strtoupper(substr($msg['firstname'], 0, 1));
                if (!empty($msg['lastname'])) {
                    $initials .= strtoupper(substr($msg['lastname'], 0, 1));
                }
            } else {
                $initials = 'G'; // Guest
            }
            
            // Couleurs pour l'avatar
            $colors = [
                ['#667eea', '#764ba2'], // Violet
                ['#f093fb', '#f5576c'], // Rose
                ['#4facfe', '#00f2fe'], // Bleu
                ['#43e97b', '#38f9d7'], // Vert
                ['#fa709a', '#fee140'], // Sunset
                ['#30cfd0', '#330867'], // Ocean
            ];
            
            // Pour les admins, utiliser une couleur spéciale
            if ($isAdmin) {
                $colors = [['#f70c0cff', '#fc9761ff']]; // Rouge/Orange pour admin
                $colorIndex = 0;
            } else {
                $colorIndex = $msg['id_customer'] % count($colors);
            }
            
            // AJOUTER L'AVATAR AU MESSAGE
            $msg['avatar'] = [
                'initials' => $initials,
                'color1' => $colors[$colorIndex][0],
                'color2' => $colors[$colorIndex][1]
            ];
            
            // ID CLIENT FORMATÉ
            if ($isAdmin) {
                $msg['customer_id_display'] = 'ADMIN';
            } else {
                $msg['customer_id_display'] = '#' . str_pad($msg['id_customer'], 4, '0', STR_PAD_LEFT);
            }
            
            // Nom d'affichage
            if ($isAdmin) {
                $msg['display_name'] = 'Admin ' . $msg['firstname'];
            } else {
                $msg['display_name'] = !empty($msg['firstname']) ? $msg['firstname'] : 'Guest';
            }
            
            // Est-ce notre message ?
            $msg['is_own'] = (!$isAdmin && (int)$msg['id_customer'] === $currentCustomerId);
            
            // Heure
            $msg['time'] = date('H:i', strtotime($msg['date_add']));
        }
        
        die(json_encode([
            'success' => true,
            'messages' => $messages
        ]));
    }
    
    private function sendMessage()
    {
        if (!$this->context->customer->isLogged()) {
            die(json_encode(['error' => 'Please login to send messages']));
        }
        
        $customerId = (int)$this->context->customer->id;
        
        $module = Module::getInstanceByName('minichat');
        if ($module && method_exists($module, 'isCustomerBanned')) {
            if ($module->isCustomerBanned($customerId)) {
                die(json_encode(['error' => 'You are banned from chat']));
            }
        }
        
        $message = trim(Tools::getValue('message'));
        $maxChars = (int)Configuration::get('MINICHAT_MAX_CHARS', 200);
        
        if (empty($message)) {
            die(json_encode(['error' => 'Message cannot be empty']));
        }
        
        if (strlen($message) > $maxChars) {
            $message = substr($message, 0, $maxChars);
        }
        
        $sql = 'INSERT INTO `'._DB_PREFIX_.'minichat_messages` 
                (`id_customer`, `id_employee`, `message`, `date_add`, `is_deleted`) 
                VALUES ('.$customerId.', 0, 
                        "'.pSQL($message).'", 
                        "'.date('Y-m-d H:i:s').'",
                        0)';
        
        if (Db::getInstance()->execute($sql)) {
            die(json_encode(['success' => true]));
        }
        
        die(json_encode(['error' => 'Failed to send message']));
    }
    
    private function sendAdminMessage()
    {
        // Vérifier qu'on est bien appelé depuis le back-office
        $token = Tools::getValue('admin_token');
        $employeeId = (int)Tools::getValue('id_employee');
        
        // Validation simple du token
        if (!$token || !$employeeId) {
            die(json_encode(['error' => 'Unauthorized']));
        }
        
        // Vérifier que l'employé existe
        $sql = 'SELECT id_employee FROM `'._DB_PREFIX_.'employee` WHERE id_employee = '.$employeeId.' AND active = 1';
        if (!Db::getInstance()->getValue($sql)) {
            die(json_encode(['error' => 'Invalid employee']));
        }
        
        $message = trim(Tools::getValue('message'));
        $maxChars = (int)Configuration::get('MINICHAT_MAX_CHARS', 200);
        
        if (empty($message)) {
            die(json_encode(['error' => 'Message cannot be empty']));
        }
        
        if (strlen($message) > $maxChars) {
            $message = substr($message, 0, $maxChars);
        }
        
        $sql = 'INSERT INTO `'._DB_PREFIX_.'minichat_messages` 
                (`id_customer`, `id_employee`, `message`, `date_add`, `is_deleted`) 
                VALUES (0, '.$employeeId.', 
                        "'.pSQL($message).'", 
                        "'.date('Y-m-d H:i:s').'",
                        0)';
        
        if (Db::getInstance()->execute($sql)) {
            die(json_encode(['success' => true]));
        }
        
        die(json_encode(['error' => 'Failed to send message']));
    }
    
    private function deleteMessage()
    {
        // Vérifier qu'on est bien appelé depuis le back-office
        $token = Tools::getValue('admin_token');
        $employeeId = (int)Tools::getValue('id_employee');
        $messageId = (int)Tools::getValue('message_id');
        
        // Validation
        if (!$token || !$employeeId || !$messageId) {
            die(json_encode(['error' => 'Unauthorized or invalid parameters']));
        }
        
        // Vérifier que l'employé existe et est actif
        $sql = 'SELECT id_employee FROM `'._DB_PREFIX_.'employee` WHERE id_employee = '.$employeeId.' AND active = 1';
        if (!Db::getInstance()->getValue($sql)) {
            die(json_encode(['error' => 'Invalid employee']));
        }
        
        // Soft delete du message (on le marque comme supprimé sans l'effacer)
        $sql = 'UPDATE `'._DB_PREFIX_.'minichat_messages` 
                SET is_deleted = 1 
                WHERE id_message = '.$messageId;
        
        if (Db::getInstance()->execute($sql)) {
            die(json_encode(['success' => true, 'message' => 'Message deleted successfully']));
        }
        
        die(json_encode(['error' => 'Failed to delete message']));
    }
}