<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Core\Grid\Definition\GridDefinition;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\DataColumn;
use PrestaShop\PrestaShop\Core\Grid\Query\DoctrineQueryBuilderInterface;

class AddressAddon extends Module
{
    public function __construct()
    {
        $this->name = 'addressaddon';
        $this->version = '1.0.0';
        $this->author = 'SplineOnline';
        $this->tab = 'administration';
        $this->need_instance = 0;
        $this->bootstrap = true;
        $this->ps_versions_compliancy = ['min' => '8.0.0', 'max' => _PS_VERSION_];

        parent::__construct();

        $this->displayName = $this->l('Address Addon');
        $this->description = $this->l('Ajoute email et téléphone mobile dans la liste des adresses (Back-office PS 8).');
    }

    public function install()
    {
        return parent::install()
            && $this->registerHook('actionAddressGridDefinitionModifier')
            && $this->registerHook('actionAddressGridQueryBuilderModifier');
    }

    /**
     * Ajout des colonnes dans la définition du grid
     */
    public function hookActionAddressGridDefinitionModifier(array $params)
    {
        /** @var GridDefinition $definition */
        $definition = $params['definition'];

        // Ajout de la colonne Email (à la fin)
        $definition->getColumns()->add(
            (new DataColumn('email'))
                ->setName($this->l('Email'))
                ->setOptions([
                    'field' => 'email',
                ])
        );

        // Ajout de la colonne Téléphone (pour résoudre l'erreur)
        $definition->getColumns()->add(
            (new DataColumn('phone'))
                ->setName($this->l('Téléphone'))
                ->setOptions([
                    'field' => 'phone',
                ])
        );
        
        // Ajout de la colonne Téléphone mobile (à la fin)
        $definition->getColumns()->add(
            (new DataColumn('phone_mobile'))
                ->setName($this->l('Téléphone mobile'))
                ->setOptions([
                    'field' => 'phone_mobile',
                ])
        );
    }

    /**
     * Modification du QueryBuilder pour récupérer les champs
     */
    public function hookActionAddressGridQueryBuilderModifier(array $params)
    {
        /** @var DoctrineQueryBuilderInterface $searchQueryBuilder */
        $searchQueryBuilder = $params['search_query_builder'];

        // Ajout des champs
        $searchQueryBuilder->addSelect('cu.email, a.phone, a.phone_mobile');

        // Jointure avec ps_customer en utilisant un alias unique 'cu'
        $searchQueryBuilder->leftJoin(
            'a',
            _DB_PREFIX_.'customer',
            'cu',
            'a.id_customer = cu.id_customer'
        );
    }
}